/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.textinput;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.text.Editable;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.KeyListener;
import android.text.method.QwertyKeyListener;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.common.build.ReactBuildConfig;
import com.facebook.react.uimanager.FabricViewStateManager;
import com.facebook.react.uimanager.ReactAccessibilityDelegate;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.text.CustomLetterSpacingSpan;
import com.facebook.react.views.text.CustomLineHeightSpan;
import com.facebook.react.views.text.CustomStyleSpan;
import com.facebook.react.views.text.ReactAbsoluteSizeSpan;
import com.facebook.react.views.text.ReactBackgroundColorSpan;
import com.facebook.react.views.text.ReactForegroundColorSpan;
import com.facebook.react.views.text.ReactSpan;
import com.facebook.react.views.text.ReactStrikethroughSpan;
import com.facebook.react.views.text.ReactTextUpdate;
import com.facebook.react.views.text.ReactTypefaceUtils;
import com.facebook.react.views.text.ReactUnderlineSpan;
import com.facebook.react.views.text.TextAttributes;
import com.facebook.react.views.text.TextInlineImageSpan;
import com.facebook.react.views.text.TextLayoutManager;
import com.facebook.react.views.textinput.ContentSizeWatcher;
import com.facebook.react.views.textinput.ReactEditTextInputConnectionWrapper;
import com.facebook.react.views.textinput.ReactTextInputLocalData;
import com.facebook.react.views.textinput.ScrollWatcher;
import com.facebook.react.views.textinput.SelectionWatcher;
import com.facebook.react.views.view.ReactViewBackgroundManager;
import java.util.ArrayList;
import java.util.Objects;

public class ReactEditText
extends AppCompatEditText
implements FabricViewStateManager.HasFabricViewStateManager {
    private final InputMethodManager mInputMethodManager;
    private final String TAG = ReactEditText.class.getSimpleName();
    public static final boolean DEBUG_MODE;
    protected boolean mIsSettingTextFromJS;
    private int mDefaultGravityHorizontal;
    private int mDefaultGravityVertical;
    protected int mNativeEventCount;
    private static final int UNSET = -1;
    @Nullable
    private ArrayList<TextWatcher> mListeners;
    @Nullable
    private TextWatcherDelegator mTextWatcherDelegator;
    private int mStagedInputType;
    protected boolean mContainsImages;
    @Nullable
    private String mSubmitBehavior = null;
    private boolean mDisableFullscreen;
    @Nullable
    private String mReturnKeyType;
    @Nullable
    private SelectionWatcher mSelectionWatcher;
    @Nullable
    private ContentSizeWatcher mContentSizeWatcher;
    @Nullable
    private ScrollWatcher mScrollWatcher;
    private InternalKeyListener mKeyListener;
    private boolean mDetectScrollMovement = false;
    private boolean mOnKeyPress = false;
    private TextAttributes mTextAttributes;
    private boolean mTypefaceDirty = false;
    @Nullable
    private String mFontFamily = null;
    private int mFontWeight = -1;
    private int mFontStyle = -1;
    private boolean mAutoFocus = false;
    private boolean mDidAttachToWindow = false;
    @Nullable
    private String mPlaceholder = null;
    private ReactViewBackgroundManager mReactBackgroundManager;
    private final FabricViewStateManager mFabricViewStateManager = new FabricViewStateManager();
    protected boolean mDisableTextDiffing = false;
    protected boolean mIsSettingTextFromState = false;
    private static final KeyListener sKeyListener;
    @Nullable
    private EventDispatcher mEventDispatcher;

    public ReactEditText(Context context) {
        super(context);
        this.setFocusableInTouchMode(false);
        this.mReactBackgroundManager = new ReactViewBackgroundManager((View)this);
        this.mInputMethodManager = (InputMethodManager)Assertions.assertNotNull((Object)context.getSystemService("input_method"));
        this.mDefaultGravityHorizontal = this.getGravity() & 0x800007;
        this.mDefaultGravityVertical = this.getGravity() & 0x70;
        this.mNativeEventCount = 0;
        this.mIsSettingTextFromJS = false;
        this.mDisableFullscreen = false;
        this.mListeners = null;
        this.mTextWatcherDelegator = null;
        this.mStagedInputType = this.getInputType();
        if (this.mKeyListener == null) {
            this.mKeyListener = new InternalKeyListener();
        }
        this.mScrollWatcher = null;
        this.mTextAttributes = new TextAttributes();
        this.applyTextAttributes();
        if (Build.VERSION.SDK_INT >= 26 && Build.VERSION.SDK_INT <= 27) {
            this.setLayerType(1, null);
        }
        ReactAccessibilityDelegate editTextAccessibilityDelegate = new ReactAccessibilityDelegate((View)this, this.isFocusable(), this.getImportantForAccessibility()){

            @Override
            public boolean performAccessibilityAction(View host, int action, Bundle args) {
                if (action == 16) {
                    int length = ReactEditText.this.getText().length();
                    if (length > 0) {
                        ReactEditText.this.setSelection(length);
                    }
                    return ReactEditText.this.requestFocusInternal();
                }
                return super.performAccessibilityAction(host, action, args);
            }
        };
        ViewCompat.setAccessibilityDelegate((View)this, (AccessibilityDelegateCompat)editTextAccessibilityDelegate);
    }

    protected void finalize() {
        if (DEBUG_MODE) {
            FLog.e((String)this.TAG, (String)("finalize[" + this.getId() + "] delete cached spannable"));
        }
        TextLayoutManager.deleteCachedSpannableForTag(this.getId());
    }

    public boolean isLayoutRequested() {
        return false;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.onContentSizeChange();
    }

    public boolean onTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.mDetectScrollMovement = true;
                this.getParent().requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 2: {
                if (!this.mDetectScrollMovement) break;
                if (!(this.canScrollVertically(-1) || this.canScrollVertically(1) || this.canScrollHorizontally(-1) || this.canScrollHorizontally(1))) {
                    this.getParent().requestDisallowInterceptTouchEvent(false);
                }
                this.mDetectScrollMovement = false;
            }
        }
        return super.onTouchEvent(ev);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 66 && !this.isMultiline()) {
            this.hideSoftKeyboard();
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    protected void onScrollChanged(int horiz, int vert, int oldHoriz, int oldVert) {
        super.onScrollChanged(horiz, vert, oldHoriz, oldVert);
        if (this.mScrollWatcher != null) {
            this.mScrollWatcher.onScrollChanged(horiz, vert, oldHoriz, oldVert);
        }
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        ReactContext reactContext = UIManagerHelper.getReactContext((View)this);
        Object inputConnection = super.onCreateInputConnection(outAttrs);
        if (inputConnection != null && this.mOnKeyPress) {
            inputConnection = new ReactEditTextInputConnectionWrapper((InputConnection)inputConnection, reactContext, this, this.mEventDispatcher);
        }
        if (this.isMultiline() && (this.shouldBlurOnReturn() || this.shouldSubmitOnReturn())) {
            outAttrs.imeOptions &= 0xBFFFFFFF;
        }
        return inputConnection;
    }

    public void clearFocus() {
        this.setFocusableInTouchMode(false);
        super.clearFocus();
        this.hideSoftKeyboard();
    }

    public boolean requestFocus(int direction, Rect previouslyFocusedRect) {
        return this.isFocused();
    }

    private boolean requestFocusInternal() {
        this.setFocusableInTouchMode(true);
        boolean focused = super.requestFocus(130, null);
        if (this.getShowSoftInputOnFocus()) {
            this.showSoftKeyboard();
        }
        return focused;
    }

    public void addTextChangedListener(TextWatcher watcher) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
            super.addTextChangedListener((TextWatcher)this.getTextWatcherDelegator());
        }
        this.mListeners.add(watcher);
    }

    public void removeTextChangedListener(TextWatcher watcher) {
        if (this.mListeners != null) {
            this.mListeners.remove(watcher);
            if (this.mListeners.isEmpty()) {
                this.mListeners = null;
                super.removeTextChangedListener((TextWatcher)this.getTextWatcherDelegator());
            }
        }
    }

    public void setContentSizeWatcher(ContentSizeWatcher contentSizeWatcher) {
        this.mContentSizeWatcher = contentSizeWatcher;
    }

    public void setScrollWatcher(ScrollWatcher scrollWatcher) {
        this.mScrollWatcher = scrollWatcher;
    }

    public void maybeSetSelection(int eventCounter, int start, int end) {
        if (!this.canUpdateWithEventCount(eventCounter)) {
            return;
        }
        if (start != -1 && end != -1) {
            start = this.clampToTextLength(start);
            end = this.clampToTextLength(end);
            this.setSelection(start, end);
        }
    }

    private int clampToTextLength(int value) {
        int textLength = this.getText() == null ? 0 : this.getText().length();
        return Math.max(0, Math.min(value, textLength));
    }

    public void setSelection(int start, int end) {
        if (DEBUG_MODE) {
            FLog.e((String)this.TAG, (String)("setSelection[" + this.getId() + "]: " + start + " " + end));
        }
        super.setSelection(start, end);
    }

    protected void onSelectionChanged(int selStart, int selEnd) {
        if (DEBUG_MODE) {
            FLog.e((String)this.TAG, (String)("onSelectionChanged[" + this.getId() + "]: " + selStart + " " + selEnd));
        }
        super.onSelectionChanged(selStart, selEnd);
        if (this.mSelectionWatcher != null && this.hasFocus()) {
            this.mSelectionWatcher.onSelectionChanged(selStart, selEnd);
        }
    }

    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        if (focused && this.mSelectionWatcher != null) {
            this.mSelectionWatcher.onSelectionChanged(this.getSelectionStart(), this.getSelectionEnd());
        }
    }

    public void setSelectionWatcher(SelectionWatcher selectionWatcher) {
        this.mSelectionWatcher = selectionWatcher;
    }

    public void setOnKeyPress(boolean onKeyPress) {
        this.mOnKeyPress = onKeyPress;
    }

    public boolean shouldBlurOnReturn() {
        String submitBehavior = this.getSubmitBehavior();
        boolean shouldBlur = submitBehavior == null ? !this.isMultiline() : submitBehavior.equals("blurAndSubmit");
        return shouldBlur;
    }

    public boolean shouldSubmitOnReturn() {
        String submitBehavior = this.getSubmitBehavior();
        boolean shouldSubmit = submitBehavior == null ? !this.isMultiline() : submitBehavior.equals("submit") || submitBehavior.equals("blurAndSubmit");
        return shouldSubmit;
    }

    public String getSubmitBehavior() {
        return this.mSubmitBehavior;
    }

    public void setSubmitBehavior(String submitBehavior) {
        this.mSubmitBehavior = submitBehavior;
    }

    public void setDisableFullscreenUI(boolean disableFullscreenUI) {
        this.mDisableFullscreen = disableFullscreenUI;
        this.updateImeOptions();
    }

    public boolean getDisableFullscreenUI() {
        return this.mDisableFullscreen;
    }

    public void setReturnKeyType(String returnKeyType) {
        this.mReturnKeyType = returnKeyType;
        this.updateImeOptions();
    }

    public String getReturnKeyType() {
        return this.mReturnKeyType;
    }

    int getStagedInputType() {
        return this.mStagedInputType;
    }

    void setStagedInputType(int stagedInputType) {
        this.mStagedInputType = stagedInputType;
    }

    void commitStagedInputType() {
        if (this.getInputType() != this.mStagedInputType) {
            int selectionStart = this.getSelectionStart();
            int selectionEnd = this.getSelectionEnd();
            this.setInputType(this.mStagedInputType);
            this.setSelection(selectionStart, selectionEnd);
        }
    }

    public void setInputType(int type) {
        Typeface tf = super.getTypeface();
        super.setInputType(type);
        this.mStagedInputType = type;
        super.setTypeface(tf);
        if (this.isMultiline()) {
            this.setSingleLine(false);
        }
        if (this.mKeyListener == null) {
            this.mKeyListener = new InternalKeyListener();
        }
        this.mKeyListener.setInputType(type);
        this.setKeyListener(this.mKeyListener);
    }

    public void setPlaceholder(@Nullable String placeholder) {
        if (!Objects.equals(placeholder, this.mPlaceholder)) {
            this.mPlaceholder = placeholder;
            this.setHint(placeholder);
        }
    }

    public void setFontFamily(String fontFamily) {
        this.mFontFamily = fontFamily;
        this.mTypefaceDirty = true;
    }

    public void setFontWeight(String fontWeightString) {
        int fontWeight = ReactTypefaceUtils.parseFontWeight(fontWeightString);
        if (fontWeight != this.mFontWeight) {
            this.mFontWeight = fontWeight;
            this.mTypefaceDirty = true;
        }
    }

    public void setFontStyle(String fontStyleString) {
        int fontStyle = ReactTypefaceUtils.parseFontStyle(fontStyleString);
        if (fontStyle != this.mFontStyle) {
            this.mFontStyle = fontStyle;
            this.mTypefaceDirty = true;
        }
    }

    public void setFontFeatureSettings(String fontFeatureSettings) {
        if (!Objects.equals(fontFeatureSettings, this.getFontFeatureSettings())) {
            super.setFontFeatureSettings(fontFeatureSettings);
            this.mTypefaceDirty = true;
        }
    }

    public void maybeUpdateTypeface() {
        if (!this.mTypefaceDirty) {
            return;
        }
        this.mTypefaceDirty = false;
        Typeface newTypeface = ReactTypefaceUtils.applyStyles(this.getTypeface(), this.mFontStyle, this.mFontWeight, this.mFontFamily, this.getContext().getAssets());
        this.setTypeface(newTypeface);
        if (this.mFontStyle != -1 || this.mFontWeight != -1 || this.mFontFamily != null || this.getFontFeatureSettings() != null) {
            this.setPaintFlags(this.getPaintFlags() | 0x80);
        } else {
            this.setPaintFlags(this.getPaintFlags() & 0xFFFFFF7F);
        }
    }

    public void requestFocusFromJS() {
        this.requestFocusInternal();
    }

    void clearFocusFromJS() {
        this.clearFocus();
    }

    public int incrementAndGetEventCounter() {
        return ++this.mNativeEventCount;
    }

    public void maybeSetTextFromJS(ReactTextUpdate reactTextUpdate) {
        this.mIsSettingTextFromJS = true;
        this.maybeSetText(reactTextUpdate);
        this.mIsSettingTextFromJS = false;
    }

    public void maybeSetTextFromState(ReactTextUpdate reactTextUpdate) {
        this.mIsSettingTextFromState = true;
        this.maybeSetText(reactTextUpdate);
        this.mIsSettingTextFromState = false;
    }

    public boolean canUpdateWithEventCount(int eventCounter) {
        return eventCounter >= this.mNativeEventCount;
    }

    public void maybeSetText(ReactTextUpdate reactTextUpdate) {
        if (this.isSecureText() && TextUtils.equals((CharSequence)this.getText(), (CharSequence)reactTextUpdate.getText())) {
            return;
        }
        if (!this.canUpdateWithEventCount(reactTextUpdate.getJsEventCounter())) {
            return;
        }
        if (DEBUG_MODE) {
            FLog.e((String)this.TAG, (String)("maybeSetText[" + this.getId() + "]: current text: " + this.getText() + " update: " + reactTextUpdate.getText()));
        }
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)reactTextUpdate.getText());
        this.manageSpans(spannableStringBuilder);
        this.stripStyleEquivalentSpans(spannableStringBuilder);
        this.mContainsImages = reactTextUpdate.containsImages();
        this.mDisableTextDiffing = true;
        if (reactTextUpdate.getText().length() == 0) {
            this.setText(null);
        } else {
            this.getText().replace(0, this.length(), (CharSequence)spannableStringBuilder);
        }
        this.mDisableTextDiffing = false;
        if (Build.VERSION.SDK_INT >= 23 && this.getBreakStrategy() != reactTextUpdate.getTextBreakStrategy()) {
            this.setBreakStrategy(reactTextUpdate.getTextBreakStrategy());
        }
        this.updateCachedSpannable();
    }

    private void manageSpans(SpannableStringBuilder spannableStringBuilder) {
        Object[] spans = this.getText().getSpans(0, this.length(), Object.class);
        for (int spanIdx = 0; spanIdx < spans.length; ++spanIdx) {
            boolean isExclusiveExclusive;
            Object span = spans[spanIdx];
            int spanFlags = this.getText().getSpanFlags(span);
            boolean bl = isExclusiveExclusive = (spanFlags & 0x21) == 33;
            if (span instanceof ReactSpan) {
                this.getText().removeSpan(span);
            }
            if (!isExclusiveExclusive) continue;
            int spanStart = this.getText().getSpanStart(span);
            int spanEnd = this.getText().getSpanEnd(span);
            this.getText().removeSpan(span);
            if (!ReactEditText.sameTextForSpan(this.getText(), spannableStringBuilder, spanStart, spanEnd)) continue;
            spannableStringBuilder.setSpan(span, spanStart, spanEnd, spanFlags);
        }
    }

    private void stripStyleEquivalentSpans(SpannableStringBuilder sb) {
        this.stripSpansOfKind(sb, ReactAbsoluteSizeSpan.class, new SpanPredicate<ReactAbsoluteSizeSpan>(){

            @Override
            public boolean test(ReactAbsoluteSizeSpan span) {
                return span.getSize() == ReactEditText.this.mTextAttributes.getEffectiveFontSize();
            }
        });
        this.stripSpansOfKind(sb, ReactBackgroundColorSpan.class, new SpanPredicate<ReactBackgroundColorSpan>(){

            @Override
            public boolean test(ReactBackgroundColorSpan span) {
                return span.getBackgroundColor() == ReactEditText.this.mReactBackgroundManager.getBackgroundColor();
            }
        });
        this.stripSpansOfKind(sb, ReactForegroundColorSpan.class, new SpanPredicate<ReactForegroundColorSpan>(){

            @Override
            public boolean test(ReactForegroundColorSpan span) {
                return span.getForegroundColor() == ReactEditText.this.getCurrentTextColor();
            }
        });
        this.stripSpansOfKind(sb, ReactStrikethroughSpan.class, new SpanPredicate<ReactStrikethroughSpan>(){

            @Override
            public boolean test(ReactStrikethroughSpan span) {
                return (ReactEditText.this.getPaintFlags() & 0x10) != 0;
            }
        });
        this.stripSpansOfKind(sb, ReactUnderlineSpan.class, new SpanPredicate<ReactUnderlineSpan>(){

            @Override
            public boolean test(ReactUnderlineSpan span) {
                return (ReactEditText.this.getPaintFlags() & 8) != 0;
            }
        });
        if (Build.VERSION.SDK_INT >= 21) {
            this.stripSpansOfKind(sb, CustomLetterSpacingSpan.class, new SpanPredicate<CustomLetterSpacingSpan>(){

                @Override
                public boolean test(CustomLetterSpacingSpan span) {
                    return span.getSpacing() == ReactEditText.this.mTextAttributes.getEffectiveLetterSpacing();
                }
            });
        }
        this.stripSpansOfKind(sb, CustomStyleSpan.class, new SpanPredicate<CustomStyleSpan>(){

            @Override
            public boolean test(CustomStyleSpan span) {
                return span.getStyle() == ReactEditText.this.mFontStyle && Objects.equals(span.getFontFamily(), ReactEditText.this.mFontFamily) && span.getWeight() == ReactEditText.this.mFontWeight && Objects.equals(span.getFontFeatureSettings(), ReactEditText.this.getFontFeatureSettings());
            }
        });
    }

    private <T> void stripSpansOfKind(SpannableStringBuilder sb, Class<T> clazz, SpanPredicate<T> shouldStrip) {
        Object[] spans;
        for (Object span : spans = sb.getSpans(0, sb.length(), clazz)) {
            if (!shouldStrip.test(span)) continue;
            sb.removeSpan(span);
        }
    }

    private void addSpansFromStyleAttributes(SpannableStringBuilder workingText) {
        float lineHeight;
        float effectiveLetterSpacing;
        int spanFlags = 18;
        workingText.setSpan((Object)new ReactAbsoluteSizeSpan(this.mTextAttributes.getEffectiveFontSize()), 0, workingText.length(), spanFlags |= 0xFF0000);
        workingText.setSpan((Object)new ReactForegroundColorSpan(this.getCurrentTextColor()), 0, workingText.length(), spanFlags);
        int backgroundColor = this.mReactBackgroundManager.getBackgroundColor();
        if (backgroundColor != 0) {
            workingText.setSpan((Object)new ReactBackgroundColorSpan(backgroundColor), 0, workingText.length(), spanFlags);
        }
        if ((this.getPaintFlags() & 0x10) != 0) {
            workingText.setSpan((Object)new ReactStrikethroughSpan(), 0, workingText.length(), spanFlags);
        }
        if ((this.getPaintFlags() & 8) != 0) {
            workingText.setSpan((Object)new ReactUnderlineSpan(), 0, workingText.length(), spanFlags);
        }
        if (Build.VERSION.SDK_INT >= 21 && !Float.isNaN(effectiveLetterSpacing = this.mTextAttributes.getEffectiveLetterSpacing())) {
            workingText.setSpan((Object)new CustomLetterSpacingSpan(effectiveLetterSpacing), 0, workingText.length(), spanFlags);
        }
        if (this.mFontStyle != -1 || this.mFontWeight != -1 || this.mFontFamily != null || this.getFontFeatureSettings() != null) {
            workingText.setSpan((Object)new CustomStyleSpan(this.mFontStyle, this.mFontWeight, this.getFontFeatureSettings(), this.mFontFamily, this.getContext().getAssets()), 0, workingText.length(), spanFlags);
        }
        if (!Float.isNaN(lineHeight = this.mTextAttributes.getEffectiveLineHeight())) {
            workingText.setSpan((Object)new CustomLineHeightSpan(lineHeight), 0, workingText.length(), spanFlags);
        }
    }

    private static boolean sameTextForSpan(Editable oldText, SpannableStringBuilder newText, int start, int end) {
        if (start > newText.length() || end > newText.length()) {
            return false;
        }
        for (int charIdx = start; charIdx < end; ++charIdx) {
            if (oldText.charAt(charIdx) == newText.charAt(charIdx)) continue;
            return false;
        }
        return true;
    }

    protected boolean showSoftKeyboard() {
        return this.mInputMethodManager.showSoftInput((View)this, 0);
    }

    protected void hideSoftKeyboard() {
        this.mInputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
    }

    private TextWatcherDelegator getTextWatcherDelegator() {
        if (this.mTextWatcherDelegator == null) {
            this.mTextWatcherDelegator = new TextWatcherDelegator();
        }
        return this.mTextWatcherDelegator;
    }

    boolean isMultiline() {
        return (this.getInputType() & 0x20000) != 0;
    }

    private boolean isSecureText() {
        return (this.getInputType() & 0x90) != 0;
    }

    private void onContentSizeChange() {
        if (this.mContentSizeWatcher != null) {
            this.mContentSizeWatcher.onLayout();
        }
        this.setIntrinsicContentSize();
    }

    private void setIntrinsicContentSize() {
        ReactContext reactContext = UIManagerHelper.getReactContext((View)this);
        if (this.mFabricViewStateManager != null && !this.mFabricViewStateManager.hasStateWrapper() && !reactContext.isBridgeless()) {
            ReactTextInputLocalData localData = new ReactTextInputLocalData((EditText)this);
            UIManagerModule uiManager = reactContext.getNativeModule(UIManagerModule.class);
            if (uiManager != null) {
                uiManager.setViewLocalData(this.getId(), localData);
            }
        }
    }

    int getGravityHorizontal() {
        return this.getGravity() & 0x800007;
    }

    void setGravityHorizontal(int gravityHorizontal) {
        if (gravityHorizontal == 0) {
            gravityHorizontal = this.mDefaultGravityHorizontal;
        }
        this.setGravity(this.getGravity() & 0xFFFFFFF8 & 0xFF7FFFF8 | gravityHorizontal);
    }

    void setGravityVertical(int gravityVertical) {
        if (gravityVertical == 0) {
            gravityVertical = this.mDefaultGravityVertical;
        }
        this.setGravity(this.getGravity() & 0xFFFFFF8F | gravityVertical);
    }

    private void updateImeOptions() {
        int returnKeyFlag = 6;
        if (this.mReturnKeyType != null) {
            switch (this.mReturnKeyType) {
                case "go": {
                    returnKeyFlag = 2;
                    break;
                }
                case "next": {
                    returnKeyFlag = 5;
                    break;
                }
                case "none": {
                    returnKeyFlag = 1;
                    break;
                }
                case "previous": {
                    returnKeyFlag = 7;
                    break;
                }
                case "search": {
                    returnKeyFlag = 3;
                    break;
                }
                case "send": {
                    returnKeyFlag = 4;
                    break;
                }
                case "done": {
                    returnKeyFlag = 6;
                }
            }
        }
        if (this.mDisableFullscreen) {
            this.setImeOptions(returnKeyFlag | 0x2000000);
        } else {
            this.setImeOptions(returnKeyFlag);
        }
    }

    protected boolean verifyDrawable(Drawable drawable) {
        if (this.mContainsImages) {
            TextInlineImageSpan[] spans;
            Editable text = this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                if (span.getDrawable() != drawable) continue;
                return true;
            }
        }
        return super.verifyDrawable(drawable);
    }

    public void invalidateDrawable(Drawable drawable) {
        if (this.mContainsImages) {
            TextInlineImageSpan[] spans;
            Editable text = this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                if (span.getDrawable() != drawable) continue;
                this.invalidate();
            }
        }
        super.invalidateDrawable(drawable);
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mContainsImages) {
            TextInlineImageSpan[] spans;
            Editable text = this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                span.onDetachedFromWindow();
            }
        }
    }

    public void onStartTemporaryDetach() {
        super.onStartTemporaryDetach();
        if (this.mContainsImages) {
            TextInlineImageSpan[] spans;
            Editable text = this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                span.onStartTemporaryDetach();
            }
        }
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        super.setTextIsSelectable(true);
        if (this.mContainsImages) {
            TextInlineImageSpan[] spans;
            Editable text = this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                span.onAttachedToWindow();
            }
        }
        if (this.mAutoFocus && !this.mDidAttachToWindow) {
            this.requestFocusInternal();
        }
        this.mDidAttachToWindow = true;
    }

    public void onFinishTemporaryDetach() {
        super.onFinishTemporaryDetach();
        if (this.mContainsImages) {
            TextInlineImageSpan[] spans;
            Editable text = this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                span.onFinishTemporaryDetach();
            }
        }
    }

    public void setBackgroundColor(int color) {
        this.mReactBackgroundManager.setBackgroundColor(color);
    }

    public void setBorderWidth(int position, float width) {
        this.mReactBackgroundManager.setBorderWidth(position, width);
    }

    public void setBorderColor(int position, float color, float alpha) {
        this.mReactBackgroundManager.setBorderColor(position, color, alpha);
    }

    public int getBorderColor(int position) {
        return this.mReactBackgroundManager.getBorderColor(position);
    }

    public void setBorderRadius(float borderRadius) {
        this.mReactBackgroundManager.setBorderRadius(borderRadius);
    }

    public void setBorderRadius(float borderRadius, int position) {
        this.mReactBackgroundManager.setBorderRadius(borderRadius, position);
    }

    public void setBorderStyle(@Nullable String style2) {
        this.mReactBackgroundManager.setBorderStyle(style2);
    }

    public void setLetterSpacingPt(float letterSpacingPt) {
        this.mTextAttributes.setLetterSpacing(letterSpacingPt);
        this.applyTextAttributes();
    }

    public void setAllowFontScaling(boolean allowFontScaling) {
        if (this.mTextAttributes.getAllowFontScaling() != allowFontScaling) {
            this.mTextAttributes.setAllowFontScaling(allowFontScaling);
            this.applyTextAttributes();
        }
    }

    public void setFontSize(float fontSize) {
        this.mTextAttributes.setFontSize(fontSize);
        this.applyTextAttributes();
    }

    public void setMaxFontSizeMultiplier(float maxFontSizeMultiplier) {
        if (maxFontSizeMultiplier != this.mTextAttributes.getMaxFontSizeMultiplier()) {
            this.mTextAttributes.setMaxFontSizeMultiplier(maxFontSizeMultiplier);
            this.applyTextAttributes();
        }
    }

    public void setAutoFocus(boolean autoFocus) {
        this.mAutoFocus = autoFocus;
    }

    protected void applyTextAttributes() {
        this.setTextSize(0, this.mTextAttributes.getEffectiveFontSize());
        float effectiveLetterSpacing = this.mTextAttributes.getEffectiveLetterSpacing();
        if (!Float.isNaN(effectiveLetterSpacing) && Build.VERSION.SDK_INT >= 21) {
            this.setLetterSpacing(effectiveLetterSpacing);
        }
    }

    @Override
    public FabricViewStateManager getFabricViewStateManager() {
        return this.mFabricViewStateManager;
    }

    private void updateCachedSpannable() {
        if (this.mFabricViewStateManager == null || !this.mFabricViewStateManager.hasStateWrapper()) {
            return;
        }
        if (this.getId() == -1) {
            return;
        }
        Editable currentText = this.getText();
        boolean haveText = currentText != null && currentText.length() > 0;
        SpannableStringBuilder sb = new SpannableStringBuilder();
        if (haveText) {
            try {
                sb.append(currentText.subSequence(0, currentText.length()));
            }
            catch (IndexOutOfBoundsException e) {
                ReactSoftExceptionLogger.logSoftException(this.TAG, e);
            }
        }
        if (!haveText) {
            if (this.getHint() != null && this.getHint().length() > 0) {
                sb.append(this.getHint());
            } else {
                sb.append((CharSequence)"I");
            }
        }
        this.addSpansFromStyleAttributes(sb);
        TextLayoutManager.setCachedSpannabledForTag(this.getId(), (Spannable)sb);
    }

    void setEventDispatcher(@Nullable EventDispatcher eventDispatcher) {
        this.mEventDispatcher = eventDispatcher;
    }

    static {
        if (ReactBuildConfig.DEBUG) {
            // empty if block
        }
        DEBUG_MODE = false;
        sKeyListener = QwertyKeyListener.getInstanceForFullKeyboard();
    }

    private static class InternalKeyListener
    implements KeyListener {
        private int mInputType = 0;

        public void setInputType(int inputType) {
            this.mInputType = inputType;
        }

        public int getInputType() {
            return this.mInputType;
        }

        public boolean onKeyDown(View view, Editable text, int keyCode, KeyEvent event) {
            return sKeyListener.onKeyDown(view, text, keyCode, event);
        }

        public boolean onKeyUp(View view, Editable text, int keyCode, KeyEvent event) {
            return sKeyListener.onKeyUp(view, text, keyCode, event);
        }

        public boolean onKeyOther(View view, Editable text, KeyEvent event) {
            return sKeyListener.onKeyOther(view, text, event);
        }

        public void clearMetaKeyState(View view, Editable content, int states) {
            sKeyListener.clearMetaKeyState(view, content, states);
        }
    }

    private class TextWatcherDelegator
    implements TextWatcher {
        private TextWatcherDelegator() {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            if (!ReactEditText.this.mIsSettingTextFromJS && ReactEditText.this.mListeners != null) {
                for (TextWatcher listener : ReactEditText.this.mListeners) {
                    listener.beforeTextChanged(s, start, count, after);
                }
            }
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            if (DEBUG_MODE) {
                FLog.e((String)ReactEditText.this.TAG, (String)("onTextChanged[" + ReactEditText.this.getId() + "]: " + s + " " + start + " " + before + " " + count));
            }
            if (!ReactEditText.this.mIsSettingTextFromJS && ReactEditText.this.mListeners != null) {
                for (TextWatcher listener : ReactEditText.this.mListeners) {
                    listener.onTextChanged(s, start, before, count);
                }
            }
            ReactEditText.this.updateCachedSpannable();
            ReactEditText.this.onContentSizeChange();
        }

        public void afterTextChanged(Editable s) {
            if (!ReactEditText.this.mIsSettingTextFromJS && ReactEditText.this.mListeners != null) {
                for (TextWatcher listener : ReactEditText.this.mListeners) {
                    listener.afterTextChanged(s);
                }
            }
        }
    }

    static interface SpanPredicate<T> {
        public boolean test(T var1);
    }
}

