/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.views.text.ReactFontManager;
import com.facebook.react.views.text.TypefaceStyle;
import java.util.ArrayList;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class ReactTypefaceUtils {
    public static int parseFontWeight(@Nullable String fontWeightString) {
        if (fontWeightString != null) {
            switch (fontWeightString) {
                case "100": {
                    return 100;
                }
                case "200": {
                    return 200;
                }
                case "300": {
                    return 300;
                }
                case "normal": 
                case "400": {
                    return 400;
                }
                case "500": {
                    return 500;
                }
                case "600": {
                    return 600;
                }
                case "bold": 
                case "700": {
                    return 700;
                }
                case "800": {
                    return 800;
                }
                case "900": {
                    return 900;
                }
            }
        }
        return -1;
    }

    public static int parseFontStyle(@Nullable String fontStyleString) {
        if (fontStyleString != null) {
            if ("italic".equals(fontStyleString)) {
                return 2;
            }
            if ("normal".equals(fontStyleString)) {
                return 0;
            }
        }
        return -1;
    }

    @Nullable
    public static String parseFontVariant(@Nullable ReadableArray fontVariantArray) {
        if (fontVariantArray == null || fontVariantArray.size() == 0) {
            return null;
        }
        ArrayList<String> features = new ArrayList<String>();
        block54: for (int i = 0; i < fontVariantArray.size(); ++i) {
            String fontVariant = fontVariantArray.getString(i);
            if (fontVariant == null) continue;
            switch (fontVariant) {
                case "small-caps": {
                    features.add("'smcp'");
                    continue block54;
                }
                case "oldstyle-nums": {
                    features.add("'onum'");
                    continue block54;
                }
                case "lining-nums": {
                    features.add("'lnum'");
                    continue block54;
                }
                case "tabular-nums": {
                    features.add("'tnum'");
                    continue block54;
                }
                case "proportional-nums": {
                    features.add("'pnum'");
                    continue block54;
                }
                case "stylistic-one": {
                    features.add("'ss01'");
                    continue block54;
                }
                case "stylistic-two": {
                    features.add("'ss02'");
                    continue block54;
                }
                case "stylistic-three": {
                    features.add("'ss03'");
                    continue block54;
                }
                case "stylistic-four": {
                    features.add("'ss04'");
                    continue block54;
                }
                case "stylistic-five": {
                    features.add("'ss05'");
                    continue block54;
                }
                case "stylistic-six": {
                    features.add("'ss06'");
                    continue block54;
                }
                case "stylistic-seven": {
                    features.add("'ss07'");
                    continue block54;
                }
                case "stylistic-eight": {
                    features.add("'ss08'");
                    continue block54;
                }
                case "stylistic-nine": {
                    features.add("'ss09'");
                    continue block54;
                }
                case "stylistic-ten": {
                    features.add("'ss10'");
                    continue block54;
                }
                case "stylistic-eleven": {
                    features.add("'ss11'");
                    continue block54;
                }
                case "stylistic-twelve": {
                    features.add("'ss12'");
                    continue block54;
                }
                case "stylistic-thirteen": {
                    features.add("'ss13'");
                    continue block54;
                }
                case "stylistic-fourteen": {
                    features.add("'ss14'");
                    continue block54;
                }
                case "stylistic-fifteen": {
                    features.add("'ss15'");
                    continue block54;
                }
                case "stylistic-sixteen": {
                    features.add("'ss16'");
                    continue block54;
                }
                case "stylistic-seventeen": {
                    features.add("'ss17'");
                    continue block54;
                }
                case "stylistic-eighteen": {
                    features.add("'ss18'");
                    continue block54;
                }
                case "stylistic-nineteen": {
                    features.add("'ss19'");
                    continue block54;
                }
                case "stylistic-twenty": {
                    features.add("'ss20'");
                }
            }
        }
        return TextUtils.join((CharSequence)", ", features);
    }

    public static Typeface applyStyles(@Nullable Typeface typeface, int style2, int weight, @Nullable String fontFamilyName, AssetManager assetManager) {
        TypefaceStyle typefaceStyle = new TypefaceStyle(style2, weight);
        if (fontFamilyName == null) {
            return typefaceStyle.apply(typeface == null ? Typeface.DEFAULT : typeface);
        }
        return ReactFontManager.getInstance().getTypeface(fontFamilyName, typefaceStyle, assetManager);
    }
}

