/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.uimanager.TouchTargetHelper;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.uimanager.events.PointerEvent;
import com.facebook.react.uimanager.events.PointerEventHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JSPointerDispatcher {
    private static final int UNSET_POINTER_ID = -1;
    private static final float ONMOVE_EPSILON = 0.1f;
    private static final String TAG = "POINTER EVENTS";
    private Map<Integer, List<TouchTargetHelper.ViewTarget>> mLastHitPathByPointerId;
    private Map<Integer, float[]> mLastEventCoordinatesByPointerId;
    private Set<Integer> mHoveringPointerIds = new HashSet<Integer>();
    private int mChildHandlingNativeGesture = -1;
    private int mPrimaryPointerId = -1;
    private int mCoalescingKey = 0;
    private int mLastButtonState = 0;
    private final ViewGroup mRootViewGroup;

    public JSPointerDispatcher(ViewGroup viewGroup) {
        this.mRootViewGroup = viewGroup;
    }

    public void onChildStartedNativeGesture(View childView, MotionEvent motionEvent, EventDispatcher eventDispatcher) {
        if (this.mChildHandlingNativeGesture != -1 || childView == null) {
            return;
        }
        this.dispatchCancelEvent(motionEvent, eventDispatcher);
        this.mChildHandlingNativeGesture = childView.getId();
    }

    public void onChildEndedNativeGesture() {
        this.mChildHandlingNativeGesture = -1;
    }

    private void onUp(int activeTargetTag, PointerEvent.PointerEventState eventState, MotionEvent motionEvent, EventDispatcher eventDispatcher) {
        boolean supportsHover;
        int activePointerId = eventState.getActivePointerId();
        List<TouchTargetHelper.ViewTarget> activeHitPath = eventState.getHitPathByPointerId().get(activePointerId);
        boolean listeningForUp = JSPointerDispatcher.isAnyoneListeningForBubblingEvent(activeHitPath, PointerEventHelper.EVENT.UP, PointerEventHelper.EVENT.UP_CAPTURE);
        if (listeningForUp) {
            eventDispatcher.dispatchEvent(PointerEvent.obtain("topPointerUp", activeTargetTag, eventState, motionEvent));
        }
        if (!(supportsHover = this.mHoveringPointerIds.contains(activePointerId))) {
            boolean listeningForOut = JSPointerDispatcher.isAnyoneListeningForBubblingEvent(activeHitPath, PointerEventHelper.EVENT.OUT, PointerEventHelper.EVENT.OUT_CAPTURE);
            if (listeningForOut) {
                eventDispatcher.dispatchEvent(PointerEvent.obtain("topPointerOut", activeTargetTag, eventState, motionEvent));
            }
            List<TouchTargetHelper.ViewTarget> leaveViewTargets = JSPointerDispatcher.filterByShouldDispatch(activeHitPath, PointerEventHelper.EVENT.LEAVE, PointerEventHelper.EVENT.LEAVE_CAPTURE, false);
            this.dispatchEventForViewTargets("topPointerLeave", eventState, motionEvent, leaveViewTargets, eventDispatcher);
        }
        if (motionEvent.getActionMasked() == 1) {
            this.mPrimaryPointerId = -1;
        }
        this.mHoveringPointerIds.remove(activePointerId);
    }

    private void incrementCoalescingKey() {
        this.mCoalescingKey = (this.mCoalescingKey + 1) % Integer.MAX_VALUE;
    }

    private short getCoalescingKey() {
        return (short)(0xFFFF & this.mCoalescingKey);
    }

    private void onDown(int activeTargetTag, PointerEvent.PointerEventState eventState, MotionEvent motionEvent, EventDispatcher eventDispatcher) {
        boolean listeningForDown;
        List<TouchTargetHelper.ViewTarget> activeHitPath = eventState.getHitPathByPointerId().get(eventState.getActivePointerId());
        this.incrementCoalescingKey();
        boolean supportsHover = this.mHoveringPointerIds.contains(eventState.getActivePointerId());
        if (!supportsHover) {
            boolean listeningForOver = JSPointerDispatcher.isAnyoneListeningForBubblingEvent(activeHitPath, PointerEventHelper.EVENT.OVER, PointerEventHelper.EVENT.OVER_CAPTURE);
            if (listeningForOver) {
                eventDispatcher.dispatchEvent(PointerEvent.obtain("topPointerOver", activeTargetTag, eventState, motionEvent));
            }
            List<TouchTargetHelper.ViewTarget> enterViewTargets = JSPointerDispatcher.filterByShouldDispatch(activeHitPath, PointerEventHelper.EVENT.ENTER, PointerEventHelper.EVENT.ENTER_CAPTURE, false);
            Collections.reverse(enterViewTargets);
            this.dispatchEventForViewTargets("topPointerEnter", eventState, motionEvent, enterViewTargets, eventDispatcher);
        }
        if (listeningForDown = JSPointerDispatcher.isAnyoneListeningForBubblingEvent(activeHitPath, PointerEventHelper.EVENT.DOWN, PointerEventHelper.EVENT.DOWN_CAPTURE)) {
            eventDispatcher.dispatchEvent(PointerEvent.obtain("topPointerDown", activeTargetTag, eventState, motionEvent));
        }
    }

    private PointerEvent.PointerEventState createEventState(int activePointerId, MotionEvent motionEvent) {
        HashMap<Integer, float[]> offsetByPointerId = new HashMap<Integer, float[]>();
        HashMap<Integer, List<TouchTargetHelper.ViewTarget>> hitPathByPointerId = new HashMap<Integer, List<TouchTargetHelper.ViewTarget>>();
        HashMap<Integer, float[]> eventCoordinatesByPointerId = new HashMap<Integer, float[]>();
        for (int index = 0; index < motionEvent.getPointerCount(); ++index) {
            float[] offsetCoordinates = new float[2];
            float[] eventCoordinates = new float[]{motionEvent.getX(index), motionEvent.getY(index)};
            List<TouchTargetHelper.ViewTarget> hitPath = TouchTargetHelper.findTargetPathAndCoordinatesForTouch(eventCoordinates[0], eventCoordinates[1], this.mRootViewGroup, offsetCoordinates);
            int pointerId = motionEvent.getPointerId(index);
            offsetByPointerId.put(pointerId, offsetCoordinates);
            hitPathByPointerId.put(pointerId, hitPath);
            eventCoordinatesByPointerId.put(pointerId, eventCoordinates);
        }
        int surfaceId = UIManagerHelper.getSurfaceId((View)this.mRootViewGroup);
        return new PointerEvent.PointerEventState(this.mPrimaryPointerId, activePointerId, this.mLastButtonState, surfaceId, offsetByPointerId, hitPathByPointerId, eventCoordinatesByPointerId, this.mHoveringPointerIds);
    }

    public void handleMotionEvent(MotionEvent motionEvent, EventDispatcher eventDispatcher, boolean isCapture) {
        int activeTargetTag;
        boolean isExitFromRoot;
        if (this.mChildHandlingNativeGesture != -1) {
            return;
        }
        int action = motionEvent.getActionMasked();
        int activePointerId = motionEvent.getPointerId(motionEvent.getActionIndex());
        if (action == 0) {
            this.mPrimaryPointerId = motionEvent.getPointerId(0);
        } else if (action == 7) {
            this.mHoveringPointerIds.add(activePointerId);
        }
        PointerEvent.PointerEventState eventState = this.createEventState(activePointerId, motionEvent);
        boolean bl = isExitFromRoot = isCapture && motionEvent.getActionMasked() == 10;
        if (isExitFromRoot) {
            List<TouchTargetHelper.ViewTarget> lastHitPath;
            List<TouchTargetHelper.ViewTarget> list = lastHitPath = this.mLastHitPathByPointerId != null ? this.mLastHitPathByPointerId.get(eventState.getActivePointerId()) : null;
            if (lastHitPath == null || lastHitPath.isEmpty()) {
                return;
            }
            activeTargetTag = lastHitPath.get(lastHitPath.size() - 1).getViewId();
            ArrayList activeHitPath = new ArrayList();
            eventState.getHitPathByPointerId().put(activePointerId, activeHitPath);
        } else {
            List<TouchTargetHelper.ViewTarget> activeHitPath = eventState.getHitPathByPointerId().get(activePointerId);
            if (activeHitPath == null || activeHitPath.isEmpty()) {
                return;
            }
            activeTargetTag = activeHitPath.get(0).getViewId();
        }
        switch (action) {
            case 0: 
            case 5: {
                this.onDown(activeTargetTag, eventState, motionEvent, eventDispatcher);
                break;
            }
            case 7: {
                float[] fArray;
                float[] eventCoordinates = eventState.getEventCoordinatesByPointerId().get(activePointerId);
                if (this.mLastEventCoordinatesByPointerId != null && this.mLastEventCoordinatesByPointerId.containsKey(activePointerId)) {
                    fArray = this.mLastEventCoordinatesByPointerId.get(activePointerId);
                } else {
                    float[] fArray2 = new float[2];
                    fArray2[0] = 0.0f;
                    fArray = fArray2;
                    fArray2[1] = 0.0f;
                }
                float[] lastEventCoordinates = fArray;
                if (!this.qualifiedMove(eventCoordinates, lastEventCoordinates)) {
                    return;
                }
                this.onMove(activeTargetTag, eventState, motionEvent, eventDispatcher);
                break;
            }
            case 2: {
                this.onMove(activeTargetTag, eventState, motionEvent, eventDispatcher);
                break;
            }
            case 1: 
            case 6: {
                this.incrementCoalescingKey();
                this.onUp(activeTargetTag, eventState, motionEvent, eventDispatcher);
                break;
            }
            case 3: {
                this.dispatchCancelEvent(eventState, motionEvent, eventDispatcher);
                break;
            }
            case 9: {
                return;
            }
            case 10: {
                if (!isExitFromRoot) break;
                this.onMove(activeTargetTag, eventState, motionEvent, eventDispatcher);
                break;
            }
            default: {
                FLog.w((String)"ReactNative", (String)("Motion Event was ignored. Action=" + action + " Target=" + activeTargetTag));
                return;
            }
        }
        this.mLastHitPathByPointerId = eventState.getHitPathByPointerId();
        this.mLastEventCoordinatesByPointerId = eventState.getEventCoordinatesByPointerId();
        this.mLastButtonState = motionEvent.getButtonState();
        Set<Integer> allPointerIds = this.mLastEventCoordinatesByPointerId.keySet();
        this.mHoveringPointerIds.retainAll(allPointerIds);
    }

    private static boolean isAnyoneListeningForBubblingEvent(List<TouchTargetHelper.ViewTarget> hitPath, PointerEventHelper.EVENT event, PointerEventHelper.EVENT captureEvent) {
        for (TouchTargetHelper.ViewTarget viewTarget : hitPath) {
            if (!PointerEventHelper.isListening(viewTarget.getView(), event) && !PointerEventHelper.isListening(viewTarget.getView(), captureEvent)) continue;
            return true;
        }
        return false;
    }

    private static List<TouchTargetHelper.ViewTarget> filterByShouldDispatch(List<TouchTargetHelper.ViewTarget> viewTargets, PointerEventHelper.EVENT bubble, PointerEventHelper.EVENT capture, boolean forceDispatch) {
        ArrayList<TouchTargetHelper.ViewTarget> dispatchableViewTargets = new ArrayList<TouchTargetHelper.ViewTarget>(viewTargets);
        if (forceDispatch) {
            return dispatchableViewTargets;
        }
        boolean ancestorListening = false;
        for (int i = viewTargets.size() - 1; i >= 0; --i) {
            TouchTargetHelper.ViewTarget viewTarget = viewTargets.get(i);
            View view = viewTarget.getView();
            if (!(ancestorListening || PointerEventHelper.isListening(view, capture) || PointerEventHelper.isListening(view, bubble))) {
                dispatchableViewTargets.remove(i);
                continue;
            }
            if (ancestorListening || !PointerEventHelper.isListening(view, capture)) continue;
            ancestorListening = true;
        }
        return dispatchableViewTargets;
    }

    private void dispatchEventForViewTargets(String eventName, PointerEvent.PointerEventState eventState, MotionEvent motionEvent, List<TouchTargetHelper.ViewTarget> viewTargets, EventDispatcher dispatcher) {
        for (TouchTargetHelper.ViewTarget viewTarget : viewTargets) {
            int viewId = viewTarget.getViewId();
            dispatcher.dispatchEvent(PointerEvent.obtain(eventName, viewId, eventState, motionEvent));
        }
    }

    private boolean qualifiedMove(float[] eventCoordinates, float[] lastEventCoordinates) {
        return Math.abs(lastEventCoordinates[0] - eventCoordinates[0]) > 0.1f || Math.abs(lastEventCoordinates[1] - eventCoordinates[1]) > 0.1f;
    }

    private void onMove(int targetTag, PointerEvent.PointerEventState eventState, MotionEvent motionEvent, EventDispatcher eventDispatcher) {
        boolean listeningToMove;
        boolean hasDiverged;
        int firstDivergentIndexFromBack;
        int activePointerId = eventState.getActivePointerId();
        List<TouchTargetHelper.ViewTarget> activeHitPath = eventState.getHitPathByPointerId().get(activePointerId);
        ArrayList<TouchTargetHelper.ViewTarget> lastHitPath = this.mLastHitPathByPointerId != null && this.mLastHitPathByPointerId.containsKey(activePointerId) ? this.mLastHitPathByPointerId.get(activePointerId) : new ArrayList<TouchTargetHelper.ViewTarget>();
        boolean nonDivergentListeningToEnter = false;
        boolean nonDivergentListeningToLeave = false;
        for (firstDivergentIndexFromBack = 0; firstDivergentIndexFromBack < Math.min(activeHitPath.size(), lastHitPath.size()) && activeHitPath.get(activeHitPath.size() - 1 - firstDivergentIndexFromBack).equals(lastHitPath.get(lastHitPath.size() - 1 - firstDivergentIndexFromBack)); ++firstDivergentIndexFromBack) {
            View nonDivergentViewTargetView = activeHitPath.get(activeHitPath.size() - 1 - firstDivergentIndexFromBack).getView();
            if (!nonDivergentListeningToEnter && PointerEventHelper.isListening(nonDivergentViewTargetView, PointerEventHelper.EVENT.ENTER_CAPTURE)) {
                nonDivergentListeningToEnter = true;
            }
            if (nonDivergentListeningToLeave || !PointerEventHelper.isListening(nonDivergentViewTargetView, PointerEventHelper.EVENT.LEAVE_CAPTURE)) continue;
            nonDivergentListeningToLeave = true;
        }
        boolean bl = hasDiverged = firstDivergentIndexFromBack < Math.max(activeHitPath.size(), lastHitPath.size());
        if (hasDiverged) {
            List<TouchTargetHelper.ViewTarget> enterViewTargets;
            boolean listeningForOver;
            this.incrementCoalescingKey();
            if (lastHitPath.size() > 0) {
                List<TouchTargetHelper.ViewTarget> leaveViewTargets;
                int lastTargetTag = ((TouchTargetHelper.ViewTarget)lastHitPath.get(0)).getViewId();
                boolean listeningForOut = JSPointerDispatcher.isAnyoneListeningForBubblingEvent(lastHitPath, PointerEventHelper.EVENT.OUT, PointerEventHelper.EVENT.OUT_CAPTURE);
                if (listeningForOut) {
                    eventDispatcher.dispatchEvent(PointerEvent.obtain("topPointerOut", lastTargetTag, eventState, motionEvent));
                }
                if ((leaveViewTargets = JSPointerDispatcher.filterByShouldDispatch(lastHitPath.subList(0, lastHitPath.size() - firstDivergentIndexFromBack), PointerEventHelper.EVENT.LEAVE, PointerEventHelper.EVENT.LEAVE_CAPTURE, nonDivergentListeningToLeave)).size() > 0) {
                    this.dispatchEventForViewTargets("topPointerLeave", eventState, motionEvent, leaveViewTargets, eventDispatcher);
                }
            }
            if (listeningForOver = JSPointerDispatcher.isAnyoneListeningForBubblingEvent(activeHitPath, PointerEventHelper.EVENT.OVER, PointerEventHelper.EVENT.OVER_CAPTURE)) {
                eventDispatcher.dispatchEvent(PointerEvent.obtain("topPointerOver", targetTag, eventState, motionEvent));
            }
            if ((enterViewTargets = JSPointerDispatcher.filterByShouldDispatch(activeHitPath.subList(0, activeHitPath.size() - firstDivergentIndexFromBack), PointerEventHelper.EVENT.ENTER, PointerEventHelper.EVENT.ENTER_CAPTURE, nonDivergentListeningToEnter)).size() > 0) {
                Collections.reverse(enterViewTargets);
                this.dispatchEventForViewTargets("topPointerEnter", eventState, motionEvent, enterViewTargets, eventDispatcher);
            }
        }
        if (listeningToMove = JSPointerDispatcher.isAnyoneListeningForBubblingEvent(activeHitPath, PointerEventHelper.EVENT.MOVE, PointerEventHelper.EVENT.MOVE_CAPTURE)) {
            eventDispatcher.dispatchEvent(PointerEvent.obtain("topPointerMove", targetTag, eventState, motionEvent, this.getCoalescingKey()));
        }
    }

    private void dispatchCancelEvent(MotionEvent motionEvent, EventDispatcher eventDispatcher) {
        Assertions.assertCondition((this.mChildHandlingNativeGesture == -1 ? 1 : 0) != 0, (String)"Expected to not have already sent a cancel for this gesture");
        int activeIndex = motionEvent.getActionIndex();
        int activePointerId = motionEvent.getPointerId(activeIndex);
        PointerEvent.PointerEventState eventState = this.createEventState(activePointerId, motionEvent);
        this.dispatchCancelEvent(eventState, motionEvent, eventDispatcher);
    }

    private void dispatchCancelEvent(PointerEvent.PointerEventState eventState, MotionEvent motionEvent, EventDispatcher eventDispatcher) {
        Assertions.assertCondition((this.mChildHandlingNativeGesture == -1 ? 1 : 0) != 0, (String)"Expected to not have already sent a cancel for this gesture");
        int activePointerId = eventState.getActivePointerId();
        List<TouchTargetHelper.ViewTarget> activeHitPath = eventState.getHitPathByPointerId().get(activePointerId);
        if (!activeHitPath.isEmpty()) {
            boolean listeningForCancel = JSPointerDispatcher.isAnyoneListeningForBubblingEvent(activeHitPath, PointerEventHelper.EVENT.CANCEL, PointerEventHelper.EVENT.CANCEL_CAPTURE);
            if (listeningForCancel) {
                int targetTag = activeHitPath.get(0).getViewId();
                ((EventDispatcher)Assertions.assertNotNull((Object)eventDispatcher)).dispatchEvent(PointerEvent.obtain("topPointerCancel", targetTag, eventState, motionEvent));
            }
            List<TouchTargetHelper.ViewTarget> leaveViewTargets = JSPointerDispatcher.filterByShouldDispatch(activeHitPath, PointerEventHelper.EVENT.LEAVE, PointerEventHelper.EVENT.LEAVE_CAPTURE, false);
            this.dispatchEventForViewTargets("topPointerLeave", eventState, motionEvent, leaveViewTargets, eventDispatcher);
            this.incrementCoalescingKey();
            this.mHoveringPointerIds.remove(this.mPrimaryPointerId);
            this.mHoveringPointerIds.remove(activePointerId);
            this.mPrimaryPointerId = -1;
        }
    }

    private void debugPrintHitPath(List<TouchTargetHelper.ViewTarget> hitPath) {
        StringBuilder builder = new StringBuilder("hitPath: ");
        for (TouchTargetHelper.ViewTarget viewTarget : hitPath) {
            builder.append(String.format("%d, ", viewTarget.getViewId()));
        }
        FLog.d((String)TAG, (String)builder.toString());
    }
}

