/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.StateWrapper;

public class FabricViewStateManager {
    private static final String TAG = "FabricViewStateManager";
    @Nullable
    private StateWrapper mStateWrapper = null;

    public void setStateWrapper(StateWrapper stateWrapper) {
        this.mStateWrapper = stateWrapper;
    }

    public boolean hasStateWrapper() {
        return this.mStateWrapper != null;
    }

    private void setState(@Nullable StateWrapper stateWrapper, StateUpdateCallback stateUpdateCallback, int numTries) {
        if (stateWrapper == null) {
            FLog.e((String)TAG, (String)"setState called without a StateWrapper");
            return;
        }
        if (stateWrapper != this.mStateWrapper) {
            return;
        }
        if (numTries > 60) {
            return;
        }
        WritableMap stateUpdate = stateUpdateCallback.getStateUpdate();
        if (stateUpdate == null) {
            return;
        }
        stateWrapper.updateState(stateUpdate);
    }

    public void setState(StateUpdateCallback stateUpdateCallback) {
        this.setState(this.mStateWrapper, stateUpdateCallback, 0);
    }

    @Nullable
    public ReadableMap getStateData() {
        return this.mStateWrapper != null ? this.mStateWrapper.getStateData() : null;
    }

    public static interface StateUpdateCallback {
        public WritableMap getStateUpdate();
    }

    public static interface HasFabricViewStateManager {
        public FabricViewStateManager getFabricViewStateManager();
    }
}

