/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.fresco;

import android.content.Context;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.imagepipeline.backends.okhttp3.OkHttpImagePipelineConfigFactory;
import com.facebook.imagepipeline.core.ImagePipeline;
import com.facebook.imagepipeline.core.ImagePipelineConfig;
import com.facebook.imagepipeline.producers.NetworkFetcher;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.common.ModuleDataCleaner;
import com.facebook.react.modules.fresco.ReactOkHttpNetworkFetcher;
import com.facebook.react.modules.fresco.SystraceRequestListener;
import com.facebook.react.modules.network.CookieJarContainer;
import com.facebook.react.modules.network.ForwardingCookieHandler;
import com.facebook.react.modules.network.OkHttpClientProvider;
import com.facebook.react.turbomodule.core.interfaces.TurboModule;
import java.net.CookieHandler;
import java.util.HashSet;
import okhttp3.CookieJar;
import okhttp3.JavaNetCookieJar;
import okhttp3.OkHttpClient;

@ReactModule(name="FrescoModule", needsEagerInit=true)
public class FrescoModule
extends ReactContextBaseJavaModule
implements ModuleDataCleaner.Cleanable,
LifecycleEventListener,
TurboModule {
    public static final String NAME = "FrescoModule";
    private final boolean mClearOnDestroy;
    @Nullable
    private ImagePipelineConfig mConfig;
    @Nullable
    private ImagePipeline mImagePipeline;
    private static boolean sHasBeenInitialized = false;

    public FrescoModule(ReactApplicationContext reactContext) {
        this(reactContext, true, null);
    }

    public FrescoModule(ReactApplicationContext reactContext, boolean clearOnDestroy) {
        this(reactContext, clearOnDestroy, null);
    }

    public FrescoModule(ReactApplicationContext reactContext, @Nullable ImagePipeline imagePipeline, boolean clearOnDestroy) {
        this(reactContext, imagePipeline, clearOnDestroy, false);
    }

    public FrescoModule(ReactApplicationContext reactContext, @Nullable ImagePipeline imagePipeline, boolean clearOnDestroy, boolean hasBeenInitializedExternally) {
        this(reactContext, clearOnDestroy);
        this.mImagePipeline = imagePipeline;
        if (hasBeenInitializedExternally) {
            sHasBeenInitialized = true;
        }
    }

    public FrescoModule(ReactApplicationContext reactContext, boolean clearOnDestroy, @Nullable ImagePipelineConfig config) {
        super(reactContext);
        this.mClearOnDestroy = clearOnDestroy;
        this.mConfig = config;
    }

    @Override
    public void initialize() {
        super.initialize();
        ReactApplicationContext reactContext = this.getReactApplicationContext();
        reactContext.addLifecycleEventListener(this);
        if (!FrescoModule.hasBeenInitialized()) {
            if (this.mConfig == null) {
                this.mConfig = FrescoModule.getDefaultConfig(reactContext);
            }
            Fresco.initialize((Context)reactContext.getApplicationContext(), (ImagePipelineConfig)this.mConfig);
            sHasBeenInitialized = true;
        } else if (this.mConfig != null) {
            FLog.w((String)"ReactNative", (String)"Fresco has already been initialized with a different config. The new Fresco configuration will be ignored!");
        }
        this.mConfig = null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void clearSensitiveData() {
        this.getImagePipeline().clearCaches();
    }

    public static boolean hasBeenInitialized() {
        return sHasBeenInitialized;
    }

    private static ImagePipelineConfig getDefaultConfig(ReactContext context) {
        return FrescoModule.getDefaultConfigBuilder(context).build();
    }

    public static ImagePipelineConfig.Builder getDefaultConfigBuilder(ReactContext context) {
        HashSet<SystraceRequestListener> requestListeners = new HashSet<SystraceRequestListener>();
        requestListeners.add(new SystraceRequestListener());
        OkHttpClient client = OkHttpClientProvider.createClient();
        CookieJarContainer container = (CookieJarContainer)client.cookieJar();
        ForwardingCookieHandler handler = new ForwardingCookieHandler(context);
        container.setCookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)handler));
        return OkHttpImagePipelineConfigFactory.newBuilder((Context)context.getApplicationContext(), (OkHttpClient)client).setNetworkFetcher((NetworkFetcher)new ReactOkHttpNetworkFetcher(client)).setDownsampleEnabled(false).setRequestListeners(requestListeners);
    }

    @Override
    public void onHostResume() {
    }

    @Override
    public void onHostPause() {
    }

    @Override
    public void onHostDestroy() {
        if (FrescoModule.hasBeenInitialized() && this.mClearOnDestroy) {
            this.getImagePipeline().clearMemoryCaches();
        }
    }

    private ImagePipeline getImagePipeline() {
        if (this.mImagePipeline == null) {
            this.mImagePipeline = Fresco.getImagePipeline();
        }
        return this.mImagePipeline;
    }

    @Override
    public void invalidate() {
        this.getReactApplicationContext().removeLifecycleEventListener(this);
        super.invalidate();
    }
}

