/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric.mounting.mountitems;

import androidx.annotation.NonNull;
import com.facebook.common.logging.FLog;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.fabric.FabricComponents;
import com.facebook.react.fabric.FabricUIManager;
import com.facebook.react.fabric.events.EventEmitterWrapper;
import com.facebook.react.fabric.mounting.MountingManager;
import com.facebook.react.fabric.mounting.SurfaceMountingManager;
import com.facebook.react.fabric.mounting.mountitems.MountItem;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.systrace.Systrace;

@DoNotStrip
public class IntBufferBatchMountItem
implements MountItem {
    static final String TAG = IntBufferBatchMountItem.class.getSimpleName();
    static final int INSTRUCTION_FLAG_MULTIPLE = 1;
    static final int INSTRUCTION_CREATE = 2;
    static final int INSTRUCTION_DELETE = 4;
    static final int INSTRUCTION_INSERT = 8;
    static final int INSTRUCTION_REMOVE = 16;
    static final int INSTRUCTION_UPDATE_PROPS = 32;
    static final int INSTRUCTION_UPDATE_STATE = 64;
    static final int INSTRUCTION_UPDATE_LAYOUT = 128;
    static final int INSTRUCTION_UPDATE_EVENT_EMITTER = 256;
    static final int INSTRUCTION_UPDATE_PADDING = 512;
    static final int INSTRUCTION_UPDATE_OVERFLOW_INSET = 1024;
    static final int INSTRUCTION_REMOVE_DELETE_TREE = 2048;
    private final int mSurfaceId;
    private final int mCommitNumber;
    @NonNull
    private final int[] mIntBuffer;
    @NonNull
    private final Object[] mObjBuffer;
    private final int mIntBufferLen;
    private final int mObjBufferLen;

    public IntBufferBatchMountItem(int surfaceId, int[] intBuf, Object[] objBuf, int commitNumber) {
        this.mSurfaceId = surfaceId;
        this.mCommitNumber = commitNumber;
        this.mIntBuffer = intBuf;
        this.mObjBuffer = objBuf;
        this.mIntBufferLen = this.mIntBuffer != null ? this.mIntBuffer.length : 0;
        this.mObjBufferLen = this.mObjBuffer != null ? this.mObjBuffer.length : 0;
    }

    private void beginMarkers(String reason) {
        Systrace.beginSection(0L, "FabricUIManager::" + reason);
        if (this.mCommitNumber > 0) {
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_BATCH_EXECUTION_START, null, this.mCommitNumber);
        }
    }

    private void endMarkers() {
        if (this.mCommitNumber > 0) {
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_BATCH_EXECUTION_END, null, this.mCommitNumber);
        }
        Systrace.endSection(0L);
    }

    private static StateWrapper castToState(Object obj) {
        return obj != null ? (StateWrapper)obj : null;
    }

    private static EventEmitterWrapper castToEventEmitter(Object obj) {
        return obj != null ? (EventEmitterWrapper)obj : null;
    }

    @Override
    public void execute(@NonNull MountingManager mountingManager) {
        SurfaceMountingManager surfaceMountingManager = mountingManager.getSurfaceManager(this.mSurfaceId);
        if (surfaceMountingManager == null) {
            FLog.e((String)TAG, (String)"Skipping batch of MountItems; no SurfaceMountingManager found for [%d].", (Object[])new Object[]{this.mSurfaceId});
            return;
        }
        if (surfaceMountingManager.isStopped()) {
            FLog.e((String)TAG, (String)"Skipping batch of MountItems; was stopped [%d].", (Object[])new Object[]{this.mSurfaceId});
            return;
        }
        if (FabricUIManager.ENABLE_FABRIC_LOGS) {
            FLog.d((String)TAG, (String)"Executing IntBufferBatchMountItem on surface [%d]", (Object)this.mSurfaceId);
        }
        this.beginMarkers("mountViews");
        int i = 0;
        int j = 0;
        while (i < this.mIntBufferLen) {
            int rawType = this.mIntBuffer[i++];
            int type = rawType & 0xFFFFFFFE;
            int numInstructions = (rawType & 1) != 0 ? this.mIntBuffer[i++] : 1;
            for (int k = 0; k < numInstructions; ++k) {
                int parentTag;
                if (type == 2) {
                    String componentName = FabricComponents.getFabricComponentName((String)this.mObjBuffer[j++]);
                    surfaceMountingManager.createView(componentName, this.mIntBuffer[i++], this.mObjBuffer[j++], IntBufferBatchMountItem.castToState(this.mObjBuffer[j++]), IntBufferBatchMountItem.castToEventEmitter(this.mObjBuffer[j++]), this.mIntBuffer[i++] == 1);
                    continue;
                }
                if (type == 4) {
                    surfaceMountingManager.deleteView(this.mIntBuffer[i++]);
                    continue;
                }
                if (type == 8) {
                    int tag = this.mIntBuffer[i++];
                    parentTag = this.mIntBuffer[i++];
                    surfaceMountingManager.addViewAt(parentTag, tag, this.mIntBuffer[i++]);
                    continue;
                }
                if (type == 16) {
                    surfaceMountingManager.removeViewAt(this.mIntBuffer[i++], this.mIntBuffer[i++], this.mIntBuffer[i++]);
                    continue;
                }
                if (type == 2048) {
                    surfaceMountingManager.removeDeleteTreeAt(this.mIntBuffer[i++], this.mIntBuffer[i++], this.mIntBuffer[i++]);
                    continue;
                }
                if (type == 32) {
                    surfaceMountingManager.updateProps(this.mIntBuffer[i++], this.mObjBuffer[j++]);
                    continue;
                }
                if (type == 64) {
                    surfaceMountingManager.updateState(this.mIntBuffer[i++], IntBufferBatchMountItem.castToState(this.mObjBuffer[j++]));
                    continue;
                }
                if (type == 128) {
                    int reactTag = this.mIntBuffer[i++];
                    parentTag = this.mIntBuffer[i++];
                    int x = this.mIntBuffer[i++];
                    int y = this.mIntBuffer[i++];
                    int width = this.mIntBuffer[i++];
                    int height = this.mIntBuffer[i++];
                    int displayType = this.mIntBuffer[i++];
                    surfaceMountingManager.updateLayout(reactTag, parentTag, x, y, width, height, displayType);
                    continue;
                }
                if (type == 512) {
                    surfaceMountingManager.updatePadding(this.mIntBuffer[i++], this.mIntBuffer[i++], this.mIntBuffer[i++], this.mIntBuffer[i++], this.mIntBuffer[i++]);
                    continue;
                }
                if (type == 1024) {
                    int reactTag = this.mIntBuffer[i++];
                    int overflowInsetLeft = this.mIntBuffer[i++];
                    int overflowInsetTop = this.mIntBuffer[i++];
                    int overflowInsetRight = this.mIntBuffer[i++];
                    int overflowInsetBottom = this.mIntBuffer[i++];
                    surfaceMountingManager.updateOverflowInset(reactTag, overflowInsetLeft, overflowInsetTop, overflowInsetRight, overflowInsetBottom);
                    continue;
                }
                if (type == 256) {
                    surfaceMountingManager.updateEventEmitter(this.mIntBuffer[i++], IntBufferBatchMountItem.castToEventEmitter(this.mObjBuffer[j++]));
                    continue;
                }
                throw new IllegalArgumentException("Invalid type argument to IntBufferBatchMountItem: " + type + " at index: " + i);
            }
        }
        this.endMarkers();
    }

    @Override
    public int getSurfaceId() {
        return this.mSurfaceId;
    }

    public boolean shouldSchedule() {
        return this.mIntBufferLen != 0;
    }

    public String toString() {
        try {
            StringBuilder s = new StringBuilder();
            s.append(String.format("IntBufferBatchMountItem [surface:%d]:\n", this.mSurfaceId));
            int i = 0;
            int j = 0;
            while (i < this.mIntBufferLen) {
                int rawType = this.mIntBuffer[i++];
                int type = rawType & 0xFFFFFFFE;
                int numInstructions = (rawType & 1) != 0 ? this.mIntBuffer[i++] : 1;
                for (int k = 0; k < numInstructions; ++k) {
                    if (type == 2) {
                        String componentName = FabricComponents.getFabricComponentName((String)this.mObjBuffer[j++]);
                        j += 3;
                        s.append(String.format("CREATE [%d] - layoutable:%d - %s\n", this.mIntBuffer[i++], this.mIntBuffer[i++], componentName));
                        continue;
                    }
                    if (type == 4) {
                        s.append(String.format("DELETE [%d]\n", this.mIntBuffer[i++]));
                        continue;
                    }
                    if (type == 8) {
                        s.append(String.format("INSERT [%d]->[%d] @%d\n", this.mIntBuffer[i++], this.mIntBuffer[i++], this.mIntBuffer[i++]));
                        continue;
                    }
                    if (type == 16) {
                        s.append(String.format("REMOVE [%d]->[%d] @%d\n", this.mIntBuffer[i++], this.mIntBuffer[i++], this.mIntBuffer[i++]));
                        continue;
                    }
                    if (type == 2048) {
                        s.append(String.format("REMOVE+DELETE TREE [%d]->[%d] @%d\n", this.mIntBuffer[i++], this.mIntBuffer[i++], this.mIntBuffer[i++]));
                        continue;
                    }
                    if (type == 32) {
                        Object props = this.mObjBuffer[j++];
                        String propsString = FabricUIManager.IS_DEVELOPMENT_ENVIRONMENT ? (props != null ? props.toString() : "<null>") : "<hidden>";
                        s.append(String.format("UPDATE PROPS [%d]: %s\n", this.mIntBuffer[i++], propsString));
                        continue;
                    }
                    if (type == 64) {
                        StateWrapper state = IntBufferBatchMountItem.castToState(this.mObjBuffer[j++]);
                        String stateString = FabricUIManager.IS_DEVELOPMENT_ENVIRONMENT ? (state != null ? state.getStateData().toString() : "<null>") : "<hidden>";
                        s.append(String.format("UPDATE STATE [%d]: %s\n", this.mIntBuffer[i++], stateString));
                        continue;
                    }
                    if (type == 128) {
                        int reactTag = this.mIntBuffer[i++];
                        int parentTag = this.mIntBuffer[i++];
                        s.append(String.format("UPDATE LAYOUT [%d]->[%d]: x:%d y:%d w:%d h:%d displayType:%d\n", parentTag, reactTag, this.mIntBuffer[i++], this.mIntBuffer[i++], this.mIntBuffer[i++], this.mIntBuffer[i++], this.mIntBuffer[i++]));
                        continue;
                    }
                    if (type == 512) {
                        s.append(String.format("UPDATE PADDING [%d]: top:%d right:%d bottom:%d left:%d\n", this.mIntBuffer[i++], this.mIntBuffer[i++], this.mIntBuffer[i++], this.mIntBuffer[i++], this.mIntBuffer[i++]));
                        continue;
                    }
                    if (type == 1024) {
                        s.append(String.format("UPDATE OVERFLOWINSET [%d]: left:%d top:%d right:%d bottom:%d\n", this.mIntBuffer[i++], this.mIntBuffer[i++], this.mIntBuffer[i++], this.mIntBuffer[i++], this.mIntBuffer[i++]));
                        continue;
                    }
                    if (type == 256) {
                        ++j;
                        s.append(String.format("UPDATE EVENTEMITTER [%d]\n", this.mIntBuffer[i++]));
                        continue;
                    }
                    FLog.e((String)TAG, (String)("String so far: " + s.toString()));
                    throw new IllegalArgumentException("Invalid type argument to IntBufferBatchMountItem: " + type + " at index: " + i);
                }
            }
            return s.toString();
        }
        catch (Exception e) {
            FLog.e((String)TAG, (String)"Caught exception trying to print", (Throwable)e);
            StringBuilder ss = new StringBuilder();
            for (int ii = 0; ii < this.mIntBufferLen; ++ii) {
                ss.append(this.mIntBuffer[ii]);
                ss.append(", ");
            }
            FLog.e((String)TAG, (String)ss.toString());
            for (int jj = 0; jj < this.mObjBufferLen; ++jj) {
                FLog.e((String)TAG, (String)(this.mObjBuffer[jj] != null ? this.mObjBuffer[jj].toString() : "null"));
            }
            return "";
        }
    }
}

