/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge.queue;

import android.os.Looper;
import android.os.Process;
import android.os.SystemClock;
import android.util.Pair;
import com.facebook.common.logging.FLog;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.SoftAssertions;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.queue.MessageQueueThread;
import com.facebook.react.bridge.queue.MessageQueueThreadHandler;
import com.facebook.react.bridge.queue.MessageQueueThreadPerfStats;
import com.facebook.react.bridge.queue.MessageQueueThreadSpec;
import com.facebook.react.bridge.queue.QueueThreadExceptionHandler;
import com.facebook.react.common.futures.SimpleSettableFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

@DoNotStrip
public class MessageQueueThreadImpl
implements MessageQueueThread {
    private final String mName;
    private final Looper mLooper;
    private final MessageQueueThreadHandler mHandler;
    private final String mAssertionErrorMessage;
    private MessageQueueThreadPerfStats mPerfStats;
    private volatile boolean mIsFinished = false;

    private MessageQueueThreadImpl(String name, Looper looper, QueueThreadExceptionHandler exceptionHandler) {
        this(name, looper, exceptionHandler, null);
    }

    private MessageQueueThreadImpl(String name, Looper looper, QueueThreadExceptionHandler exceptionHandler, MessageQueueThreadPerfStats stats) {
        this.mName = name;
        this.mLooper = looper;
        this.mHandler = new MessageQueueThreadHandler(looper, exceptionHandler);
        this.mPerfStats = stats;
        this.mAssertionErrorMessage = "Expected to be called from the '" + this.getName() + "' thread!";
    }

    @Override
    @DoNotStrip
    public boolean runOnQueue(Runnable runnable) {
        if (this.mIsFinished) {
            FLog.w((String)"ReactNative", (String)("Tried to enqueue runnable on already finished thread: '" + this.getName() + "... dropping Runnable."));
            return false;
        }
        this.mHandler.post(runnable);
        return true;
    }

    @Override
    @DoNotStrip
    public <T> Future<T> callOnQueue(final Callable<T> callable) {
        final SimpleSettableFuture future = new SimpleSettableFuture();
        this.runOnQueue(new Runnable(){

            @Override
            public void run() {
                try {
                    future.set(callable.call());
                }
                catch (Exception e) {
                    future.setException(e);
                }
            }
        });
        return future;
    }

    @Override
    @DoNotStrip
    public boolean isOnThread() {
        return this.mLooper.getThread() == Thread.currentThread();
    }

    @Override
    @DoNotStrip
    public void assertIsOnThread() {
        SoftAssertions.assertCondition(this.isOnThread(), this.mAssertionErrorMessage);
    }

    @Override
    @DoNotStrip
    public void assertIsOnThread(String message) {
        SoftAssertions.assertCondition(this.isOnThread(), this.mAssertionErrorMessage + " " + message);
    }

    @Override
    @DoNotStrip
    public void quitSynchronous() {
        this.mIsFinished = true;
        this.mLooper.quit();
        if (this.mLooper.getThread() != Thread.currentThread()) {
            try {
                this.mLooper.getThread().join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Got interrupted waiting to join thread " + this.mName);
            }
        }
    }

    @Override
    @DoNotStrip
    public MessageQueueThreadPerfStats getPerfStats() {
        return this.mPerfStats;
    }

    @Override
    @DoNotStrip
    public void resetPerfStats() {
        MessageQueueThreadImpl.assignToPerfStats(this.mPerfStats, -1L, -1L);
        this.runOnQueue(new Runnable(){

            @Override
            public void run() {
                long wallTime = SystemClock.uptimeMillis();
                long cpuTime = SystemClock.currentThreadTimeMillis();
                MessageQueueThreadImpl.assignToPerfStats(MessageQueueThreadImpl.this.mPerfStats, wallTime, cpuTime);
            }
        });
    }

    private static void assignToPerfStats(MessageQueueThreadPerfStats stats, long wall, long cpu) {
        stats.wallTime = wall;
        stats.cpuTime = cpu;
    }

    public Looper getLooper() {
        return this.mLooper;
    }

    public String getName() {
        return this.mName;
    }

    public static MessageQueueThreadImpl create(MessageQueueThreadSpec spec, QueueThreadExceptionHandler exceptionHandler) {
        switch (spec.getThreadType()) {
            case MAIN_UI: {
                return MessageQueueThreadImpl.createForMainThread(spec.getName(), exceptionHandler);
            }
            case NEW_BACKGROUND: {
                return MessageQueueThreadImpl.startNewBackgroundThread(spec.getName(), spec.getStackSize(), exceptionHandler);
            }
        }
        throw new RuntimeException("Unknown thread type: " + (Object)((Object)spec.getThreadType()));
    }

    private static MessageQueueThreadImpl createForMainThread(String name, QueueThreadExceptionHandler exceptionHandler) {
        Looper mainLooper = Looper.getMainLooper();
        MessageQueueThreadImpl mqt = new MessageQueueThreadImpl(name, mainLooper, exceptionHandler);
        if (UiThreadUtil.isOnUiThread()) {
            Process.setThreadPriority((int)-4);
        } else {
            UiThreadUtil.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    Process.setThreadPriority((int)-4);
                }
            });
        }
        return mqt;
    }

    private static MessageQueueThreadImpl startNewBackgroundThread(String name, long stackSize, QueueThreadExceptionHandler exceptionHandler) {
        final SimpleSettableFuture dataFuture = new SimpleSettableFuture();
        Thread bgThread = new Thread(null, new Runnable(){

            @Override
            public void run() {
                Process.setThreadPriority((int)-4);
                Looper.prepare();
                MessageQueueThreadPerfStats stats = new MessageQueueThreadPerfStats();
                long wallTime = SystemClock.uptimeMillis();
                long cpuTime = SystemClock.currentThreadTimeMillis();
                MessageQueueThreadImpl.assignToPerfStats(stats, wallTime, cpuTime);
                dataFuture.set(new Pair((Object)Looper.myLooper(), (Object)stats));
                Looper.loop();
            }
        }, "mqt_" + name, stackSize);
        bgThread.start();
        Pair pair = (Pair)dataFuture.getOrThrow();
        return new MessageQueueThreadImpl(name, (Looper)pair.first, exceptionHandler, (MessageQueueThreadPerfStats)pair.second);
    }
}

