/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.ActivityEventListener;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.JSExceptionHandler;
import com.facebook.react.bridge.JSIModule;
import com.facebook.react.bridge.JSIModuleType;
import com.facebook.react.bridge.JavaScriptContextHolder;
import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WindowFocusChangeListener;
import com.facebook.react.bridge.interop.InteropModuleRegistry;
import com.facebook.react.bridge.queue.MessageQueueThread;
import com.facebook.react.bridge.queue.ReactQueueConfiguration;
import com.facebook.react.common.LifecycleState;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;

public class ReactContext
extends ContextWrapper {
    private static final String TAG = "ReactContext";
    private static final String EARLY_JS_ACCESS_EXCEPTION_MESSAGE = "Tried to access a JS module before the React instance was fully set up. Calls to ReactContext#getJSModule should only happen once initialize() has been called on your native module.";
    private static final String LATE_JS_ACCESS_EXCEPTION_MESSAGE = "Tried to access a JS module after the React instance was destroyed.";
    private static final String EARLY_NATIVE_MODULE_EXCEPTION_MESSAGE = "Trying to call native module before CatalystInstance has been set!";
    private static final String LATE_NATIVE_MODULE_EXCEPTION_MESSAGE = "Trying to call native module after CatalystInstance has been destroyed!";
    private final CopyOnWriteArraySet<LifecycleEventListener> mLifecycleEventListeners = new CopyOnWriteArraySet();
    private final CopyOnWriteArraySet<ActivityEventListener> mActivityEventListeners = new CopyOnWriteArraySet();
    private final CopyOnWriteArraySet<WindowFocusChangeListener> mWindowFocusEventListeners = new CopyOnWriteArraySet();
    private LifecycleState mLifecycleState = LifecycleState.BEFORE_CREATE;
    private volatile boolean mDestroyed = false;
    @Nullable
    private CatalystInstance mCatalystInstance;
    @Nullable
    private LayoutInflater mInflater;
    @Nullable
    private MessageQueueThread mUiMessageQueueThread;
    @Nullable
    private MessageQueueThread mNativeModulesMessageQueueThread;
    @Nullable
    private MessageQueueThread mJSMessageQueueThread;
    @Nullable
    private JSExceptionHandler mJSExceptionHandler;
    @Nullable
    private JSExceptionHandler mExceptionHandlerWrapper;
    @Nullable
    private WeakReference<Activity> mCurrentActivity;
    @Nullable
    private InteropModuleRegistry mInteropModuleRegistry;
    private boolean mIsInitialized = false;

    public ReactContext(Context base) {
        super(base);
    }

    public void initializeWithInstance(CatalystInstance catalystInstance) {
        if (catalystInstance == null) {
            throw new IllegalArgumentException("CatalystInstance cannot be null.");
        }
        if (this.mCatalystInstance != null) {
            throw new IllegalStateException("ReactContext has been already initialized");
        }
        if (this.mDestroyed) {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("Cannot initialize ReactContext after it has been destroyed."));
        }
        this.mCatalystInstance = catalystInstance;
        ReactQueueConfiguration queueConfig = catalystInstance.getReactQueueConfiguration();
        this.initializeMessageQueueThreads(queueConfig);
        this.initializeInteropModules();
    }

    public synchronized void initializeMessageQueueThreads(ReactQueueConfiguration queueConfig) {
        FLog.w((String)TAG, (String)"initializeMessageQueueThreads() is called.");
        if (this.mUiMessageQueueThread != null || this.mNativeModulesMessageQueueThread != null || this.mJSMessageQueueThread != null) {
            throw new IllegalStateException("Message queue threads already initialized");
        }
        this.mUiMessageQueueThread = queueConfig.getUIQueueThread();
        this.mNativeModulesMessageQueueThread = queueConfig.getNativeModulesQueueThread();
        this.mJSMessageQueueThread = queueConfig.getJSQueueThread();
        if (this.mUiMessageQueueThread == null) {
            throw new IllegalStateException("UI thread is null");
        }
        if (this.mNativeModulesMessageQueueThread == null) {
            throw new IllegalStateException("NativeModules thread is null");
        }
        if (this.mJSMessageQueueThread == null) {
            throw new IllegalStateException("JavaScript thread is null");
        }
        this.mIsInitialized = true;
    }

    protected void initializeInteropModules() {
        this.mInteropModuleRegistry = new InteropModuleRegistry();
    }

    protected void initializeInteropModules(ReactContext reactContext) {
        this.mInteropModuleRegistry = reactContext.mInteropModuleRegistry;
    }

    public void resetPerfStats() {
        if (this.mNativeModulesMessageQueueThread != null) {
            this.mNativeModulesMessageQueueThread.resetPerfStats();
        }
        if (this.mJSMessageQueueThread != null) {
            this.mJSMessageQueueThread.resetPerfStats();
        }
    }

    public void setJSExceptionHandler(@Nullable JSExceptionHandler jSExceptionHandler) {
        this.mJSExceptionHandler = jSExceptionHandler;
    }

    private void raiseCatalystInstanceMissingException() {
        throw new IllegalStateException(this.mDestroyed ? LATE_NATIVE_MODULE_EXCEPTION_MESSAGE : EARLY_NATIVE_MODULE_EXCEPTION_MESSAGE);
    }

    public Object getSystemService(String name) {
        if ("layout_inflater".equals(name)) {
            if (this.mInflater == null) {
                this.mInflater = LayoutInflater.from((Context)this.getBaseContext()).cloneInContext((Context)this);
            }
            return this.mInflater;
        }
        return this.getBaseContext().getSystemService(name);
    }

    public <T extends JavaScriptModule> T getJSModule(Class<T> jsInterface) {
        if (this.mCatalystInstance == null) {
            if (this.mDestroyed) {
                throw new IllegalStateException(LATE_JS_ACCESS_EXCEPTION_MESSAGE);
            }
            throw new IllegalStateException(EARLY_JS_ACCESS_EXCEPTION_MESSAGE);
        }
        if (this.mInteropModuleRegistry != null && this.mInteropModuleRegistry.shouldReturnInteropModule(jsInterface)) {
            return this.mInteropModuleRegistry.getInteropModule(jsInterface);
        }
        return this.mCatalystInstance.getJSModule(jsInterface);
    }

    public <T extends NativeModule> boolean hasNativeModule(Class<T> nativeModuleInterface) {
        if (this.mCatalystInstance == null) {
            this.raiseCatalystInstanceMissingException();
        }
        return this.mCatalystInstance.hasNativeModule(nativeModuleInterface);
    }

    public Collection<NativeModule> getNativeModules() {
        if (this.mCatalystInstance == null) {
            this.raiseCatalystInstanceMissingException();
        }
        return this.mCatalystInstance.getNativeModules();
    }

    @Nullable
    public <T extends NativeModule> T getNativeModule(Class<T> nativeModuleInterface) {
        if (this.mCatalystInstance == null) {
            this.raiseCatalystInstanceMissingException();
        }
        return this.mCatalystInstance.getNativeModule(nativeModuleInterface);
    }

    public void emitDeviceEvent(String eventName, @Nullable Object args) {
        RCTDeviceEventEmitter eventEmitter = this.getJSModule(RCTDeviceEventEmitter.class);
        if (eventEmitter != null) {
            eventEmitter.emit(eventName, args);
        }
    }

    public void emitDeviceEvent(String eventName) {
        this.emitDeviceEvent(eventName, null);
    }

    public CatalystInstance getCatalystInstance() {
        return (CatalystInstance)Assertions.assertNotNull((Object)this.mCatalystInstance);
    }

    @Deprecated
    public boolean hasActiveCatalystInstance() {
        return this.hasActiveReactInstance();
    }

    public boolean hasActiveReactInstance() {
        return this.mCatalystInstance != null && !this.mCatalystInstance.isDestroyed();
    }

    public boolean hasCatalystInstance() {
        return this.mCatalystInstance != null;
    }

    public LifecycleState getLifecycleState() {
        return this.mLifecycleState;
    }

    public void addLifecycleEventListener(final LifecycleEventListener listener) {
        this.mLifecycleEventListeners.add(listener);
        if (this.hasActiveReactInstance() || this.isBridgeless()) {
            switch (this.mLifecycleState) {
                case BEFORE_CREATE: 
                case BEFORE_RESUME: {
                    break;
                }
                case RESUMED: {
                    this.runOnUiQueueThread(new Runnable(){

                        @Override
                        public void run() {
                            if (!ReactContext.this.mLifecycleEventListeners.contains(listener)) {
                                return;
                            }
                            try {
                                listener.onHostResume();
                            }
                            catch (RuntimeException e) {
                                ReactContext.this.handleException(e);
                            }
                        }
                    });
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled lifecycle state.");
                }
            }
        }
    }

    public void removeLifecycleEventListener(LifecycleEventListener listener) {
        this.mLifecycleEventListeners.remove(listener);
    }

    public void addActivityEventListener(ActivityEventListener listener) {
        this.mActivityEventListeners.add(listener);
    }

    public void removeActivityEventListener(ActivityEventListener listener) {
        this.mActivityEventListeners.remove(listener);
    }

    public void addWindowFocusChangeListener(WindowFocusChangeListener listener) {
        this.mWindowFocusEventListeners.add(listener);
    }

    public void removeWindowFocusChangeListener(WindowFocusChangeListener listener) {
        this.mWindowFocusEventListeners.remove(listener);
    }

    @ThreadConfined(value="UI")
    public void onHostResume(@Nullable Activity activity) {
        this.mLifecycleState = LifecycleState.RESUMED;
        this.mCurrentActivity = new WeakReference<Activity>(activity);
        ReactMarker.logMarker(ReactMarkerConstants.ON_HOST_RESUME_START);
        for (LifecycleEventListener listener : this.mLifecycleEventListeners) {
            try {
                listener.onHostResume();
            }
            catch (RuntimeException e) {
                this.handleException(e);
            }
        }
        ReactMarker.logMarker(ReactMarkerConstants.ON_HOST_RESUME_END);
    }

    @ThreadConfined(value="UI")
    public void onNewIntent(@Nullable Activity activity, Intent intent) {
        UiThreadUtil.assertOnUiThread();
        this.mCurrentActivity = new WeakReference<Activity>(activity);
        for (ActivityEventListener listener : this.mActivityEventListeners) {
            try {
                listener.onNewIntent(intent);
            }
            catch (RuntimeException e) {
                this.handleException(e);
            }
        }
    }

    @ThreadConfined(value="UI")
    public void onHostPause() {
        this.mLifecycleState = LifecycleState.BEFORE_RESUME;
        ReactMarker.logMarker(ReactMarkerConstants.ON_HOST_PAUSE_START);
        for (LifecycleEventListener listener : this.mLifecycleEventListeners) {
            try {
                listener.onHostPause();
            }
            catch (RuntimeException e) {
                this.handleException(e);
            }
        }
        ReactMarker.logMarker(ReactMarkerConstants.ON_HOST_PAUSE_END);
    }

    @ThreadConfined(value="UI")
    public void onHostDestroy() {
        UiThreadUtil.assertOnUiThread();
        this.mLifecycleState = LifecycleState.BEFORE_CREATE;
        for (LifecycleEventListener listener : this.mLifecycleEventListeners) {
            try {
                listener.onHostDestroy();
            }
            catch (RuntimeException e) {
                this.handleException(e);
            }
        }
        this.mCurrentActivity = null;
    }

    @ThreadConfined(value="UI")
    public void destroy() {
        UiThreadUtil.assertOnUiThread();
        this.mDestroyed = true;
        if (this.mCatalystInstance != null) {
            this.mCatalystInstance.destroy();
        }
    }

    public void onActivityResult(Activity activity, int requestCode, int resultCode, @Nullable Intent data) {
        for (ActivityEventListener listener : this.mActivityEventListeners) {
            try {
                listener.onActivityResult(activity, requestCode, resultCode, data);
            }
            catch (RuntimeException e) {
                this.handleException(e);
            }
        }
    }

    @ThreadConfined(value="UI")
    public void onWindowFocusChange(boolean hasFocus) {
        UiThreadUtil.assertOnUiThread();
        for (WindowFocusChangeListener listener : this.mWindowFocusEventListeners) {
            try {
                listener.onWindowFocusChange(hasFocus);
            }
            catch (RuntimeException e) {
                this.handleException(e);
            }
        }
    }

    public void assertOnUiQueueThread() {
        ((MessageQueueThread)Assertions.assertNotNull((Object)this.mUiMessageQueueThread)).assertIsOnThread();
    }

    public boolean isOnUiQueueThread() {
        return ((MessageQueueThread)Assertions.assertNotNull((Object)this.mUiMessageQueueThread)).isOnThread();
    }

    public void runOnUiQueueThread(Runnable runnable) {
        ((MessageQueueThread)Assertions.assertNotNull((Object)this.mUiMessageQueueThread)).runOnQueue(runnable);
    }

    public void assertOnNativeModulesQueueThread() {
        if (!this.mIsInitialized) {
            throw new IllegalStateException("Tried to call assertOnNativeModulesQueueThread() on an uninitialized ReactContext");
        }
        ((MessageQueueThread)Assertions.assertNotNull((Object)this.mNativeModulesMessageQueueThread)).assertIsOnThread();
    }

    public void assertOnNativeModulesQueueThread(String message) {
        if (!this.mIsInitialized) {
            throw new IllegalStateException("Tried to call assertOnNativeModulesQueueThread(message) on an uninitialized ReactContext");
        }
        ((MessageQueueThread)Assertions.assertNotNull((Object)this.mNativeModulesMessageQueueThread)).assertIsOnThread(message);
    }

    public boolean isOnNativeModulesQueueThread() {
        return ((MessageQueueThread)Assertions.assertNotNull((Object)this.mNativeModulesMessageQueueThread)).isOnThread();
    }

    public void runOnNativeModulesQueueThread(Runnable runnable) {
        ((MessageQueueThread)Assertions.assertNotNull((Object)this.mNativeModulesMessageQueueThread)).runOnQueue(runnable);
    }

    public void assertOnJSQueueThread() {
        ((MessageQueueThread)Assertions.assertNotNull((Object)this.mJSMessageQueueThread)).assertIsOnThread();
    }

    public boolean isOnJSQueueThread() {
        return ((MessageQueueThread)Assertions.assertNotNull((Object)this.mJSMessageQueueThread)).isOnThread();
    }

    public boolean runOnJSQueueThread(Runnable runnable) {
        return ((MessageQueueThread)Assertions.assertNotNull((Object)this.mJSMessageQueueThread)).runOnQueue(runnable);
    }

    public void handleException(Exception e) {
        boolean hasExceptionHandler;
        boolean catalystInstanceVariableExists = this.mCatalystInstance != null;
        boolean isCatalystInstanceAlive = catalystInstanceVariableExists && !this.mCatalystInstance.isDestroyed();
        boolean bl = hasExceptionHandler = this.mJSExceptionHandler != null;
        if (!isCatalystInstanceAlive || !hasExceptionHandler) {
            FLog.e((String)"ReactNative", (String)("Unable to handle Exception - catalystInstanceVariableExists: " + catalystInstanceVariableExists + " - isCatalystInstanceAlive: " + isCatalystInstanceAlive + " - hasExceptionHandler: " + hasExceptionHandler), (Throwable)e);
            throw new IllegalStateException(e);
        }
        this.mJSExceptionHandler.handleException(e);
    }

    public JSExceptionHandler getExceptionHandler() {
        if (this.mExceptionHandlerWrapper == null) {
            this.mExceptionHandlerWrapper = new ExceptionHandlerWrapper();
        }
        return this.mExceptionHandlerWrapper;
    }

    public JSExceptionHandler getJSExceptionHandler() {
        return this.mJSExceptionHandler;
    }

    public boolean hasCurrentActivity() {
        return this.mCurrentActivity != null && this.mCurrentActivity.get() != null;
    }

    public boolean startActivityForResult(Intent intent, int code, Bundle bundle) {
        Activity activity = this.getCurrentActivity();
        if (activity != null) {
            activity.startActivityForResult(intent, code, bundle);
            return true;
        }
        return false;
    }

    @Nullable
    public Activity getCurrentActivity() {
        if (this.mCurrentActivity == null) {
            return null;
        }
        return (Activity)this.mCurrentActivity.get();
    }

    public boolean isBridgeless() {
        return false;
    }

    public JavaScriptContextHolder getJavaScriptContextHolder() {
        if (this.mCatalystInstance != null) {
            return this.mCatalystInstance.getJavaScriptContextHolder();
        }
        return null;
    }

    @Nullable
    public JSIModule getJSIModule(JSIModuleType moduleType) {
        if (!this.hasActiveReactInstance()) {
            throw new IllegalStateException("Unable to retrieve a JSIModule if CatalystInstance is not active.");
        }
        return this.mCatalystInstance.getJSIModule(moduleType);
    }

    @Nullable
    public String getSourceURL() {
        return this.mCatalystInstance.getSourceURL();
    }

    public void registerSegment(int segmentId, String path, Callback callback) {
        ((CatalystInstance)Assertions.assertNotNull((Object)this.mCatalystInstance)).registerSegment(segmentId, path);
        ((Callback)Assertions.assertNotNull((Object)callback)).invoke(new Object[0]);
    }

    public <T extends JavaScriptModule> void internal_registerInteropModule(Class<T> interopModuleInterface, Object interopModule) {
        if (this.mInteropModuleRegistry != null) {
            this.mInteropModuleRegistry.registerInteropModule(interopModuleInterface, interopModule);
        }
    }

    public class ExceptionHandlerWrapper
    implements JSExceptionHandler {
        @Override
        public void handleException(Exception e) {
            ReactContext.this.handleException(e);
        }
    }

    @DoNotStrip
    public static interface RCTDeviceEventEmitter
    extends JavaScriptModule {
        public void emit(@NonNull String var1, @Nullable Object var2);
    }
}

