/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Assertions;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.LazyReactPackage;
import com.facebook.react.ReactInstancePackage;
import com.facebook.react.ReactPackage;
import com.facebook.react.TurboReactPackage;
import com.facebook.react.bridge.CxxModuleWrapper;
import com.facebook.react.bridge.ModuleSpec;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.config.ReactFeatureFlags;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.module.model.ReactModuleInfo;
import com.facebook.react.turbomodule.core.TurboModuleManagerDelegate;
import com.facebook.react.turbomodule.core.interfaces.TurboModule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;

public abstract class ReactPackageTurboModuleManagerDelegate
extends TurboModuleManagerDelegate {
    private final List<ModuleProvider> mModuleProviders = new ArrayList<ModuleProvider>();
    private final Map<ModuleProvider, Map<String, ReactModuleInfo>> mPackageModuleInfos = new HashMap<ModuleProvider, Map<String, ReactModuleInfo>>();

    private static boolean shouldSupportLegacyPackages() {
        return ReactFeatureFlags.enableBridgelessArchitecture && ReactFeatureFlags.unstable_useTurboModuleInterop;
    }

    protected ReactPackageTurboModuleManagerDelegate(ReactApplicationContext reactApplicationContext, List<ReactPackage> packages) {
        final ReactApplicationContext applicationContext = reactApplicationContext;
        for (ReactPackage reactPackage : packages) {
            Object moduleProvider;
            if (reactPackage instanceof TurboReactPackage) {
                final TurboReactPackage turboPkg = (TurboReactPackage)reactPackage;
                ModuleProvider moduleProvider2 = new ModuleProvider(){

                    @Override
                    public NativeModule getModule(String moduleName) {
                        return turboPkg.getModule(moduleName, applicationContext);
                    }
                };
                this.mModuleProviders.add(moduleProvider2);
                this.mPackageModuleInfos.put(moduleProvider2, turboPkg.getReactModuleInfoProvider().getReactModuleInfos());
                continue;
            }
            if (ReactPackageTurboModuleManagerDelegate.shouldSupportLegacyPackages() && reactPackage instanceof LazyReactPackage) {
                LazyReactPackage lazyPkg = (LazyReactPackage)reactPackage;
                List<ModuleSpec> moduleSpecs = lazyPkg.getNativeModules(reactApplicationContext);
                final HashMap<String, Provider<? extends NativeModule>> moduleSpecProviderMap = new HashMap<String, Provider<? extends NativeModule>>();
                for (ModuleSpec moduleSpec : moduleSpecs) {
                    moduleSpecProviderMap.put(moduleSpec.getName(), moduleSpec.getProvider());
                }
                moduleProvider = new ModuleProvider(){

                    @Override
                    public NativeModule getModule(String moduleName) {
                        Provider provider = (Provider)moduleSpecProviderMap.get(moduleName);
                        return provider != null ? (NativeModule)provider.get() : null;
                    }
                };
                this.mModuleProviders.add((ModuleProvider)moduleProvider);
                this.mPackageModuleInfos.put((ModuleProvider)moduleProvider, lazyPkg.getReactModuleInfoProvider().getReactModuleInfos());
                continue;
            }
            if (ReactPackageTurboModuleManagerDelegate.shouldSupportLegacyPackages() && reactPackage instanceof ReactInstancePackage || !ReactPackageTurboModuleManagerDelegate.shouldSupportLegacyPackages()) continue;
            List<NativeModule> nativeModules = reactPackage.createNativeModules(reactApplicationContext);
            final HashMap<String, NativeModule> moduleMap = new HashMap<String, NativeModule>();
            HashMap<String, ReactModuleInfo> reactModuleInfoMap = new HashMap<String, ReactModuleInfo>();
            for (NativeModule module : nativeModules) {
                Class<?> moduleClass = module.getClass();
                ReactModule reactModule = moduleClass.getAnnotation(ReactModule.class);
                String moduleName = reactModule != null ? reactModule.name() : module.getName();
                ReactModuleInfo moduleInfo = reactModule != null ? new ReactModuleInfo(moduleName, moduleClass.getName(), reactModule.canOverrideExistingModule(), true, reactModule.hasConstants(), reactModule.isCxxModule(), TurboModule.class.isAssignableFrom(moduleClass)) : new ReactModuleInfo(moduleName, moduleClass.getName(), module.canOverrideExistingModule(), true, true, CxxModuleWrapper.class.isAssignableFrom(moduleClass), TurboModule.class.isAssignableFrom(moduleClass));
                reactModuleInfoMap.put(moduleName, moduleInfo);
                moduleMap.put(moduleName, module);
            }
            moduleProvider = new ModuleProvider(){

                @Override
                public NativeModule getModule(String moduleName) {
                    return (NativeModule)moduleMap.get(moduleName);
                }
            };
            this.mModuleProviders.add((ModuleProvider)moduleProvider);
            this.mPackageModuleInfos.put((ModuleProvider)moduleProvider, reactModuleInfoMap);
        }
    }

    @Override
    @Nullable
    public TurboModule getModule(String moduleName) {
        TurboModule module = this.resolveModule(moduleName);
        if (module == null) {
            return null;
        }
        if (module instanceof CxxModuleWrapper) {
            return null;
        }
        return module;
    }

    @Override
    @Nullable
    @DoNotStrip
    public CxxModuleWrapper getLegacyCxxModule(String moduleName) {
        TurboModule module = this.resolveModule(moduleName);
        if (module == null) {
            return null;
        }
        if (!(module instanceof CxxModuleWrapper)) {
            return null;
        }
        return (CxxModuleWrapper)((Object)module);
    }

    @Nullable
    private TurboModule resolveModule(String moduleName) {
        NativeModule resolvedModule = null;
        for (ModuleProvider moduleProvider : this.mModuleProviders) {
            try {
                NativeModule module;
                ReactModuleInfo moduleInfo = this.mPackageModuleInfos.get(moduleProvider).get(moduleName);
                if (moduleInfo == null || !moduleInfo.isTurboModule() || resolvedModule != null && !moduleInfo.canOverrideExistingModule() || (module = moduleProvider.getModule(moduleName)) == null) continue;
                resolvedModule = module;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (resolvedModule instanceof TurboModule) {
            return (TurboModule)((Object)resolvedModule);
        }
        return null;
    }

    @Override
    public List<String> getEagerInitModuleNames() {
        ArrayList<String> moduleNames = new ArrayList<String>();
        for (ModuleProvider moduleProvider : this.mModuleProviders) {
            for (ReactModuleInfo moduleInfo : this.mPackageModuleInfos.get(moduleProvider).values()) {
                if (!moduleInfo.isTurboModule() || !moduleInfo.needsEagerInit()) continue;
                moduleNames.add(moduleInfo.name());
            }
        }
        return moduleNames;
    }

    public static abstract class Builder {
        @Nullable
        private List<ReactPackage> mPackages;
        @Nullable
        private ReactApplicationContext mContext;

        public Builder setPackages(List<ReactPackage> packages) {
            this.mPackages = new ArrayList<ReactPackage>(packages);
            return this;
        }

        public Builder setReactApplicationContext(ReactApplicationContext context) {
            this.mContext = context;
            return this;
        }

        protected abstract ReactPackageTurboModuleManagerDelegate build(ReactApplicationContext var1, List<ReactPackage> var2);

        public ReactPackageTurboModuleManagerDelegate build() {
            Assertions.assertNotNull((Object)((Object)this.mContext), (String)"The ReactApplicationContext must be provided to create ReactPackageTurboModuleManagerDelegate");
            Assertions.assertNotNull(this.mPackages, (String)"A set of ReactPackages must be provided to create ReactPackageTurboModuleManagerDelegate");
            return this.build(this.mContext, this.mPackages);
        }
    }

    static interface ModuleProvider {
        @Nullable
        public NativeModule getModule(String var1);
    }
}

