/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.plan;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.javax.annotation.concurrent.Immutable;
import com.facebook.presto.jdbc.internal.spi.SourceLocation;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNode;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNodeId;
import com.facebook.presto.jdbc.internal.spi.plan.PlanVisitor;
import com.facebook.presto.jdbc.internal.spi.relation.RowExpression;
import com.facebook.presto.jdbc.internal.spi.relation.VariableReferenceExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@Immutable
public final class ValuesNode
extends PlanNode {
    private final List<VariableReferenceExpression> outputVariables;
    private final List<List<RowExpression>> rows;

    @JsonCreator
    public ValuesNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="outputVariables") List<VariableReferenceExpression> outputVariables, @JsonProperty(value="rows") List<List<RowExpression>> rows) {
        super(sourceLocation, id);
        this.outputVariables = ValuesNode.immutableListCopyOf(outputVariables);
        this.rows = ValuesNode.immutableListCopyOf(Objects.requireNonNull(rows, "lists is null").stream().map(ValuesNode::immutableListCopyOf).collect(Collectors.toList()));
        for (List<RowExpression> row : rows) {
            if (row.size() == outputVariables.size() || row.isEmpty()) continue;
            throw new IllegalArgumentException(String.format("Expected row to have %s values, but row has %s values", outputVariables.size(), row.size()));
        }
    }

    @JsonProperty
    public List<List<RowExpression>> getRows() {
        return this.rows;
    }

    @Override
    @JsonProperty
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputVariables;
    }

    @Override
    public List<PlanNode> getSources() {
        return Collections.unmodifiableList(Collections.emptyList());
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitValues(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        if (!newChildren.isEmpty()) {
            throw new IllegalArgumentException("newChildren is not empty");
        }
        return this;
    }

    private static <T> List<T> immutableListCopyOf(List<T> list) {
        return Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(list, "list is null")));
    }
}

