/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.memory;

import com.facebook.presto.jdbc.internal.drift.annotations.ThriftConstructor;
import com.facebook.presto.jdbc.internal.drift.annotations.ThriftField;
import com.facebook.presto.jdbc.internal.drift.annotations.ThriftStruct;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.spi.QueryId;
import com.facebook.presto.jdbc.internal.spi.memory.MemoryPoolInfo;
import java.util.Objects;
import java.util.Optional;

@ThriftStruct
public final class ClusterMemoryPoolInfo {
    private final MemoryPoolInfo memoryPoolInfo;
    private final int blockedNodes;
    private final int assignedQueries;
    private final Optional<QueryId> largestMemoryQuery;

    public ClusterMemoryPoolInfo(MemoryPoolInfo memoryPoolInfo, int blockedNodes, int assignedQueries) {
        this(memoryPoolInfo, blockedNodes, assignedQueries, Optional.empty());
    }

    @ThriftConstructor
    @JsonCreator
    public ClusterMemoryPoolInfo(@JsonProperty(value="memoryPoolInfo") MemoryPoolInfo memoryPoolInfo, int blockedNodes, int assignedQueries, Optional<QueryId> largestMemoryQuery) {
        this.memoryPoolInfo = Objects.requireNonNull(memoryPoolInfo, "memoryPoolInfo is null");
        this.blockedNodes = blockedNodes;
        this.assignedQueries = assignedQueries;
        this.largestMemoryQuery = largestMemoryQuery;
    }

    @ThriftField(value=1)
    @JsonProperty
    public MemoryPoolInfo getMemoryPoolInfo() {
        return this.memoryPoolInfo;
    }

    @ThriftField(value=2)
    @JsonProperty
    public int getBlockedNodes() {
        return this.blockedNodes;
    }

    @ThriftField(value=3)
    @JsonProperty
    public int getAssignedQueries() {
        return this.assignedQueries;
    }

    @ThriftField(value=4)
    @JsonProperty
    public Optional<QueryId> getLargestMemoryQuery() {
        return this.largestMemoryQuery;
    }
}

