/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.io.airlift.slice;

import com.facebook.presto.jdbc.internal.io.airlift.slice.Slice;

public class FnvHash {
    private static final long FNV_64_OFFSET_BASIS = -3750763034362895579L;
    private static final long FNV_64_PRIME = 1099511628211L;
    private static final int FNV_32_OFFSET_BASIS = -2128831035;
    private static final int FNV_32_PRIME = 16777619;

    private FnvHash() {
    }

    public static int hash32(Slice data) {
        int hash = -2128831035;
        for (int i = 0; i < data.length(); ++i) {
            byte dataByte = data.getByte(i);
            hash ^= dataByte;
            hash *= 16777619;
        }
        return hash;
    }

    public static long hash64(Slice data) {
        long hash = -3750763034362895579L;
        for (int i = 0; i < data.length(); ++i) {
            byte dataByte = data.getByte(i);
            hash ^= (long)dataByte;
            hash *= 1099511628211L;
        }
        return hash;
    }
}

