/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.type;

import com.facebook.presto.jdbc.internal.common.type.TimeZoneKey;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonValue;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public final class SqlTimestamp {
    private static final long MICROS_PER_SECOND = 1000000L;
    private static final long NANOS_PER_MICROS = 1000L;
    private static final String JSON_MILLIS_FORMAT = "uuuu-MM-dd HH:mm:ss.SSS";
    public static final DateTimeFormatter JSON_MILLIS_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss.SSS");
    private static final String JSON_MICROS_FORMAT = "uuuu-MM-dd HH:mm:ss.SSSSSS";
    public static final DateTimeFormatter JSON_MICROS_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss.SSSSSS");
    private final long value;
    private final Optional<TimeZoneKey> sessionTimeZoneKey;
    private final TimeUnit precision;

    public SqlTimestamp(long value, TimeUnit precision) {
        this.value = value;
        this.sessionTimeZoneKey = Optional.empty();
        this.precision = SqlTimestamp.validatePrecision(precision);
    }

    @Deprecated
    public SqlTimestamp(long valueUTC, TimeZoneKey sessionTimeZoneKey, TimeUnit precision) {
        this.value = valueUTC;
        this.sessionTimeZoneKey = Optional.of(sessionTimeZoneKey);
        this.precision = SqlTimestamp.validatePrecision(precision);
    }

    public long getMillis() {
        SqlTimestamp.checkState(!this.isLegacyTimestamp(), "getMillis() can be called in new timestamp semantics only");
        return this.precision.toMillis(this.value);
    }

    @Deprecated
    public long getMillisUtc() {
        SqlTimestamp.checkState(this.isLegacyTimestamp(), "getMillisUtc() can be called in legacy timestamp semantics only");
        return this.precision.toMillis(this.value);
    }

    @Deprecated
    public Optional<TimeZoneKey> getSessionTimeZoneKey() {
        return this.sessionTimeZoneKey;
    }

    @Deprecated
    public boolean isLegacyTimestamp() {
        return this.sessionTimeZoneKey.isPresent();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.precision, this.sessionTimeZoneKey});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlTimestamp other = (SqlTimestamp)obj;
        return this.value == other.value && this.precision == other.precision && Objects.equals(this.sessionTimeZoneKey, other.sessionTimeZoneKey);
    }

    @JsonValue
    public String toString() {
        if (this.precision == TimeUnit.MILLISECONDS) {
            return this.formatInstant(SqlTimestamp.millisToInstant(this.value), JSON_MILLIS_FORMATTER);
        }
        if (this.precision == TimeUnit.MICROSECONDS) {
            return this.formatInstant(SqlTimestamp.microsToInstant(this.value), JSON_MICROS_FORMATTER);
        }
        throw new UnsupportedOperationException("Precision not supported " + (Object)((Object)this.precision));
    }

    private String formatInstant(Instant instant, DateTimeFormatter formatter) {
        if (this.isLegacyTimestamp()) {
            return instant.atZone(ZoneId.of(this.sessionTimeZoneKey.get().getId())).format(formatter);
        }
        return instant.atZone(ZoneId.of(TimeZoneKey.UTC_KEY.getId())).format(formatter);
    }

    private static TimeUnit validatePrecision(TimeUnit precision) {
        Objects.requireNonNull(precision, "precision");
        if (precision == TimeUnit.MILLISECONDS || precision == TimeUnit.MICROSECONDS) {
            return precision;
        }
        throw new UnsupportedOperationException("Precision not supported " + (Object)((Object)precision));
    }

    private static Instant millisToInstant(long epochMillis) {
        return Instant.ofEpochMilli(epochMillis);
    }

    private static Instant microsToInstant(long epochMicros) {
        long seconds = Math.floorDiv(epochMicros, 1000000L);
        long micros = Math.floorMod(epochMicros, 1000000L);
        return Instant.ofEpochSecond(seconds, micros * 1000L);
    }

    private static void checkState(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }
}

