/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.predicate;

import com.facebook.presto.jdbc.internal.common.Utils;
import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.function.SqlFunctionProperties;
import com.facebook.presto.jdbc.internal.common.type.Type;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public final class Marker
implements Comparable<Marker> {
    private final Type type;
    private final Optional<Block> valueBlock;
    private final Bound bound;

    @JsonCreator
    public Marker(@JsonProperty(value="type") Type type, @JsonProperty(value="valueBlock") Optional<Block> valueBlock, @JsonProperty(value="bound") Bound bound) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(valueBlock, "valueBlock is null");
        Objects.requireNonNull(bound, "bound is null");
        if (!type.isOrderable()) {
            throw new IllegalArgumentException("type must be orderable");
        }
        if (!valueBlock.isPresent() && bound == Bound.EXACTLY) {
            throw new IllegalArgumentException("Can not be equal to unbounded");
        }
        if (valueBlock.isPresent() && valueBlock.get().getPositionCount() != 1) {
            throw new IllegalArgumentException("value block should only have one position");
        }
        this.type = type;
        this.valueBlock = valueBlock;
        this.bound = bound;
    }

    private static Marker create(Type type, Optional<Object> value, Bound bound) {
        return new Marker(type, value.map(object -> Utils.nativeValueToBlock(type, object)), bound);
    }

    public static Marker upperUnbounded(Type type) {
        Objects.requireNonNull(type, "type is null");
        return Marker.create(type, Optional.empty(), Bound.BELOW);
    }

    public static Marker lowerUnbounded(Type type) {
        Objects.requireNonNull(type, "type is null");
        return Marker.create(type, Optional.empty(), Bound.ABOVE);
    }

    public static Marker above(Type type, Object value) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(value, "value is null");
        return Marker.create(type, Optional.of(value), Bound.ABOVE);
    }

    public static Marker exactly(Type type, Object value) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(value, "value is null");
        return Marker.create(type, Optional.of(value), Bound.EXACTLY);
    }

    public static Marker below(Type type, Object value) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(value, "value is null");
        return Marker.create(type, Optional.of(value), Bound.BELOW);
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public Optional<Block> getValueBlock() {
        return this.valueBlock;
    }

    public Object getValue() {
        if (!this.valueBlock.isPresent()) {
            throw new IllegalStateException("No value to get");
        }
        return Utils.blockToNativeValue(this.type, this.valueBlock.get());
    }

    public Object getPrintableValue(SqlFunctionProperties properties) {
        if (!this.valueBlock.isPresent()) {
            throw new IllegalStateException("No value to get");
        }
        return this.type.getObjectValue(properties, this.valueBlock.get(), 0);
    }

    @JsonProperty
    public Bound getBound() {
        return this.bound;
    }

    public boolean isUpperUnbounded() {
        return !this.valueBlock.isPresent() && this.bound == Bound.BELOW;
    }

    public boolean isLowerUnbounded() {
        return !this.valueBlock.isPresent() && this.bound == Bound.ABOVE;
    }

    private void checkTypeCompatibility(Marker marker) {
        if (!this.type.equals(marker.getType())) {
            throw new IllegalArgumentException(String.format("Mismatched Marker types: %s vs %s", this.type, marker.getType()));
        }
    }

    public boolean isAdjacent(Marker other) {
        this.checkTypeCompatibility(other);
        if (this.isUpperUnbounded() || this.isLowerUnbounded() || other.isUpperUnbounded() || other.isLowerUnbounded()) {
            return false;
        }
        if (this.type.compareTo(this.valueBlock.get(), 0, other.valueBlock.get(), 0) != 0) {
            return false;
        }
        return this.bound == Bound.EXACTLY && other.bound != Bound.EXACTLY || this.bound != Bound.EXACTLY && other.bound == Bound.EXACTLY;
    }

    public Marker greaterAdjacent() {
        if (!this.valueBlock.isPresent()) {
            throw new IllegalStateException("No marker adjacent to unbounded");
        }
        switch (this.bound) {
            case BELOW: {
                return new Marker(this.type, this.valueBlock, Bound.EXACTLY);
            }
            case EXACTLY: {
                return new Marker(this.type, this.valueBlock, Bound.ABOVE);
            }
            case ABOVE: {
                throw new IllegalStateException("No greater marker adjacent to an ABOVE bound");
            }
        }
        throw new AssertionError((Object)("Unsupported type: " + (Object)((Object)this.bound)));
    }

    public Marker lesserAdjacent() {
        if (!this.valueBlock.isPresent()) {
            throw new IllegalStateException("No marker adjacent to unbounded");
        }
        switch (this.bound) {
            case BELOW: {
                throw new IllegalStateException("No lesser marker adjacent to a BELOW bound");
            }
            case EXACTLY: {
                return new Marker(this.type, this.valueBlock, Bound.BELOW);
            }
            case ABOVE: {
                return new Marker(this.type, this.valueBlock, Bound.EXACTLY);
            }
        }
        throw new AssertionError((Object)("Unsupported type: " + (Object)((Object)this.bound)));
    }

    @Override
    public int compareTo(Marker o) {
        this.checkTypeCompatibility(o);
        if (this.isUpperUnbounded()) {
            return o.isUpperUnbounded() ? 0 : 1;
        }
        if (this.isLowerUnbounded()) {
            return o.isLowerUnbounded() ? 0 : -1;
        }
        if (o.isUpperUnbounded()) {
            return -1;
        }
        if (o.isLowerUnbounded()) {
            return 1;
        }
        int compare = this.type.compareTo(this.valueBlock.get(), 0, o.valueBlock.get(), 0);
        if (compare == 0) {
            if (this.bound == o.bound) {
                return 0;
            }
            if (this.bound == Bound.BELOW) {
                return -1;
            }
            if (this.bound == Bound.ABOVE) {
                return 1;
            }
            return o.bound == Bound.BELOW ? 1 : -1;
        }
        return compare;
    }

    public static Marker min(Marker marker1, Marker marker2) {
        return marker1.compareTo(marker2) <= 0 ? marker1 : marker2;
    }

    public static Marker max(Marker marker1, Marker marker2) {
        return marker1.compareTo(marker2) >= 0 ? marker1 : marker2;
    }

    public int hashCode() {
        int hash = Objects.hash(new Object[]{this.type, this.bound});
        if (this.valueBlock.isPresent()) {
            hash = hash * 31 + (int)this.type.hash(this.valueBlock.get(), 0);
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Marker other = (Marker)obj;
        return Objects.equals(this.type, other.type) && Objects.equals((Object)this.bound, (Object)other.bound) && this.valueBlock.isPresent() == other.valueBlock.isPresent() && (!this.valueBlock.isPresent() || this.type.equalTo(this.valueBlock.get(), 0, other.valueBlock.get(), 0));
    }

    public String toString(SqlFunctionProperties properties) {
        StringBuilder buffer = new StringBuilder("{");
        buffer.append("type=").append(this.type);
        buffer.append(", value=");
        if (this.isLowerUnbounded()) {
            buffer.append("<min>");
        } else if (this.isUpperUnbounded()) {
            buffer.append("<max>");
        } else {
            buffer.append(this.getPrintableValue(properties));
        }
        buffer.append(", bound=").append((Object)this.bound);
        buffer.append("}");
        return buffer.toString();
    }

    public static enum Bound {
        BELOW,
        EXACTLY,
        ABOVE;

    }
}

