/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.block;

import com.facebook.presto.jdbc.internal.common.block.AbstractArrayBlock;
import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.javax.annotation.Nullable;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import java.util.Objects;
import java.util.Optional;
import java.util.function.ObjLongConsumer;

public class ArrayBlock
extends AbstractArrayBlock {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ArrayBlock.class).instanceSize();
    private final int arrayOffset;
    private final int positionCount;
    @Nullable
    private final boolean[] valueIsNull;
    private final Block values;
    private final int[] offsets;
    private volatile long sizeInBytes;
    private volatile long logicalSizeInBytes;
    private final long retainedSizeInBytes;

    public static Block fromElementBlock(int positionCount, Optional<boolean[]> valueIsNullOptional, int[] arrayOffset, Block values) {
        boolean[] valueIsNull = valueIsNullOptional.orElse(null);
        ArrayBlock.validateConstructorArguments(0, positionCount, valueIsNull, arrayOffset, values);
        for (int i = 0; i < positionCount; ++i) {
            int offset = arrayOffset[i];
            int length = arrayOffset[i + 1] - offset;
            if (length < 0) {
                throw new IllegalArgumentException(String.format("Offset is not monotonically ascending. offsets[%s]=%s, offsets[%s]=%s", i, arrayOffset[i], i + 1, arrayOffset[i + 1]));
            }
            if (valueIsNull == null || !valueIsNull[i] || length == 0) continue;
            throw new IllegalArgumentException("A null array must have zero entries");
        }
        return new ArrayBlock(0, positionCount, valueIsNull, arrayOffset, values);
    }

    static ArrayBlock createArrayBlockInternal(int arrayOffset, int positionCount, @Nullable boolean[] valueIsNull, int[] offsets, Block values) {
        ArrayBlock.validateConstructorArguments(arrayOffset, positionCount, valueIsNull, offsets, values);
        return new ArrayBlock(arrayOffset, positionCount, valueIsNull, offsets, values);
    }

    private static void validateConstructorArguments(int arrayOffset, int positionCount, @Nullable boolean[] valueIsNull, int[] offsets, Block values) {
        if (arrayOffset < 0) {
            throw new IllegalArgumentException("arrayOffset is negative");
        }
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        if (valueIsNull != null && valueIsNull.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("isNull length is less than positionCount");
        }
        Objects.requireNonNull(offsets, "offsets is null");
        if (offsets.length - arrayOffset < positionCount + 1) {
            throw new IllegalArgumentException("offsets length is less than positionCount");
        }
        Objects.requireNonNull(values, "values is null");
    }

    private ArrayBlock(int arrayOffset, int positionCount, @Nullable boolean[] valueIsNull, int[] offsets, Block values) {
        this.arrayOffset = arrayOffset;
        this.positionCount = positionCount;
        this.valueIsNull = valueIsNull;
        this.offsets = offsets;
        this.values = Objects.requireNonNull(values);
        this.sizeInBytes = -1L;
        this.logicalSizeInBytes = -1L;
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + values.getRetainedSizeInBytes() + SizeOf.sizeOf(offsets) + SizeOf.sizeOf(valueIsNull);
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        if (this.sizeInBytes < 0L) {
            this.calculateSize();
        }
        return this.sizeInBytes;
    }

    @Override
    public long getLogicalSizeInBytes() {
        if (this.logicalSizeInBytes < 0L) {
            this.calculateLogicalSize();
        }
        return this.logicalSizeInBytes;
    }

    private void calculateSize() {
        int valueStart = this.offsets[this.arrayOffset];
        int valueEnd = this.offsets[this.arrayOffset + this.positionCount];
        this.sizeInBytes = this.values.getRegionSizeInBytes(valueStart, valueEnd - valueStart) + 5L * (long)this.positionCount;
    }

    private void calculateLogicalSize() {
        int valueStart = this.offsets[this.arrayOffset];
        int valueEnd = this.offsets[this.arrayOffset + this.positionCount];
        this.logicalSizeInBytes = this.values.getRegionLogicalSizeInBytes(valueStart, valueEnd - valueStart) + 5L * (long)this.positionCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        consumer.accept(this.values, this.values.getRetainedSizeInBytes());
        consumer.accept(this.offsets, SizeOf.sizeOf(this.offsets));
        if (this.valueIsNull != null) {
            consumer.accept(this.valueIsNull, SizeOf.sizeOf(this.valueIsNull));
        }
        consumer.accept(this, INSTANCE_SIZE);
    }

    @Override
    protected Block getRawElementBlock() {
        return this.values;
    }

    @Override
    protected int[] getOffsets() {
        return this.offsets;
    }

    @Override
    public int getOffsetBase() {
        return this.arrayOffset;
    }

    @Override
    @Nullable
    protected boolean[] getValueIsNull() {
        return this.valueIsNull;
    }

    @Override
    public boolean mayHaveNull() {
        return this.valueIsNull != null;
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.valueIsNull != null && this.valueIsNull[position + this.arrayOffset];
    }

    public String toString() {
        return String.format("ArrayBlock(%d){positionCount=%d}", this.hashCode(), this.getPositionCount());
    }

    @Override
    public Block getLoadedBlock() {
        Block loadedValuesBlock = this.values.getLoadedBlock();
        if (loadedValuesBlock == this.values) {
            return this;
        }
        return ArrayBlock.createArrayBlockInternal(this.arrayOffset, this.positionCount, this.valueIsNull, this.offsets, loadedValuesBlock);
    }

    private boolean isSinglePositionBlock(int position) {
        return position == 0 && this.positionCount == 1 && this.offsets.length == 2;
    }

    @Override
    public Block getSingleValueBlock(int position) {
        if (this.isSinglePositionBlock(position)) {
            return this;
        }
        return this.getSingleValueBlockInternal(position);
    }
}

