/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.com.facebook.airlift.json;

import java.io.IOException;
import java.io.Writer;
import java.util.Objects;

class LengthLimitedWriter
extends Writer {
    private final Writer writer;
    private final int maxLength;
    private int count;

    public LengthLimitedWriter(Writer writer, int maxLength) {
        this.writer = Objects.requireNonNull(writer, "writer is null");
        this.maxLength = maxLength;
    }

    @Override
    public void write(char[] buffer, int offset, int length) throws IOException {
        this.count += length;
        if (this.count > this.maxLength) {
            throw new LengthLimitExceededException();
        }
        this.writer.write(buffer, offset, length);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public static class LengthLimitExceededException
    extends IOException {
    }
}

