/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PublisherBlockList
extends APINode {
    @SerializedName(value="app_publishers")
    private List<Object> mAppPublishers = null;
    @SerializedName(value="business_owner_id")
    private String mBusinessOwnerId = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_auto_blocking_on")
    private Boolean mIsAutoBlockingOn = null;
    @SerializedName(value="is_eligible_at_campaign_level")
    private Boolean mIsEligibleAtCampaignLevel = null;
    @SerializedName(value="last_update_time")
    private String mLastUpdateTime = null;
    @SerializedName(value="last_update_user")
    private String mLastUpdateUser = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="owner_ad_account_id")
    private String mOwnerAdAccountId = null;
    @SerializedName(value="web_publishers")
    private List<Object> mWebPublishers = null;
    protected static Gson gson = null;

    PublisherBlockList() {
    }

    public PublisherBlockList(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public PublisherBlockList(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public PublisherBlockList fetch() throws APIException {
        PublisherBlockList newInstance = PublisherBlockList.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static PublisherBlockList fetchById(Long id, APIContext context) throws APIException {
        return PublisherBlockList.fetchById(id.toString(), context);
    }

    public static ListenableFuture<PublisherBlockList> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return PublisherBlockList.fetchByIdAsync(id.toString(), context);
    }

    public static PublisherBlockList fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<PublisherBlockList> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<PublisherBlockList> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<PublisherBlockList>(context, "", "/", "GET", PublisherBlockList.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<PublisherBlockList>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<PublisherBlockList>(context, "", "/", "GET", PublisherBlockList.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static PublisherBlockList loadJSON(String json, APIContext context, String header) {
        PublisherBlockList publisherBlockList = (PublisherBlockList)PublisherBlockList.getGson().fromJson(json, PublisherBlockList.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(publisherBlockList.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        publisherBlockList.context = context;
        publisherBlockList.rawValue = json;
        publisherBlockList.header = header;
        return publisherBlockList;
    }

    public static APINodeList<PublisherBlockList> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PublisherBlockList> publisherBlockLists = new APINodeList<PublisherBlockList>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        publisherBlockLists.add(PublisherBlockList.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return publisherBlockLists;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            publisherBlockLists.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        publisherBlockLists.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            publisherBlockLists.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            publisherBlockLists.add(PublisherBlockList.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                publisherBlockLists.add(PublisherBlockList.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            publisherBlockLists.add(PublisherBlockList.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return publisherBlockLists;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        publisherBlockLists.add(PublisherBlockList.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return publisherBlockLists;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        publisherBlockLists.add(PublisherBlockList.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return publisherBlockLists;
                }
                publisherBlockLists.clear();
                publisherBlockLists.add(PublisherBlockList.loadJSON(json, context, header));
                return publisherBlockLists;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PublisherBlockList.getGson().toJson((Object)this);
    }

    public APIRequestCreateAppendPublisherUrl createAppendPublisherUrl() {
        return new APIRequestCreateAppendPublisherUrl(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetPagedWebPublishers getPagedWebPublishers() {
        return new APIRequestGetPagedWebPublishers(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public List<Object> getFieldAppPublishers() {
        return this.mAppPublishers;
    }

    public String getFieldBusinessOwnerId() {
        return this.mBusinessOwnerId;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsAutoBlockingOn() {
        return this.mIsAutoBlockingOn;
    }

    public Boolean getFieldIsEligibleAtCampaignLevel() {
        return this.mIsEligibleAtCampaignLevel;
    }

    public String getFieldLastUpdateTime() {
        return this.mLastUpdateTime;
    }

    public String getFieldLastUpdateUser() {
        return this.mLastUpdateUser;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldOwnerAdAccountId() {
        return this.mOwnerAdAccountId;
    }

    public List<Object> getFieldWebPublishers() {
        return this.mWebPublishers;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PublisherBlockList copyFrom(PublisherBlockList instance) {
        this.mAppPublishers = instance.mAppPublishers;
        this.mBusinessOwnerId = instance.mBusinessOwnerId;
        this.mId = instance.mId;
        this.mIsAutoBlockingOn = instance.mIsAutoBlockingOn;
        this.mIsEligibleAtCampaignLevel = instance.mIsEligibleAtCampaignLevel;
        this.mLastUpdateTime = instance.mLastUpdateTime;
        this.mLastUpdateUser = instance.mLastUpdateUser;
        this.mName = instance.mName;
        this.mOwnerAdAccountId = instance.mOwnerAdAccountId;
        this.mWebPublishers = instance.mWebPublishers;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PublisherBlockList> getParser() {
        return new APIRequest.ResponseParser<PublisherBlockList>(){

            @Override
            public APINodeList<PublisherBlockList> parseResponse(String response, APIContext context, APIRequest<PublisherBlockList> request, String header) throws APIException.MalformedResponseException {
                return PublisherBlockList.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestUpdate
    extends APIRequest<PublisherBlockList> {
        PublisherBlockList lastResponse = null;
        public static final String[] PARAMS = new String[]{"spec"};
        public static final String[] FIELDS = new String[0];

        @Override
        public PublisherBlockList getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PublisherBlockList parseResponse(String response, String header) throws APIException {
            return PublisherBlockList.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public PublisherBlockList execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PublisherBlockList execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<PublisherBlockList> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PublisherBlockList> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, PublisherBlockList>(){

                public PublisherBlockList apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setSpec(Object spec) {
            this.setParam("spec", spec);
            return this;
        }

        public APIRequestUpdate setSpec(String spec) {
            this.setParam("spec", spec);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGet
    extends APIRequest<PublisherBlockList> {
        PublisherBlockList lastResponse = null;
        public static final String[] PARAMS = new String[]{"account_id", "business_id", "draft_id"};
        public static final String[] FIELDS = new String[]{"app_publishers", "business_owner_id", "id", "is_auto_blocking_on", "is_eligible_at_campaign_level", "last_update_time", "last_update_user", "name", "owner_ad_account_id", "web_publishers"};

        @Override
        public PublisherBlockList getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PublisherBlockList parseResponse(String response, String header) throws APIException {
            return PublisherBlockList.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public PublisherBlockList execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PublisherBlockList execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<PublisherBlockList> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PublisherBlockList> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, PublisherBlockList>(){

                public PublisherBlockList apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet setAccountId(Long accountId) {
            this.setParam("account_id", accountId);
            return this;
        }

        public APIRequestGet setAccountId(String accountId) {
            this.setParam("account_id", accountId);
            return this;
        }

        public APIRequestGet setBusinessId(String businessId) {
            this.setParam("business_id", businessId);
            return this;
        }

        public APIRequestGet setDraftId(String draftId) {
            this.setParam("draft_id", draftId);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAppPublishersField() {
            return this.requestAppPublishersField(true);
        }

        public APIRequestGet requestAppPublishersField(boolean value) {
            this.requestField("app_publishers", value);
            return this;
        }

        public APIRequestGet requestBusinessOwnerIdField() {
            return this.requestBusinessOwnerIdField(true);
        }

        public APIRequestGet requestBusinessOwnerIdField(boolean value) {
            this.requestField("business_owner_id", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsAutoBlockingOnField() {
            return this.requestIsAutoBlockingOnField(true);
        }

        public APIRequestGet requestIsAutoBlockingOnField(boolean value) {
            this.requestField("is_auto_blocking_on", value);
            return this;
        }

        public APIRequestGet requestIsEligibleAtCampaignLevelField() {
            return this.requestIsEligibleAtCampaignLevelField(true);
        }

        public APIRequestGet requestIsEligibleAtCampaignLevelField(boolean value) {
            this.requestField("is_eligible_at_campaign_level", value);
            return this;
        }

        public APIRequestGet requestLastUpdateTimeField() {
            return this.requestLastUpdateTimeField(true);
        }

        public APIRequestGet requestLastUpdateTimeField(boolean value) {
            this.requestField("last_update_time", value);
            return this;
        }

        public APIRequestGet requestLastUpdateUserField() {
            return this.requestLastUpdateUserField(true);
        }

        public APIRequestGet requestLastUpdateUserField(boolean value) {
            this.requestField("last_update_user", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestOwnerAdAccountIdField() {
            return this.requestOwnerAdAccountIdField(true);
        }

        public APIRequestGet requestOwnerAdAccountIdField(boolean value) {
            this.requestField("owner_ad_account_id", value);
            return this;
        }

        public APIRequestGet requestWebPublishersField() {
            return this.requestWebPublishersField(true);
        }

        public APIRequestGet requestWebPublishersField(boolean value) {
            this.requestField("web_publishers", value);
            return this;
        }
    }

    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetPagedWebPublishers
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"draft_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetPagedWebPublishers(String nodeId, APIContext context) {
            super(context, nodeId, "/paged_web_publishers", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPagedWebPublishers setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPagedWebPublishers setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPagedWebPublishers setDraftId(String draftId) {
            this.setParam("draft_id", draftId);
            return this;
        }

        public APIRequestGetPagedWebPublishers requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPagedWebPublishers requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPagedWebPublishers requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPagedWebPublishers requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPagedWebPublishers requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPagedWebPublishers requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestCreateAppendPublisherUrl
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"publisher_urls"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateAppendPublisherUrl(String nodeId, APIContext context) {
            super(context, nodeId, "/append_publisher_urls", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateAppendPublisherUrl setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateAppendPublisherUrl setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateAppendPublisherUrl setPublisherUrls(List<String> publisherUrls) {
            this.setParam("publisher_urls", publisherUrls);
            return this;
        }

        public APIRequestCreateAppendPublisherUrl setPublisherUrls(String publisherUrls) {
            this.setParam("publisher_urls", publisherUrls);
            return this;
        }

        public APIRequestCreateAppendPublisherUrl requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateAppendPublisherUrl requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAppendPublisherUrl requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateAppendPublisherUrl requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAppendPublisherUrl requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateAppendPublisherUrl requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

