/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Photo;
import com.facebook.ads.sdk.VideoCopyrightGeoGate;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImageCopyright
extends APINode {
    @SerializedName(value="artist")
    private String mArtist = null;
    @SerializedName(value="copyright_monitoring_status")
    private String mCopyrightMonitoringStatus = null;
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="creator")
    private String mCreator = null;
    @SerializedName(value="custom_id")
    private String mCustomId = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="filename")
    private String mFilename = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="image")
    private Photo mImage = null;
    @SerializedName(value="matches_count")
    private Long mMatchesCount = null;
    @SerializedName(value="original_content_creation_date")
    private String mOriginalContentCreationDate = null;
    @SerializedName(value="ownership_countries")
    private VideoCopyrightGeoGate mOwnershipCountries = null;
    @SerializedName(value="tags")
    private List<String> mTags = null;
    @SerializedName(value="title")
    private String mTitle = null;
    @SerializedName(value="update_time")
    private String mUpdateTime = null;
    protected static Gson gson = null;

    ImageCopyright() {
    }

    public ImageCopyright(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ImageCopyright(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ImageCopyright fetch() throws APIException {
        ImageCopyright newInstance = ImageCopyright.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ImageCopyright fetchById(Long id, APIContext context) throws APIException {
        return ImageCopyright.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ImageCopyright> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ImageCopyright.fetchByIdAsync(id.toString(), context);
    }

    public static ImageCopyright fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ImageCopyright> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ImageCopyright> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ImageCopyright>(context, "", "/", "GET", ImageCopyright.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ImageCopyright>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ImageCopyright>(context, "", "/", "GET", ImageCopyright.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ImageCopyright loadJSON(String json, APIContext context, String header) {
        ImageCopyright imageCopyright = (ImageCopyright)ImageCopyright.getGson().fromJson(json, ImageCopyright.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(imageCopyright.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        imageCopyright.context = context;
        imageCopyright.rawValue = json;
        imageCopyright.header = header;
        return imageCopyright;
    }

    public static APINodeList<ImageCopyright> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ImageCopyright> imageCopyrights = new APINodeList<ImageCopyright>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        imageCopyrights.add(ImageCopyright.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return imageCopyrights;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            imageCopyrights.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        imageCopyrights.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            imageCopyrights.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            imageCopyrights.add(ImageCopyright.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                imageCopyrights.add(ImageCopyright.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            imageCopyrights.add(ImageCopyright.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return imageCopyrights;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        imageCopyrights.add(ImageCopyright.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return imageCopyrights;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        imageCopyrights.add(ImageCopyright.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return imageCopyrights;
                }
                imageCopyrights.clear();
                imageCopyrights.add(ImageCopyright.loadJSON(json, context, header));
                return imageCopyrights;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ImageCopyright.getGson().toJson((Object)this);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldArtist() {
        return this.mArtist;
    }

    public String getFieldCopyrightMonitoringStatus() {
        return this.mCopyrightMonitoringStatus;
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public String getFieldCreator() {
        return this.mCreator;
    }

    public String getFieldCustomId() {
        return this.mCustomId;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldFilename() {
        return this.mFilename;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Photo getFieldImage() {
        if (this.mImage != null) {
            this.mImage.context = this.getContext();
        }
        return this.mImage;
    }

    public Long getFieldMatchesCount() {
        return this.mMatchesCount;
    }

    public String getFieldOriginalContentCreationDate() {
        return this.mOriginalContentCreationDate;
    }

    public VideoCopyrightGeoGate getFieldOwnershipCountries() {
        return this.mOwnershipCountries;
    }

    public List<String> getFieldTags() {
        return this.mTags;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    public String getFieldUpdateTime() {
        return this.mUpdateTime;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ImageCopyright copyFrom(ImageCopyright instance) {
        this.mArtist = instance.mArtist;
        this.mCopyrightMonitoringStatus = instance.mCopyrightMonitoringStatus;
        this.mCreationTime = instance.mCreationTime;
        this.mCreator = instance.mCreator;
        this.mCustomId = instance.mCustomId;
        this.mDescription = instance.mDescription;
        this.mFilename = instance.mFilename;
        this.mId = instance.mId;
        this.mImage = instance.mImage;
        this.mMatchesCount = instance.mMatchesCount;
        this.mOriginalContentCreationDate = instance.mOriginalContentCreationDate;
        this.mOwnershipCountries = instance.mOwnershipCountries;
        this.mTags = instance.mTags;
        this.mTitle = instance.mTitle;
        this.mUpdateTime = instance.mUpdateTime;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ImageCopyright> getParser() {
        return new APIRequest.ResponseParser<ImageCopyright>(){

            @Override
            public APINodeList<ImageCopyright> parseResponse(String response, APIContext context, APIRequest<ImageCopyright> request, String header) throws APIException.MalformedResponseException {
                return ImageCopyright.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumGeoOwnership {
        VALUE_AD("AD"),
        VALUE_AE("AE"),
        VALUE_AF("AF"),
        VALUE_AG("AG"),
        VALUE_AI("AI"),
        VALUE_AL("AL"),
        VALUE_AM("AM"),
        VALUE_AN("AN"),
        VALUE_AO("AO"),
        VALUE_AQ("AQ"),
        VALUE_AR("AR"),
        VALUE_AS("AS"),
        VALUE_AT("AT"),
        VALUE_AU("AU"),
        VALUE_AW("AW"),
        VALUE_AX("AX"),
        VALUE_AZ("AZ"),
        VALUE_BA("BA"),
        VALUE_BB("BB"),
        VALUE_BD("BD"),
        VALUE_BE("BE"),
        VALUE_BF("BF"),
        VALUE_BG("BG"),
        VALUE_BH("BH"),
        VALUE_BI("BI"),
        VALUE_BJ("BJ"),
        VALUE_BL("BL"),
        VALUE_BM("BM"),
        VALUE_BN("BN"),
        VALUE_BO("BO"),
        VALUE_BQ("BQ"),
        VALUE_BR("BR"),
        VALUE_BS("BS"),
        VALUE_BT("BT"),
        VALUE_BV("BV"),
        VALUE_BW("BW"),
        VALUE_BY("BY"),
        VALUE_BZ("BZ"),
        VALUE_CA("CA"),
        VALUE_CC("CC"),
        VALUE_CD("CD"),
        VALUE_CF("CF"),
        VALUE_CG("CG"),
        VALUE_CH("CH"),
        VALUE_CI("CI"),
        VALUE_CK("CK"),
        VALUE_CL("CL"),
        VALUE_CM("CM"),
        VALUE_CN("CN"),
        VALUE_CO("CO"),
        VALUE_CR("CR"),
        VALUE_CU("CU"),
        VALUE_CV("CV"),
        VALUE_CW("CW"),
        VALUE_CX("CX"),
        VALUE_CY("CY"),
        VALUE_CZ("CZ"),
        VALUE_DE("DE"),
        VALUE_DJ("DJ"),
        VALUE_DK("DK"),
        VALUE_DM("DM"),
        VALUE_DO("DO"),
        VALUE_DZ("DZ"),
        VALUE_EC("EC"),
        VALUE_EE("EE"),
        VALUE_EG("EG"),
        VALUE_EH("EH"),
        VALUE_ER("ER"),
        VALUE_ES("ES"),
        VALUE_ET("ET"),
        VALUE_FI("FI"),
        VALUE_FJ("FJ"),
        VALUE_FK("FK"),
        VALUE_FM("FM"),
        VALUE_FO("FO"),
        VALUE_FR("FR"),
        VALUE_GA("GA"),
        VALUE_GB("GB"),
        VALUE_GD("GD"),
        VALUE_GE("GE"),
        VALUE_GF("GF"),
        VALUE_GG("GG"),
        VALUE_GH("GH"),
        VALUE_GI("GI"),
        VALUE_GL("GL"),
        VALUE_GM("GM"),
        VALUE_GN("GN"),
        VALUE_GP("GP"),
        VALUE_GQ("GQ"),
        VALUE_GR("GR"),
        VALUE_GS("GS"),
        VALUE_GT("GT"),
        VALUE_GU("GU"),
        VALUE_GW("GW"),
        VALUE_GY("GY"),
        VALUE_HK("HK"),
        VALUE_HM("HM"),
        VALUE_HN("HN"),
        VALUE_HR("HR"),
        VALUE_HT("HT"),
        VALUE_HU("HU"),
        VALUE_ID("ID"),
        VALUE_IE("IE"),
        VALUE_IL("IL"),
        VALUE_IM("IM"),
        VALUE_IN("IN"),
        VALUE_IO("IO"),
        VALUE_IQ("IQ"),
        VALUE_IR("IR"),
        VALUE_IS("IS"),
        VALUE_IT("IT"),
        VALUE_JE("JE"),
        VALUE_JM("JM"),
        VALUE_JO("JO"),
        VALUE_JP("JP"),
        VALUE_KE("KE"),
        VALUE_KG("KG"),
        VALUE_KH("KH"),
        VALUE_KI("KI"),
        VALUE_KM("KM"),
        VALUE_KN("KN"),
        VALUE_KP("KP"),
        VALUE_KR("KR"),
        VALUE_KW("KW"),
        VALUE_KY("KY"),
        VALUE_KZ("KZ"),
        VALUE_LA("LA"),
        VALUE_LB("LB"),
        VALUE_LC("LC"),
        VALUE_LI("LI"),
        VALUE_LK("LK"),
        VALUE_LR("LR"),
        VALUE_LS("LS"),
        VALUE_LT("LT"),
        VALUE_LU("LU"),
        VALUE_LV("LV"),
        VALUE_LY("LY"),
        VALUE_MA("MA"),
        VALUE_MC("MC"),
        VALUE_MD("MD"),
        VALUE_ME("ME"),
        VALUE_MF("MF"),
        VALUE_MG("MG"),
        VALUE_MH("MH"),
        VALUE_MK("MK"),
        VALUE_ML("ML"),
        VALUE_MM("MM"),
        VALUE_MN("MN"),
        VALUE_MO("MO"),
        VALUE_MP("MP"),
        VALUE_MQ("MQ"),
        VALUE_MR("MR"),
        VALUE_MS("MS"),
        VALUE_MT("MT"),
        VALUE_MU("MU"),
        VALUE_MV("MV"),
        VALUE_MW("MW"),
        VALUE_MX("MX"),
        VALUE_MY("MY"),
        VALUE_MZ("MZ"),
        VALUE_NA("NA"),
        VALUE_NC("NC"),
        VALUE_NE("NE"),
        VALUE_NF("NF"),
        VALUE_NG("NG"),
        VALUE_NI("NI"),
        VALUE_NL("NL"),
        VALUE_NO("NO"),
        VALUE_NP("NP"),
        VALUE_NR("NR"),
        VALUE_NU("NU"),
        VALUE_NZ("NZ"),
        VALUE_OM("OM"),
        VALUE_PA("PA"),
        VALUE_PE("PE"),
        VALUE_PF("PF"),
        VALUE_PG("PG"),
        VALUE_PH("PH"),
        VALUE_PK("PK"),
        VALUE_PL("PL"),
        VALUE_PM("PM"),
        VALUE_PN("PN"),
        VALUE_PR("PR"),
        VALUE_PS("PS"),
        VALUE_PT("PT"),
        VALUE_PW("PW"),
        VALUE_PY("PY"),
        VALUE_QA("QA"),
        VALUE_RE("RE"),
        VALUE_RO("RO"),
        VALUE_RS("RS"),
        VALUE_RU("RU"),
        VALUE_RW("RW"),
        VALUE_SA("SA"),
        VALUE_SB("SB"),
        VALUE_SC("SC"),
        VALUE_SD("SD"),
        VALUE_SE("SE"),
        VALUE_SG("SG"),
        VALUE_SH("SH"),
        VALUE_SI("SI"),
        VALUE_SJ("SJ"),
        VALUE_SK("SK"),
        VALUE_SL("SL"),
        VALUE_SM("SM"),
        VALUE_SN("SN"),
        VALUE_SO("SO"),
        VALUE_SR("SR"),
        VALUE_SS("SS"),
        VALUE_ST("ST"),
        VALUE_SV("SV"),
        VALUE_SX("SX"),
        VALUE_SY("SY"),
        VALUE_SZ("SZ"),
        VALUE_TC("TC"),
        VALUE_TD("TD"),
        VALUE_TF("TF"),
        VALUE_TG("TG"),
        VALUE_TH("TH"),
        VALUE_TJ("TJ"),
        VALUE_TK("TK"),
        VALUE_TL("TL"),
        VALUE_TM("TM"),
        VALUE_TN("TN"),
        VALUE_TO("TO"),
        VALUE_TP("TP"),
        VALUE_TR("TR"),
        VALUE_TT("TT"),
        VALUE_TV("TV"),
        VALUE_TW("TW"),
        VALUE_TZ("TZ"),
        VALUE_UA("UA"),
        VALUE_UG("UG"),
        VALUE_UM("UM"),
        VALUE_US("US"),
        VALUE_UY("UY"),
        VALUE_UZ("UZ"),
        VALUE_VA("VA"),
        VALUE_VC("VC"),
        VALUE_VE("VE"),
        VALUE_VG("VG"),
        VALUE_VI("VI"),
        VALUE_VN("VN"),
        VALUE_VU("VU"),
        VALUE_WF("WF"),
        VALUE_WS("WS"),
        VALUE_XK("XK"),
        VALUE_YE("YE"),
        VALUE_YT("YT"),
        VALUE_ZA("ZA"),
        VALUE_ZM("ZM"),
        VALUE_ZW("ZW");

        private String value;

        private EnumGeoOwnership(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestUpdate
    extends APIRequest<ImageCopyright> {
        ImageCopyright lastResponse = null;
        public static final String[] PARAMS = new String[]{"artist", "creator", "custom_id", "description", "geo_ownership", "original_content_creation_date", "title"};
        public static final String[] FIELDS = new String[0];

        @Override
        public ImageCopyright getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ImageCopyright parseResponse(String response, String header) throws APIException {
            return ImageCopyright.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public ImageCopyright execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ImageCopyright execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<ImageCopyright> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ImageCopyright> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, ImageCopyright>(){

                public ImageCopyright apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setArtist(String artist) {
            this.setParam("artist", artist);
            return this;
        }

        public APIRequestUpdate setCreator(String creator) {
            this.setParam("creator", creator);
            return this;
        }

        public APIRequestUpdate setCustomId(String customId) {
            this.setParam("custom_id", customId);
            return this;
        }

        public APIRequestUpdate setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestUpdate setGeoOwnership(List<EnumGeoOwnership> geoOwnership) {
            this.setParam("geo_ownership", geoOwnership);
            return this;
        }

        public APIRequestUpdate setGeoOwnership(String geoOwnership) {
            this.setParam("geo_ownership", geoOwnership);
            return this;
        }

        public APIRequestUpdate setOriginalContentCreationDate(Long originalContentCreationDate) {
            this.setParam("original_content_creation_date", originalContentCreationDate);
            return this;
        }

        public APIRequestUpdate setOriginalContentCreationDate(String originalContentCreationDate) {
            this.setParam("original_content_creation_date", originalContentCreationDate);
            return this;
        }

        public APIRequestUpdate setTitle(String title) {
            this.setParam("title", title);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGet
    extends APIRequest<ImageCopyright> {
        ImageCopyright lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"artist", "copyright_monitoring_status", "creation_time", "creator", "custom_id", "description", "filename", "id", "image", "matches_count", "original_content_creation_date", "ownership_countries", "tags", "title", "update_time"};

        @Override
        public ImageCopyright getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ImageCopyright parseResponse(String response, String header) throws APIException {
            return ImageCopyright.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public ImageCopyright execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ImageCopyright execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<ImageCopyright> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ImageCopyright> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, ImageCopyright>(){

                public ImageCopyright apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestArtistField() {
            return this.requestArtistField(true);
        }

        public APIRequestGet requestArtistField(boolean value) {
            this.requestField("artist", value);
            return this;
        }

        public APIRequestGet requestCopyrightMonitoringStatusField() {
            return this.requestCopyrightMonitoringStatusField(true);
        }

        public APIRequestGet requestCopyrightMonitoringStatusField(boolean value) {
            this.requestField("copyright_monitoring_status", value);
            return this;
        }

        public APIRequestGet requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGet requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGet requestCreatorField() {
            return this.requestCreatorField(true);
        }

        public APIRequestGet requestCreatorField(boolean value) {
            this.requestField("creator", value);
            return this;
        }

        public APIRequestGet requestCustomIdField() {
            return this.requestCustomIdField(true);
        }

        public APIRequestGet requestCustomIdField(boolean value) {
            this.requestField("custom_id", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestFilenameField() {
            return this.requestFilenameField(true);
        }

        public APIRequestGet requestFilenameField(boolean value) {
            this.requestField("filename", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestImageField() {
            return this.requestImageField(true);
        }

        public APIRequestGet requestImageField(boolean value) {
            this.requestField("image", value);
            return this;
        }

        public APIRequestGet requestMatchesCountField() {
            return this.requestMatchesCountField(true);
        }

        public APIRequestGet requestMatchesCountField(boolean value) {
            this.requestField("matches_count", value);
            return this;
        }

        public APIRequestGet requestOriginalContentCreationDateField() {
            return this.requestOriginalContentCreationDateField(true);
        }

        public APIRequestGet requestOriginalContentCreationDateField(boolean value) {
            this.requestField("original_content_creation_date", value);
            return this;
        }

        public APIRequestGet requestOwnershipCountriesField() {
            return this.requestOwnershipCountriesField(true);
        }

        public APIRequestGet requestOwnershipCountriesField(boolean value) {
            this.requestField("ownership_countries", value);
            return this;
        }

        public APIRequestGet requestTagsField() {
            return this.requestTagsField(true);
        }

        public APIRequestGet requestTagsField(boolean value) {
            this.requestField("tags", value);
            return this;
        }

        public APIRequestGet requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGet requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGet requestUpdateTimeField() {
            return this.requestUpdateTimeField(true);
        }

        public APIRequestGet requestUpdateTimeField(boolean value) {
            this.requestField("update_time", value);
            return this;
        }
    }

    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

