/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Canvas;
import com.facebook.ads.sdk.Photo;
import com.facebook.ads.sdk.User;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CanvasTemplate
extends APINode {
    @SerializedName(value="channels")
    private Map<String, Map<String, String>> mChannels = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="document")
    private Canvas mDocument = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_multi_tab_supportable")
    private Boolean mIsMultiTabSupportable = null;
    @SerializedName(value="is_new")
    private Boolean mIsNew = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="objectives")
    private Map<Object, Object> mObjectives = null;
    @SerializedName(value="owner_id")
    private User mOwnerId = null;
    @SerializedName(value="required_capabilities")
    private List<String> mRequiredCapabilities = null;
    @SerializedName(value="snapshot_photo")
    private Photo mSnapshotPhoto = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="sub_verticals")
    private List<String> mSubVerticals = null;
    @SerializedName(value="verticals")
    private Map<String, String> mVerticals = null;
    protected static Gson gson = null;

    CanvasTemplate() {
    }

    public CanvasTemplate(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public CanvasTemplate(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public CanvasTemplate fetch() throws APIException {
        CanvasTemplate newInstance = CanvasTemplate.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static CanvasTemplate fetchById(Long id, APIContext context) throws APIException {
        return CanvasTemplate.fetchById(id.toString(), context);
    }

    public static ListenableFuture<CanvasTemplate> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return CanvasTemplate.fetchByIdAsync(id.toString(), context);
    }

    public static CanvasTemplate fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<CanvasTemplate> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<CanvasTemplate> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<CanvasTemplate>(context, "", "/", "GET", CanvasTemplate.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<CanvasTemplate>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<CanvasTemplate>(context, "", "/", "GET", CanvasTemplate.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static CanvasTemplate loadJSON(String json, APIContext context, String header) {
        CanvasTemplate canvasTemplate = (CanvasTemplate)CanvasTemplate.getGson().fromJson(json, CanvasTemplate.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(canvasTemplate.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        canvasTemplate.context = context;
        canvasTemplate.rawValue = json;
        canvasTemplate.header = header;
        return canvasTemplate;
    }

    public static APINodeList<CanvasTemplate> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CanvasTemplate> canvasTemplates = new APINodeList<CanvasTemplate>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        canvasTemplates.add(CanvasTemplate.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return canvasTemplates;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            canvasTemplates.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        canvasTemplates.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            canvasTemplates.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            canvasTemplates.add(CanvasTemplate.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                canvasTemplates.add(CanvasTemplate.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            canvasTemplates.add(CanvasTemplate.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return canvasTemplates;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        canvasTemplates.add(CanvasTemplate.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return canvasTemplates;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        canvasTemplates.add(CanvasTemplate.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return canvasTemplates;
                }
                canvasTemplates.clear();
                canvasTemplates.add(CanvasTemplate.loadJSON(json, context, header));
                return canvasTemplates;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CanvasTemplate.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Map<String, Map<String, String>> getFieldChannels() {
        return this.mChannels;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public Canvas getFieldDocument() {
        if (this.mDocument != null) {
            this.mDocument.context = this.getContext();
        }
        return this.mDocument;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsMultiTabSupportable() {
        return this.mIsMultiTabSupportable;
    }

    public Boolean getFieldIsNew() {
        return this.mIsNew;
    }

    public String getFieldName() {
        return this.mName;
    }

    public Map<Object, Object> getFieldObjectives() {
        return this.mObjectives;
    }

    public User getFieldOwnerId() {
        if (this.mOwnerId != null) {
            this.mOwnerId.context = this.getContext();
        }
        return this.mOwnerId;
    }

    public List<String> getFieldRequiredCapabilities() {
        return this.mRequiredCapabilities;
    }

    public Photo getFieldSnapshotPhoto() {
        if (this.mSnapshotPhoto != null) {
            this.mSnapshotPhoto.context = this.getContext();
        }
        return this.mSnapshotPhoto;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public List<String> getFieldSubVerticals() {
        return this.mSubVerticals;
    }

    public Map<String, String> getFieldVerticals() {
        return this.mVerticals;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CanvasTemplate copyFrom(CanvasTemplate instance) {
        this.mChannels = instance.mChannels;
        this.mDescription = instance.mDescription;
        this.mDocument = instance.mDocument;
        this.mId = instance.mId;
        this.mIsMultiTabSupportable = instance.mIsMultiTabSupportable;
        this.mIsNew = instance.mIsNew;
        this.mName = instance.mName;
        this.mObjectives = instance.mObjectives;
        this.mOwnerId = instance.mOwnerId;
        this.mRequiredCapabilities = instance.mRequiredCapabilities;
        this.mSnapshotPhoto = instance.mSnapshotPhoto;
        this.mStatus = instance.mStatus;
        this.mSubVerticals = instance.mSubVerticals;
        this.mVerticals = instance.mVerticals;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CanvasTemplate> getParser() {
        return new APIRequest.ResponseParser<CanvasTemplate>(){

            @Override
            public APINodeList<CanvasTemplate> parseResponse(String response, APIContext context, APIRequest<CanvasTemplate> request, String header) throws APIException.MalformedResponseException {
                return CanvasTemplate.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<CanvasTemplate> {
        CanvasTemplate lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"channels", "description", "document", "id", "is_multi_tab_supportable", "is_new", "name", "objectives", "owner_id", "required_capabilities", "snapshot_photo", "status", "sub_verticals", "verticals"};

        @Override
        public CanvasTemplate getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CanvasTemplate parseResponse(String response, String header) throws APIException {
            return CanvasTemplate.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public CanvasTemplate execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CanvasTemplate execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<CanvasTemplate> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CanvasTemplate> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, CanvasTemplate>(){

                public CanvasTemplate apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestChannelsField() {
            return this.requestChannelsField(true);
        }

        public APIRequestGet requestChannelsField(boolean value) {
            this.requestField("channels", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestDocumentField() {
            return this.requestDocumentField(true);
        }

        public APIRequestGet requestDocumentField(boolean value) {
            this.requestField("document", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsMultiTabSupportableField() {
            return this.requestIsMultiTabSupportableField(true);
        }

        public APIRequestGet requestIsMultiTabSupportableField(boolean value) {
            this.requestField("is_multi_tab_supportable", value);
            return this;
        }

        public APIRequestGet requestIsNewField() {
            return this.requestIsNewField(true);
        }

        public APIRequestGet requestIsNewField(boolean value) {
            this.requestField("is_new", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestObjectivesField() {
            return this.requestObjectivesField(true);
        }

        public APIRequestGet requestObjectivesField(boolean value) {
            this.requestField("objectives", value);
            return this;
        }

        public APIRequestGet requestOwnerIdField() {
            return this.requestOwnerIdField(true);
        }

        public APIRequestGet requestOwnerIdField(boolean value) {
            this.requestField("owner_id", value);
            return this;
        }

        public APIRequestGet requestRequiredCapabilitiesField() {
            return this.requestRequiredCapabilitiesField(true);
        }

        public APIRequestGet requestRequiredCapabilitiesField(boolean value) {
            this.requestField("required_capabilities", value);
            return this;
        }

        public APIRequestGet requestSnapshotPhotoField() {
            return this.requestSnapshotPhotoField(true);
        }

        public APIRequestGet requestSnapshotPhotoField(boolean value) {
            this.requestField("snapshot_photo", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestSubVerticalsField() {
            return this.requestSubVerticalsField(true);
        }

        public APIRequestGet requestSubVerticalsField(boolean value) {
            this.requestField("sub_verticals", value);
            return this;
        }

        public APIRequestGet requestVerticalsField() {
            return this.requestVerticalsField(true);
        }

        public APIRequestGet requestVerticalsField(boolean value) {
            this.requestField("verticals", value);
            return this;
        }
    }
}

