/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Business;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BusinessOwnedObjectOnBehalfOfRequest
extends APINode {
    @SerializedName(value="business_owned_object")
    private String mBusinessOwnedObject = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="receiving_business")
    private Business mReceivingBusiness = null;
    @SerializedName(value="requesting_business")
    private Business mRequestingBusiness = null;
    @SerializedName(value="status")
    private String mStatus = null;
    protected static Gson gson = null;

    BusinessOwnedObjectOnBehalfOfRequest() {
    }

    public BusinessOwnedObjectOnBehalfOfRequest(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public BusinessOwnedObjectOnBehalfOfRequest(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public BusinessOwnedObjectOnBehalfOfRequest fetch() throws APIException {
        BusinessOwnedObjectOnBehalfOfRequest newInstance = BusinessOwnedObjectOnBehalfOfRequest.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static BusinessOwnedObjectOnBehalfOfRequest fetchById(Long id, APIContext context) throws APIException {
        return BusinessOwnedObjectOnBehalfOfRequest.fetchById(id.toString(), context);
    }

    public static ListenableFuture<BusinessOwnedObjectOnBehalfOfRequest> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return BusinessOwnedObjectOnBehalfOfRequest.fetchByIdAsync(id.toString(), context);
    }

    public static BusinessOwnedObjectOnBehalfOfRequest fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<BusinessOwnedObjectOnBehalfOfRequest> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<BusinessOwnedObjectOnBehalfOfRequest> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<BusinessOwnedObjectOnBehalfOfRequest>(context, "", "/", "GET", BusinessOwnedObjectOnBehalfOfRequest.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<BusinessOwnedObjectOnBehalfOfRequest>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<BusinessOwnedObjectOnBehalfOfRequest>(context, "", "/", "GET", BusinessOwnedObjectOnBehalfOfRequest.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static BusinessOwnedObjectOnBehalfOfRequest loadJSON(String json, APIContext context, String header) {
        BusinessOwnedObjectOnBehalfOfRequest businessOwnedObjectOnBehalfOfRequest = (BusinessOwnedObjectOnBehalfOfRequest)BusinessOwnedObjectOnBehalfOfRequest.getGson().fromJson(json, BusinessOwnedObjectOnBehalfOfRequest.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(businessOwnedObjectOnBehalfOfRequest.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        businessOwnedObjectOnBehalfOfRequest.context = context;
        businessOwnedObjectOnBehalfOfRequest.rawValue = json;
        businessOwnedObjectOnBehalfOfRequest.header = header;
        return businessOwnedObjectOnBehalfOfRequest;
    }

    public static APINodeList<BusinessOwnedObjectOnBehalfOfRequest> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<BusinessOwnedObjectOnBehalfOfRequest> businessOwnedObjectOnBehalfOfRequests = new APINodeList<BusinessOwnedObjectOnBehalfOfRequest>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        businessOwnedObjectOnBehalfOfRequests.add(BusinessOwnedObjectOnBehalfOfRequest.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return businessOwnedObjectOnBehalfOfRequests;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            businessOwnedObjectOnBehalfOfRequests.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        businessOwnedObjectOnBehalfOfRequests.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            businessOwnedObjectOnBehalfOfRequests.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            businessOwnedObjectOnBehalfOfRequests.add(BusinessOwnedObjectOnBehalfOfRequest.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                businessOwnedObjectOnBehalfOfRequests.add(BusinessOwnedObjectOnBehalfOfRequest.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            businessOwnedObjectOnBehalfOfRequests.add(BusinessOwnedObjectOnBehalfOfRequest.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return businessOwnedObjectOnBehalfOfRequests;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        businessOwnedObjectOnBehalfOfRequests.add(BusinessOwnedObjectOnBehalfOfRequest.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return businessOwnedObjectOnBehalfOfRequests;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        businessOwnedObjectOnBehalfOfRequests.add(BusinessOwnedObjectOnBehalfOfRequest.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return businessOwnedObjectOnBehalfOfRequests;
                }
                businessOwnedObjectOnBehalfOfRequests.clear();
                businessOwnedObjectOnBehalfOfRequests.add(BusinessOwnedObjectOnBehalfOfRequest.loadJSON(json, context, header));
                return businessOwnedObjectOnBehalfOfRequests;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return BusinessOwnedObjectOnBehalfOfRequest.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldBusinessOwnedObject() {
        return this.mBusinessOwnedObject;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Business getFieldReceivingBusiness() {
        if (this.mReceivingBusiness != null) {
            this.mReceivingBusiness.context = this.getContext();
        }
        return this.mReceivingBusiness;
    }

    public Business getFieldRequestingBusiness() {
        if (this.mRequestingBusiness != null) {
            this.mRequestingBusiness.context = this.getContext();
        }
        return this.mRequestingBusiness;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public BusinessOwnedObjectOnBehalfOfRequest copyFrom(BusinessOwnedObjectOnBehalfOfRequest instance) {
        this.mBusinessOwnedObject = instance.mBusinessOwnedObject;
        this.mId = instance.mId;
        this.mReceivingBusiness = instance.mReceivingBusiness;
        this.mRequestingBusiness = instance.mRequestingBusiness;
        this.mStatus = instance.mStatus;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<BusinessOwnedObjectOnBehalfOfRequest> getParser() {
        return new APIRequest.ResponseParser<BusinessOwnedObjectOnBehalfOfRequest>(){

            @Override
            public APINodeList<BusinessOwnedObjectOnBehalfOfRequest> parseResponse(String response, APIContext context, APIRequest<BusinessOwnedObjectOnBehalfOfRequest> request, String header) throws APIException.MalformedResponseException {
                return BusinessOwnedObjectOnBehalfOfRequest.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumStatus {
        VALUE_APPROVE("APPROVE"),
        VALUE_DECLINE("DECLINE"),
        VALUE_EXPIRED("EXPIRED"),
        VALUE_IN_PROGRESS("IN_PROGRESS"),
        VALUE_PENDING("PENDING");

        private String value;

        private EnumStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestGet
    extends APIRequest<BusinessOwnedObjectOnBehalfOfRequest> {
        BusinessOwnedObjectOnBehalfOfRequest lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"business_owned_object", "id", "receiving_business", "requesting_business", "status"};

        @Override
        public BusinessOwnedObjectOnBehalfOfRequest getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public BusinessOwnedObjectOnBehalfOfRequest parseResponse(String response, String header) throws APIException {
            return BusinessOwnedObjectOnBehalfOfRequest.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public BusinessOwnedObjectOnBehalfOfRequest execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public BusinessOwnedObjectOnBehalfOfRequest execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<BusinessOwnedObjectOnBehalfOfRequest> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<BusinessOwnedObjectOnBehalfOfRequest> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, BusinessOwnedObjectOnBehalfOfRequest>(){

                public BusinessOwnedObjectOnBehalfOfRequest apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBusinessOwnedObjectField() {
            return this.requestBusinessOwnedObjectField(true);
        }

        public APIRequestGet requestBusinessOwnedObjectField(boolean value) {
            this.requestField("business_owned_object", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestReceivingBusinessField() {
            return this.requestReceivingBusinessField(true);
        }

        public APIRequestGet requestReceivingBusinessField(boolean value) {
            this.requestField("receiving_business", value);
            return this;
        }

        public APIRequestGet requestRequestingBusinessField() {
            return this.requestRequestingBusinessField(true);
        }

        public APIRequestGet requestRequestingBusinessField(boolean value) {
            this.requestField("requesting_business", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }
    }
}

