/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Page;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdPlacePageSet
extends APINode {
    @SerializedName(value="account_id")
    private String mAccountId = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="location_types")
    private List<String> mLocationTypes = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="pages_count")
    private Long mPagesCount = null;
    @SerializedName(value="parent_page")
    private Page mParentPage = null;
    protected static Gson gson = null;

    AdPlacePageSet() {
    }

    public AdPlacePageSet(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdPlacePageSet(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdPlacePageSet fetch() throws APIException {
        AdPlacePageSet newInstance = AdPlacePageSet.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdPlacePageSet fetchById(Long id, APIContext context) throws APIException {
        return AdPlacePageSet.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdPlacePageSet> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdPlacePageSet.fetchByIdAsync(id.toString(), context);
    }

    public static AdPlacePageSet fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdPlacePageSet> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdPlacePageSet> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdPlacePageSet>(context, "", "/", "GET", AdPlacePageSet.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdPlacePageSet>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdPlacePageSet>(context, "", "/", "GET", AdPlacePageSet.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdPlacePageSet loadJSON(String json, APIContext context, String header) {
        AdPlacePageSet adPlacePageSet = (AdPlacePageSet)AdPlacePageSet.getGson().fromJson(json, AdPlacePageSet.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adPlacePageSet.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adPlacePageSet.context = context;
        adPlacePageSet.rawValue = json;
        adPlacePageSet.header = header;
        return adPlacePageSet;
    }

    public static APINodeList<AdPlacePageSet> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdPlacePageSet> adPlacePageSets = new APINodeList<AdPlacePageSet>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adPlacePageSets.add(AdPlacePageSet.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adPlacePageSets;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adPlacePageSets.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adPlacePageSets.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adPlacePageSets.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adPlacePageSets.add(AdPlacePageSet.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adPlacePageSets.add(AdPlacePageSet.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adPlacePageSets.add(AdPlacePageSet.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adPlacePageSets;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adPlacePageSets.add(AdPlacePageSet.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adPlacePageSets;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adPlacePageSets.add(AdPlacePageSet.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adPlacePageSets;
                }
                adPlacePageSets.clear();
                adPlacePageSets.add(AdPlacePageSet.loadJSON(json, context, header));
                return adPlacePageSets;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdPlacePageSet.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAccountId() {
        return this.mAccountId;
    }

    public String getFieldId() {
        return this.mId;
    }

    public List<String> getFieldLocationTypes() {
        return this.mLocationTypes;
    }

    public String getFieldName() {
        return this.mName;
    }

    public Long getFieldPagesCount() {
        return this.mPagesCount;
    }

    public Page getFieldParentPage() {
        if (this.mParentPage != null) {
            this.mParentPage.context = this.getContext();
        }
        return this.mParentPage;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdPlacePageSet copyFrom(AdPlacePageSet instance) {
        this.mAccountId = instance.mAccountId;
        this.mId = instance.mId;
        this.mLocationTypes = instance.mLocationTypes;
        this.mName = instance.mName;
        this.mPagesCount = instance.mPagesCount;
        this.mParentPage = instance.mParentPage;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdPlacePageSet> getParser() {
        return new APIRequest.ResponseParser<AdPlacePageSet>(){

            @Override
            public APINodeList<AdPlacePageSet> parseResponse(String response, APIContext context, APIRequest<AdPlacePageSet> request, String header) throws APIException.MalformedResponseException {
                return AdPlacePageSet.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumTargetedAreaType {
        VALUE_CUSTOM_RADIUS("CUSTOM_RADIUS"),
        VALUE_MARKETING_AREA("MARKETING_AREA"),
        VALUE_NONE("NONE");

        private String value;

        private EnumTargetedAreaType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumLocationTypes {
        VALUE_HOME("home"),
        VALUE_RECENT("recent");

        private String value;

        private EnumLocationTypes(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestGet
    extends APIRequest<AdPlacePageSet> {
        AdPlacePageSet lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_id", "id", "location_types", "name", "pages_count", "parent_page"};

        @Override
        public AdPlacePageSet getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdPlacePageSet parseResponse(String response, String header) throws APIException {
            return AdPlacePageSet.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdPlacePageSet execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdPlacePageSet execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdPlacePageSet> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdPlacePageSet> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdPlacePageSet>(){

                public AdPlacePageSet apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGet requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestLocationTypesField() {
            return this.requestLocationTypesField(true);
        }

        public APIRequestGet requestLocationTypesField(boolean value) {
            this.requestField("location_types", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestPagesCountField() {
            return this.requestPagesCountField(true);
        }

        public APIRequestGet requestPagesCountField(boolean value) {
            this.requestField("pages_count", value);
            return this;
        }

        public APIRequestGet requestParentPageField() {
            return this.requestParentPageField(true);
        }

        public APIRequestGet requestParentPageField(boolean value) {
            this.requestField("parent_page", value);
            return this;
        }
    }
}

