/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdCreativeTemplateURLSpec;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

public class AdCustomizationRuleSpec
extends APINode {
    @SerializedName(value="caption")
    private String mCaption = null;
    @SerializedName(value="customization_spec")
    private Object mCustomizationSpec = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="image_hash")
    private String mImageHash = null;
    @SerializedName(value="link")
    private String mLink = null;
    @SerializedName(value="message")
    private String mMessage = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="priority")
    private Long mPriority = null;
    @SerializedName(value="template_url_spec")
    private AdCreativeTemplateURLSpec mTemplateUrlSpec = null;
    @SerializedName(value="video_id")
    private Long mVideoId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdCustomizationRuleSpec loadJSON(String json, APIContext context, String header) {
        AdCustomizationRuleSpec adCustomizationRuleSpec = (AdCustomizationRuleSpec)AdCustomizationRuleSpec.getGson().fromJson(json, AdCustomizationRuleSpec.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCustomizationRuleSpec.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCustomizationRuleSpec.context = context;
        adCustomizationRuleSpec.rawValue = json;
        adCustomizationRuleSpec.header = header;
        return adCustomizationRuleSpec;
    }

    public static APINodeList<AdCustomizationRuleSpec> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdCustomizationRuleSpec> adCustomizationRuleSpecs = new APINodeList<AdCustomizationRuleSpec>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCustomizationRuleSpecs.add(AdCustomizationRuleSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adCustomizationRuleSpecs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adCustomizationRuleSpecs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adCustomizationRuleSpecs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adCustomizationRuleSpecs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCustomizationRuleSpecs.add(AdCustomizationRuleSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCustomizationRuleSpecs.add(AdCustomizationRuleSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCustomizationRuleSpecs.add(AdCustomizationRuleSpec.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adCustomizationRuleSpecs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCustomizationRuleSpecs.add(AdCustomizationRuleSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adCustomizationRuleSpecs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCustomizationRuleSpecs.add(AdCustomizationRuleSpec.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCustomizationRuleSpecs;
                }
                adCustomizationRuleSpecs.clear();
                adCustomizationRuleSpecs.add(AdCustomizationRuleSpec.loadJSON(json, context, header));
                return adCustomizationRuleSpecs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCustomizationRuleSpec.getGson().toJson((Object)this);
    }

    public String getFieldCaption() {
        return this.mCaption;
    }

    public AdCustomizationRuleSpec setFieldCaption(String value) {
        this.mCaption = value;
        return this;
    }

    public Object getFieldCustomizationSpec() {
        return this.mCustomizationSpec;
    }

    public AdCustomizationRuleSpec setFieldCustomizationSpec(Object value) {
        this.mCustomizationSpec = value;
        return this;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public AdCustomizationRuleSpec setFieldDescription(String value) {
        this.mDescription = value;
        return this;
    }

    public String getFieldImageHash() {
        return this.mImageHash;
    }

    public AdCustomizationRuleSpec setFieldImageHash(String value) {
        this.mImageHash = value;
        return this;
    }

    public String getFieldLink() {
        return this.mLink;
    }

    public AdCustomizationRuleSpec setFieldLink(String value) {
        this.mLink = value;
        return this;
    }

    public String getFieldMessage() {
        return this.mMessage;
    }

    public AdCustomizationRuleSpec setFieldMessage(String value) {
        this.mMessage = value;
        return this;
    }

    public String getFieldName() {
        return this.mName;
    }

    public AdCustomizationRuleSpec setFieldName(String value) {
        this.mName = value;
        return this;
    }

    public Long getFieldPriority() {
        return this.mPriority;
    }

    public AdCustomizationRuleSpec setFieldPriority(Long value) {
        this.mPriority = value;
        return this;
    }

    public AdCreativeTemplateURLSpec getFieldTemplateUrlSpec() {
        return this.mTemplateUrlSpec;
    }

    public AdCustomizationRuleSpec setFieldTemplateUrlSpec(AdCreativeTemplateURLSpec value) {
        this.mTemplateUrlSpec = value;
        return this;
    }

    public AdCustomizationRuleSpec setFieldTemplateUrlSpec(String value) {
        Type type = new TypeToken<AdCreativeTemplateURLSpec>(){}.getType();
        this.mTemplateUrlSpec = (AdCreativeTemplateURLSpec)AdCreativeTemplateURLSpec.getGson().fromJson(value, type);
        return this;
    }

    public Long getFieldVideoId() {
        return this.mVideoId;
    }

    public AdCustomizationRuleSpec setFieldVideoId(Long value) {
        this.mVideoId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCustomizationRuleSpec copyFrom(AdCustomizationRuleSpec instance) {
        this.mCaption = instance.mCaption;
        this.mCustomizationSpec = instance.mCustomizationSpec;
        this.mDescription = instance.mDescription;
        this.mImageHash = instance.mImageHash;
        this.mLink = instance.mLink;
        this.mMessage = instance.mMessage;
        this.mName = instance.mName;
        this.mPriority = instance.mPriority;
        this.mTemplateUrlSpec = instance.mTemplateUrlSpec;
        this.mVideoId = instance.mVideoId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCustomizationRuleSpec> getParser() {
        return new APIRequest.ResponseParser<AdCustomizationRuleSpec>(){

            @Override
            public APINodeList<AdCustomizationRuleSpec> parseResponse(String response, APIContext context, APIRequest<AdCustomizationRuleSpec> request, String header) throws APIException.MalformedResponseException {
                return AdCustomizationRuleSpec.parseResponse(response, context, request, header);
            }
        };
    }
}

