/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import androidx.activity.result.ActivityResultLauncher;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.Fragment;
import com.facebook.AccessToken;
import com.facebook.AccessTokenSource;
import com.facebook.AuthenticationToken;
import com.facebook.FacebookException;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookSdk;
import com.facebook.FacebookServiceException;
import com.facebook.internal.ServerProtocol;
import com.facebook.internal.Utility;
import com.facebook.login.CustomTabLoginMethodHandler;
import com.facebook.login.LoginClient;
import com.facebook.login.LoginFragment;
import com.facebook.login.LoginMethodHandler;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b'\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0010\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J\u001a\u0010\u0015\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J0\u0010\u001a\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u00112\b\u0010\u001d\u001a\u0004\u0018\u00010\u0011H\u0014J\u0018\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0019H\u0002J\"\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0018\u0010&\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010'\u001a\u00020$2\u0006\u0010\u0016\u001a\u00020\u0017H&J\u001a\u0010(\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u00192\u0006\u0010#\u001a\u00020$H\u0014R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006)"}, d2={"Lcom/facebook/login/NativeAppLoginMethodHandler;", "Lcom/facebook/login/LoginMethodHandler;", "loginClient", "Lcom/facebook/login/LoginClient;", "(Lcom/facebook/login/LoginClient;)V", "source", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "tokenSource", "Lcom/facebook/AccessTokenSource;", "getTokenSource", "()Lcom/facebook/AccessTokenSource;", "completeLogin", "", "outcome", "Lcom/facebook/login/LoginClient$Result;", "getError", "", "extras", "Landroid/os/Bundle;", "getErrorMessage", "handleResultCancel", "request", "Lcom/facebook/login/LoginClient$Request;", "data", "Landroid/content/Intent;", "handleResultError", "error", "errorMessage", "errorCode", "handleResultOk", "isCallable", "", "intent", "onActivityResult", "requestCode", "", "resultCode", "processSuccessResponse", "tryAuthorize", "tryIntent", "facebook-common_release"})
@VisibleForTesting(otherwise=3)
public abstract class NativeAppLoginMethodHandler
extends LoginMethodHandler {
    @NotNull
    private final AccessTokenSource tokenSource;

    public NativeAppLoginMethodHandler(@NotNull LoginClient loginClient) {
        Intrinsics.checkNotNullParameter((Object)loginClient, (String)"loginClient");
        super(loginClient);
        this.tokenSource = AccessTokenSource.FACEBOOK_APPLICATION_WEB;
    }

    public NativeAppLoginMethodHandler(@NotNull Parcel source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        super(source);
        this.tokenSource = AccessTokenSource.FACEBOOK_APPLICATION_WEB;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void processSuccessResponse(LoginClient.Request request, Bundle extras) {
        if (extras.containsKey("code")) {
            if (!Utility.isNullOrEmpty((String)extras.getString("code"))) {
                FacebookSdk.INSTANCE.getExecutor().execute(() -> NativeAppLoginMethodHandler.processSuccessResponse$lambda-0(this, request, extras));
                return;
            }
        }
        this.handleResultOk(request, extras);
    }

    @Override
    public abstract int tryAuthorize(@NotNull LoginClient.Request var1);

    @NotNull
    public AccessTokenSource getTokenSource() {
        return this.tokenSource;
    }

    @Override
    public boolean onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        LoginClient.Request request = this.getLoginClient().getPendingRequest();
        if (data == null) {
            this.completeLogin(LoginClient.Result.Companion.createCancelResult(request, "Operation canceled"));
        } else if (resultCode == 0) {
            this.handleResultCancel(request, data);
        } else if (resultCode != -1) {
            this.completeLogin(LoginClient.Result.Companion.createErrorResult$default(LoginClient.Result.Companion, request, "Unexpected resultCode from authorization.", null, null, 8, null));
        } else {
            Bundle extras = data.getExtras();
            if (extras == null) {
                this.completeLogin(LoginClient.Result.Companion.createErrorResult$default(LoginClient.Result.Companion, request, "Unexpected null from returned authorization data.", null, null, 8, null));
                return true;
            }
            String error = this.getError(extras);
            Object object = extras.get("error_code");
            String errorCode = object == null ? null : object.toString();
            String errorMessage = this.getErrorMessage(extras);
            String e2e = extras.getString("e2e");
            if (!Utility.isNullOrEmpty((String)e2e)) {
                this.logWebLoginCompleted(e2e);
            }
            if (error == null && errorCode == null && errorMessage == null && request != null) {
                this.processSuccessResponse(request, extras);
            } else {
                this.handleResultError(request, error, errorMessage, errorCode);
            }
        }
        return true;
    }

    private final void completeLogin(LoginClient.Result outcome) {
        if (outcome != null) {
            this.getLoginClient().completeAndValidate(outcome);
        } else {
            this.getLoginClient().tryNextHandler();
        }
    }

    protected void handleResultError(@Nullable LoginClient.Request request, @Nullable String error, @Nullable String errorMessage, @Nullable String errorCode) {
        if (error != null && Intrinsics.areEqual((Object)error, (Object)"logged_out")) {
            CustomTabLoginMethodHandler.calledThroughLoggedOutAppSwitch = true;
            this.completeLogin(null);
        } else if (CollectionsKt.contains((Iterable)ServerProtocol.INSTANCE.getErrorsProxyAuthDisabled(), (Object)error)) {
            this.completeLogin(null);
        } else if (CollectionsKt.contains((Iterable)ServerProtocol.INSTANCE.getErrorsUserCanceled(), (Object)error)) {
            this.completeLogin(LoginClient.Result.Companion.createCancelResult(request, null));
        } else {
            this.completeLogin(LoginClient.Result.Companion.createErrorResult(request, error, errorMessage, errorCode));
        }
    }

    protected void handleResultOk(@NotNull LoginClient.Request request, @NotNull Bundle extras) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
        try {
            AccessToken token = LoginMethodHandler.Companion.createAccessTokenFromWebBundle((Collection<String>)request.getPermissions(), extras, this.getTokenSource(), request.getApplicationId());
            AuthenticationToken authenticationToken = LoginMethodHandler.Companion.createAuthenticationTokenFromWebBundle(extras, request.getNonce());
            this.completeLogin(LoginClient.Result.Companion.createCompositeTokenResult(request, token, authenticationToken));
        }
        catch (FacebookException ex) {
            this.completeLogin(LoginClient.Result.Companion.createErrorResult$default(LoginClient.Result.Companion, request, null, ex.getMessage(), null, 8, null));
        }
    }

    protected void handleResultCancel(@Nullable LoginClient.Request request, @NotNull Intent data) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Bundle extras = data.getExtras();
        String error = this.getError(extras);
        Bundle bundle = extras;
        String errorCode = bundle == null ? null : ((object = bundle.get("error_code")) == null ? null : object.toString());
        if (Intrinsics.areEqual((Object)ServerProtocol.INSTANCE.getErrorConnectionFailure(), errorCode)) {
            String errorMessage = this.getErrorMessage(extras);
            this.completeLogin(LoginClient.Result.Companion.createErrorResult(request, error, errorMessage, errorCode));
            return;
        }
        this.completeLogin(LoginClient.Result.Companion.createCancelResult(request, error));
    }

    @Nullable
    protected String getError(@Nullable Bundle extras) {
        String string2;
        Bundle bundle = extras;
        String string3 = string2 = bundle == null ? null : bundle.getString("error");
        return string2 == null ? ((bundle = extras) == null ? null : bundle.getString("error_type")) : string2;
    }

    @Nullable
    protected String getErrorMessage(@Nullable Bundle extras) {
        String string2;
        Bundle bundle = extras;
        String string3 = string2 = bundle == null ? null : bundle.getString("error_message");
        return string2 == null ? ((bundle = extras) == null ? null : bundle.getString("error_description")) : string2;
    }

    protected boolean tryIntent(@Nullable Intent intent, int requestCode) {
        Unit unit;
        if (intent == null || !this.isCallable(intent)) {
            return false;
        }
        Fragment fragment = this.getLoginClient().getFragment();
        LoginFragment loginFragment = fragment instanceof LoginFragment ? (LoginFragment)fragment : null;
        LoginFragment loginFragment2 = loginFragment;
        if (loginFragment2 == null) {
            unit = null;
        } else {
            ActivityResultLauncher<Intent> activityResultLauncher = loginFragment2.getLauncher();
            if (activityResultLauncher == null) {
                unit = null;
            } else {
                activityResultLauncher.launch((Object)intent);
                unit = fragment = Unit.INSTANCE;
            }
        }
        return fragment != null;
    }

    private final boolean isCallable(Intent intent) {
        Collection collection = FacebookSdk.INSTANCE.getApplicationContext().getPackageManager().queryIntentActivities(intent, 65536);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"FacebookSdk.getApplicationContext()\n            .packageManager\n            .queryIntentActivities(intent, PackageManager.MATCH_DEFAULT_ONLY)");
        List list = collection;
        collection = list;
        boolean bl = false;
        return !collection.isEmpty();
    }

    private static final void processSuccessResponse$lambda-0(NativeAppLoginMethodHandler this$0, LoginClient.Request $request, Bundle $extras) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        Intrinsics.checkNotNullParameter((Object)$extras, (String)"$extras");
        try {
            Bundle processedExtras = this$0.processCodeExchange($request, $extras);
            this$0.handleResultOk($request, processedExtras);
        }
        catch (FacebookServiceException ex) {
            FacebookRequestError requestError = ex.getRequestError();
            this$0.handleResultError($request, requestError.getErrorType(), requestError.getErrorMessage(), String.valueOf(requestError.getErrorCode()));
        }
        catch (FacebookException ex) {
            this$0.handleResultError($request, null, ex.getMessage(), null);
        }
    }
}

