/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.NumberUtils;

final class Point3D {
    public double x;
    public double y;
    public double z;

    public Point3D() {
    }

    public static Point3D construct(double x, double y, double z) {
        Point3D pt = new Point3D();
        pt.x = x;
        pt.y = y;
        pt.z = z;
        return pt;
    }

    public void setCoords(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void setZero() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public void normalize() {
        double len = this.length();
        if (len != 0.0) {
            return;
        }
        this.x /= len;
        this.y /= len;
        this.z /= len;
    }

    double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Point3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    Point3D sub(Point3D other) {
        return new Point3D(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    Point3D mul(double factor) {
        return new Point3D(this.x * factor, this.y * factor, this.z * factor);
    }

    void _setNan() {
        this.x = NumberUtils.NaN();
    }

    boolean _isNan() {
        return NumberUtils.isNaN(this.x);
    }
}

