/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiVertexGeometry;
import com.esri.core.geometry.Operator;
import com.esri.core.geometry.OperatorFactoryLocal;
import com.esri.core.geometry.OperatorSimplify;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.SpatialReferenceImpl;
import com.esri.core.geometry.TopologicalOperations;
import java.util.ArrayList;

class OperatorUnionCursor
extends GeometryCursor {
    private GeometryCursor m_inputGeoms;
    private ProgressTracker m_progress_tracker;
    private SpatialReferenceImpl m_spatial_reference;
    private int m_index = -1;
    private boolean m_b_done = false;
    boolean bLocalDone = false;
    int dimension = -1;
    boolean bFinished = false;
    int totalToUnion = 0;
    int totalVertexCount = 0;
    int binVertexThreshold = 10000;
    boolean dissolved_something = false;
    ArrayList<GeomPair> batchToUnion = new ArrayList(0);
    ArrayList<ArrayList<GeomPair>> unionBins = new ArrayList(0);
    AttributeStreamOfInt32 binSizes = new AttributeStreamOfInt32(0);

    OperatorUnionCursor(GeometryCursor inputGeoms1, SpatialReference sr, ProgressTracker progress_tracker) {
        this.m_inputGeoms = inputGeoms1;
        this.m_spatial_reference = (SpatialReferenceImpl)sr;
        this.m_progress_tracker = progress_tracker;
        this.startDissolve();
    }

    @Override
    public Geometry next() {
        if (this.m_b_done) {
            return null;
        }
        this.m_b_done = true;
        return this.dissolve_();
    }

    @Override
    public int getGeometryID() {
        return this.m_index;
    }

    private void step() {
        block25: {
            boolean bCanGo;
            if (!this.bFinished) {
                Geometry geom = this.m_inputGeoms.next();
                if (this.m_progress_tracker != null && !this.m_progress_tracker.progress(-1, -1)) {
                    throw new RuntimeException("user_canceled");
                }
                if (geom != null) {
                    int resize;
                    if (geom.getDimension() > this.dimension) {
                        int sz;
                        GeomPair pair = new GeomPair();
                        pair.init();
                        pair.geom = geom;
                        pair.vertex_count = sz = OperatorUnionCursor.getVertexCount_(geom);
                        int level = OperatorUnionCursor.getLevel_(sz);
                        this.unionBins.clear();
                        resize = Math.max(16, level + 1);
                        for (int i = 0; i < resize; ++i) {
                            this.unionBins.add(null);
                        }
                        this.binSizes.resize(resize, 0.0);
                        this.unionBins.set(level, new ArrayList(0));
                        this.unionBins.get(level).add(pair);
                        this.binSizes.set(level, sz);
                        this.totalToUnion = 1;
                        this.totalVertexCount = sz;
                        this.dimension = geom.getDimension();
                    } else if (!geom.isEmpty() && geom.getDimension() == this.dimension) {
                        int sz;
                        GeomPair pair = new GeomPair();
                        pair.init();
                        pair.geom = geom;
                        pair.vertex_count = sz = OperatorUnionCursor.getVertexCount_(geom);
                        int level = OperatorUnionCursor.getLevel_(sz);
                        resize = Math.max(this.unionBins.size(), level + 1);
                        if (resize > this.unionBins.size()) {
                            int grow = resize - this.unionBins.size();
                            for (int i = 0; i < grow; ++i) {
                                this.unionBins.add(null);
                            }
                        }
                        this.binSizes.resize(resize, 0.0);
                        if (this.unionBins.get(level) == null) {
                            this.unionBins.set(level, new ArrayList(0));
                        }
                        this.unionBins.get(level).add(pair);
                        this.binSizes.write(level, this.binSizes.read(level) + sz);
                        ++this.totalToUnion;
                        this.totalVertexCount += sz;
                    }
                } else {
                    this.bFinished = true;
                }
            }
            while (true) {
                int sz;
                int i;
                int n;
                if (!this.bFinished) {
                    int imax = -1;
                    int maxSz = 0;
                    n = this.unionBins.size();
                    for (i = 0; i < n; ++i) {
                        if (this.unionBins.get(i) == null || this.unionBins.get(i).size() <= 1 || this.binSizes.read(i) <= this.binVertexThreshold || maxSz >= this.binSizes.read(i)) continue;
                        maxSz = this.binSizes.read(i);
                        imax = i;
                    }
                    if (maxSz > 0) {
                        while (this.unionBins.get(imax).size() > 0) {
                            ArrayList<GeomPair> bin = this.unionBins.get(imax);
                            this.batchToUnion.add(bin.get(bin.size() - 1));
                            bin.remove(bin.size() - 1);
                            this.totalVertexCount -= this.batchToUnion.get((int)(this.batchToUnion.size() - 1)).vertex_count;
                            this.binSizes.write(imax, this.binSizes.read(imax) - this.batchToUnion.get((int)(this.batchToUnion.size() - 1)).vertex_count);
                        }
                    }
                } else if (this.totalToUnion > 1) {
                    int level = 0;
                    int vertexCount = 0;
                    n = this.unionBins.size();
                    for (i = 0; i < n && (this.batchToUnion.size() < 2 || vertexCount < this.binVertexThreshold); ++i) {
                        if (this.unionBins.get(i) == null) continue;
                        while (!(this.unionBins.get(i).isEmpty() || this.batchToUnion.size() >= 2 && vertexCount >= this.binVertexThreshold)) {
                            ArrayList<GeomPair> bin = this.unionBins.get(i);
                            this.batchToUnion.add(bin.get(bin.size() - 1));
                            bin.remove(bin.size() - 1);
                            level = i;
                            this.totalVertexCount -= this.batchToUnion.get((int)(this.batchToUnion.size() - 1)).vertex_count;
                            vertexCount += this.batchToUnion.get((int)(this.batchToUnion.size() - 1)).vertex_count;
                            this.binSizes.write(i, this.binSizes.read(i) - this.batchToUnion.get((int)(this.batchToUnion.size() - 1)).vertex_count);
                        }
                    }
                    if (this.batchToUnion.size() == 1) {
                        this.unionBins.get(level).add(this.batchToUnion.get(this.batchToUnion.size() - 1));
                        this.totalVertexCount += this.batchToUnion.get((int)(this.batchToUnion.size() - 1)).vertex_count;
                        this.binSizes.write(level, this.binSizes.read(level) + this.batchToUnion.get((int)(this.batchToUnion.size() - 1)).vertex_count);
                        this.batchToUnion.remove(this.batchToUnion.size() - 1);
                    }
                }
                if (this.batchToUnion.isEmpty()) break;
                ArrayList<Geometry> geoms = new ArrayList<Geometry>(0);
                geoms.ensureCapacity(this.batchToUnion.size());
                int n2 = this.batchToUnion.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    geoms.add(this.batchToUnion.get((int)i2).geom);
                }
                Geometry resGeom = TopologicalOperations.dissolveDirty(geoms, this.m_spatial_reference, this.m_progress_tracker);
                int resDim = resGeom.getDimension();
                this.dissolved_something = true;
                GeomPair pair = new GeomPair();
                pair.init();
                pair.geom = resGeom;
                pair.vertex_count = sz = OperatorUnionCursor.getVertexCount_(resGeom);
                int level = OperatorUnionCursor.getLevel_(sz);
                int resize = Math.max(this.unionBins.size() + 1, level);
                if (resize > this.unionBins.size()) {
                    int grow = resize - this.unionBins.size();
                    for (int i3 = 0; i3 < grow; ++i3) {
                        this.unionBins.add(null);
                    }
                }
                this.binSizes.resize(resize, 0.0);
                if (this.unionBins.get(level) == null) {
                    this.unionBins.set(level, new ArrayList(0));
                }
                this.unionBins.get(level).add(pair);
                this.binSizes.write(level, this.binSizes.read(level) + sz);
                this.totalToUnion -= this.batchToUnion.size() - 1;
                this.batchToUnion.clear();
            }
            boolean bl = bCanGo = this.totalToUnion == 1;
            if (!this.bFinished) break block25;
            this.bLocalDone = true;
        }
    }

    private void startDissolve() {
        this.m_index = this.m_inputGeoms.getGeometryID();
        this.unionBins.ensureCapacity(128);
        this.binSizes.reserve(128);
        for (int i = 0; i < 16; ++i) {
            this.unionBins.add(null);
        }
        this.batchToUnion.ensureCapacity(32);
    }

    @Override
    public boolean tock() {
        if (!this.m_b_done) {
            this.step();
        }
        return this.bFinished;
    }

    private Geometry dissolve_() {
        while (!this.bLocalDone) {
            this.step();
        }
        Geometry resGeom = null;
        for (int i = 0; i < this.unionBins.size(); ++i) {
            if (this.unionBins.get(i) == null || this.unionBins.get(i).size() <= 0) continue;
            resGeom = this.unionBins.get((int)i).get((int)0).geom;
        }
        if (resGeom == null) {
            return resGeom;
        }
        if (this.dissolved_something) {
            OperatorFactoryLocal engine = OperatorFactoryLocal.getInstance();
            OperatorSimplify simplify = (OperatorSimplify)engine.getOperator(Operator.Type.Simplify);
            resGeom = simplify.execute(resGeom, (SpatialReference)this.m_spatial_reference, false, this.m_progress_tracker);
        }
        if (resGeom.getType().value() == 33) {
            MultiPoint mp = new MultiPoint(resGeom.getDescription());
            if (!resGeom.isEmpty()) {
                mp.add((Point)resGeom);
            }
            resGeom = mp;
        }
        return resGeom;
    }

    private static int getVertexCount_(Geometry geom) {
        int gt = geom.getType().value();
        if (Geometry.isMultiVertex(gt)) {
            return ((MultiVertexGeometry)geom).getPointCount();
        }
        if (gt == 33) {
            return 1;
        }
        if (gt == 197) {
            return 4;
        }
        if (Geometry.isSegment(gt)) {
            return 2;
        }
        throw new GeometryException("internal error");
    }

    private static int getLevel_(int sz) {
        return sz > 0 ? (int)(Math.log(sz) / Math.log(4.0) + 0.5) : 0;
    }

    private static final class GeomPair {
        Geometry geom;
        int vertex_count;

        private GeomPair() {
        }

        void init() {
            this.geom = null;
            this.vertex_count = -1;
        }
    }
}

