/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.Line;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.OperatorOffset;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SegmentIterator;
import java.util.ArrayList;

class ConstructOffset {
    ProgressTracker m_progressTracker;
    Geometry m_inputGeometry;
    double m_distance;
    double m_tolerance;
    OperatorOffset.JoinType m_joins;
    double m_miterLimit;
    ArrayList<GraphicPoint> m_srcPts;
    int m_srcPtCount;
    ArrayList<GraphicPoint> m_offsetPts;
    int m_offsetPtCount;
    MultiPath m_resultPath;
    int m_resultPoints;
    double m_a1;
    double m_a2;
    boolean m_bBadSegs;
    private final double pi = Math.PI;
    private final double two_pi = Math.PI * 2;
    private final double half_pi = 1.5707963267948966;
    private final double sqrt2 = 1.4142135623730951;
    private final double oneDegree = Math.PI / 180;
    private final int BAD_SEG = 256;
    private final int IS_END = 512;
    private final int CLOSING_SEG = 1024;

    ConstructOffset(ProgressTracker progressTracker) {
        this.m_progressTracker = progressTracker;
    }

    static Geometry execute(Geometry inputGeometry, double distance, OperatorOffset.JoinType joins, double miterLimit, double tolerance, ProgressTracker progressTracker) {
        if (inputGeometry == null) {
            throw new IllegalArgumentException();
        }
        if (inputGeometry.getDimension() < 1) {
            throw new IllegalArgumentException();
        }
        if (distance == 0.0 || inputGeometry.isEmpty()) {
            return inputGeometry;
        }
        ConstructOffset offset = new ConstructOffset(progressTracker);
        offset.m_inputGeometry = inputGeometry;
        offset.m_distance = distance;
        offset.m_tolerance = tolerance;
        offset.m_joins = joins;
        offset.m_miterLimit = miterLimit;
        return offset._ConstructOffset();
    }

    Geometry _OffsetLine() {
        Line line = (Line)this.m_inputGeometry;
        Point2D start = line.getStartXY();
        Point2D end = line.getEndXY();
        Point2D v = new Point2D();
        v.sub(end, start);
        v.normalize();
        v.leftPerpendicular();
        v.scale(this.m_distance);
        start.add(v);
        end.add(v);
        Line resLine = (Line)line.createInstance();
        line.setStartXY(start);
        line.setEndXY(end);
        return resLine;
    }

    Geometry _OffsetEnvelope() {
        Envelope envelope = (Envelope)this.m_inputGeometry;
        if (this.m_distance > 0.0 && this.m_joins != OperatorOffset.JoinType.Miter) {
            Polygon poly = new Polygon();
            poly.addEnvelope(envelope, false);
            this.m_inputGeometry = poly;
            return this._ConstructOffset();
        }
        Envelope resEnv = new Envelope(envelope.m_envelope);
        resEnv.inflate(this.m_distance, this.m_distance);
        return resEnv;
    }

    void addPoint(GraphicPoint pt) {
        this.m_offsetPts.add(pt);
        ++this.m_offsetPtCount;
    }

    double scal(GraphicPoint pt1, GraphicPoint pt2, GraphicPoint pt3, GraphicPoint pt4) {
        return (pt2.x - pt1.x) * (pt4.x - pt3.x) + (pt2.y - pt1.y) * (pt4.y - pt3.y);
    }

    void addPoint(GraphicPoint offPt, int i_src) {
        GraphicPoint pt;
        if (this.m_offsetPtCount == 0) {
            this.addPoint(offPt);
            return;
        }
        int n_src = this.m_srcPtCount;
        GraphicPoint pt1 = this.m_srcPts.get(i_src == 0 ? n_src - 1 : i_src - 1);
        double s = this.scal(pt1, pt = this.m_srcPts.get(i_src), this.m_offsetPts.get(this.m_offsetPtCount - 1), offPt);
        if (s > 0.0) {
            this.addPoint(offPt);
            return;
        }
        if (s < 0.0) {
            if (this.scal(pt1, pt, pt, this.m_offsetPts.get(this.m_offsetPtCount - 1)) > 0.0) {
                int k = i_src == 0 ? n_src - 2 : (i_src == 1 ? n_src - 1 : i_src - 2);
                GraphicPoint pt0 = this.m_srcPts.get(k);
                double a = Math.atan2(pt1.y - pt0.y, pt1.x - pt0.x);
                GraphicPoint p = new GraphicPoint(pt1, this.m_distance, a - 1.5707963267948966);
                this.m_offsetPts.set(this.m_offsetPtCount - 1, p);
                if (this.m_joins == OperatorOffset.JoinType.Bevel || this.m_joins == OperatorOffset.JoinType.Miter) {
                    p = new GraphicPoint(p, pt1);
                    this.addPoint(p);
                    p = new GraphicPoint(pt1, this.m_distance, this.m_a1 + 1.5707963267948966);
                    GraphicPoint p_ = new GraphicPoint(p, pt1);
                    p_.type |= 0x100;
                    this.addPoint(p_);
                    this.addPoint(p);
                } else {
                    p = new GraphicPoint(pt1, this.m_distance, this.m_a1 + 1.5707963267948966);
                    p.type |= 0x100;
                    this.addPoint(p);
                }
                this.addPoint(offPt, i_src);
            } else {
                GraphicPoint p = new GraphicPoint(pt, this.m_distance, this.m_a1 + 1.5707963267948966);
                this.addPoint(p);
                if (this.m_joins == OperatorOffset.JoinType.Bevel || this.m_joins == OperatorOffset.JoinType.Miter) {
                    p = new GraphicPoint(p, pt);
                    this.addPoint(p);
                    p = new GraphicPoint(pt, this.m_distance, this.m_a2 - 1.5707963267948966);
                    GraphicPoint p_ = new GraphicPoint(p, pt);
                    p_.type |= 0x100;
                    this.addPoint(p_);
                    this.addPoint(p);
                } else {
                    p = new GraphicPoint(pt, this.m_distance, this.m_a2 - 1.5707963267948966);
                    p.type |= 0x100;
                    this.addPoint(p);
                }
            }
        }
    }

    boolean buildOffset() {
        GraphicPoint pt;
        int n = this.m_srcPtCount;
        this.m_offsetPtCount = 0;
        double flattenTolerance = this.m_tolerance * 0.5;
        double a1_0 = 0.0;
        double a2_0 = 0.0;
        for (int i = 0; i < n; ++i) {
            boolean bAddSegment;
            double a;
            double da;
            GraphicPoint p;
            pt = this.m_srcPts.get(i);
            GraphicPoint pt1 = i == 0 ? this.m_srcPts.get(n - 1) : this.m_srcPts.get(i - 1);
            GraphicPoint pt2 = i == n - 1 ? this.m_srcPts.get(0) : this.m_srcPts.get(i + 1);
            double dx1 = pt1.x - pt.x;
            double dy1 = pt1.y - pt.y;
            double dx2 = pt2.x - pt.x;
            double dy2 = pt2.y - pt.y;
            double a1 = Math.atan2(dy1, dx1);
            double a2 = Math.atan2(dy2, dx2);
            this.m_a1 = a1;
            this.m_a2 = a2;
            if (i == 0) {
                a1_0 = a1;
                a2_0 = a2;
            }
            double cross_product = dx1 * dy2 - dx2 * dy1;
            double saved_a2 = a2;
            if (a2 < a1) {
                a2 += Math.PI * 2;
            }
            if (cross_product * this.m_distance > 0.0) {
                if (this.m_joins == OperatorOffset.JoinType.Bevel || this.m_joins == OperatorOffset.JoinType.Miter) {
                    p = new GraphicPoint(pt, this.m_distance, a1 + 1.5707963267948966);
                    this.addPoint(p);
                    double ratio = 0.001;
                    p = new GraphicPoint(pt, p, ratio);
                    this.addPoint(p);
                    p = new GraphicPoint(pt, this.m_distance, a2 - 1.5707963267948966);
                    GraphicPoint p_ = new GraphicPoint(pt, p, ratio);
                    p_.type |= 0x100;
                    this.addPoint(p_);
                    this.addPoint(p);
                    continue;
                }
                double r = (a2 - a1) * 0.5;
                double d = this.m_distance / Math.abs(Math.sin(r));
                p = new GraphicPoint(pt, d, (a1 + a2) * 0.5);
                this.addPoint(p, i);
                continue;
            }
            if ((pt.type & 0x200) != 0) {
                double r = 1.0 - flattenTolerance / Math.abs(this.m_distance);
                long na = 1L;
                double d = da = this.m_distance < 0.0 ? -Math.PI : Math.PI;
                if (r > -1.0 && r < 1.0) {
                    a = Math.acos(r) * 2.0;
                    if (a < Math.PI / 180) {
                        a = Math.PI / 180;
                    }
                    if ((na = (long)(Math.PI / a + 1.5)) > 1L) {
                        da /= (double)na;
                    }
                }
                a = a1 + 1.5707963267948966;
                p = new GraphicPoint(pt, this.m_distance, a);
                if (i == 0) {
                    p.type |= 0x400;
                }
                this.addPoint(p, i);
                double d2 = this.m_distance / Math.cos(da / 2.0);
                p = new GraphicPoint(pt, d2, a += da / 2.0);
                p.type |= 0x400;
                this.addPoint(p);
                while (--na > 0L) {
                    p = new GraphicPoint(pt, d2, a += da);
                    p.type |= 0x400;
                    this.addPoint(p);
                }
                p = new GraphicPoint(pt, this.m_distance, a2 - 1.5707963267948966);
                p.type |= 0x400;
                this.addPoint(p);
                continue;
            }
            if (this.m_joins == OperatorOffset.JoinType.Bevel) {
                p = new GraphicPoint(pt, this.m_distance, a1 + 1.5707963267948966);
                this.addPoint(p, i);
                p = new GraphicPoint(pt, this.m_distance, a2 - 1.5707963267948966);
                this.addPoint(p);
                continue;
            }
            if (this.m_joins == OperatorOffset.JoinType.Round) {
                double r = 1.0 - flattenTolerance / Math.abs(this.m_distance);
                long na = 1L;
                da = a2 - 1.5707963267948966 - (a1 + 1.5707963267948966);
                if (r > -1.0 && r < 1.0) {
                    a = Math.acos(r) * 2.0;
                    if (a < Math.PI / 180) {
                        a = Math.PI / 180;
                    }
                    if ((na = (long)(Math.abs(da) / a + 1.5)) > 1L) {
                        da /= (double)na;
                    }
                }
                double d = this.m_distance / Math.cos(da * 0.5);
                double a3 = a1 + 1.5707963267948966 + da * 0.5;
                p = new GraphicPoint(pt, d, a3);
                this.addPoint(p, i);
                while (--na > 0L) {
                    p = new GraphicPoint(pt, d, a3 += da);
                    this.addPoint(p);
                }
                continue;
            }
            if (this.m_joins == OperatorOffset.JoinType.Miter) {
                double d;
                double r;
                double bevelDistance;
                double d2;
                dx1 = pt1.x - pt.x;
                dx2 = pt2.x - pt.x;
                dy1 = pt1.y - pt.y;
                dy2 = pt2.y - pt.y;
                double d1 = Math.sqrt(dx1 * dx1 + dy1 * dy1);
                double cosa = (dx1 * dx2 + dy1 * dy2) / d1 / (d2 = Math.sqrt(dx2 * dx2 + dy2 * dy2));
                if (cosa > 0.99999999) {
                    p = new GraphicPoint(pt, 1.4142135623730951 * this.m_distance, a2 - 0.7853981633974483);
                    this.addPoint(p, i);
                    p = new GraphicPoint(pt, 1.4142135623730951 * this.m_distance, a2 + 0.7853981633974483);
                    this.addPoint(p);
                    continue;
                }
                double distanceFromCorner = Math.abs(this.m_distance / Math.sin(Math.acos(cosa) * 0.5));
                if (distanceFromCorner > (bevelDistance = Math.abs(this.m_miterLimit * this.m_distance))) {
                    r = (a2 - a1) * 0.5;
                    d = this.m_distance / Math.abs(Math.sin(r));
                    p = new GraphicPoint(pt, d, (a1 + a2) * 0.5);
                    Point2D corner = new Point2D(p.x, p.y);
                    Point2D through = new Point2D(pt.x, pt.y);
                    Point2D delta = new Point2D();
                    delta.sub(corner, through);
                    Point2D midPoint = new Point2D();
                    midPoint.scaleAdd(bevelDistance / delta.length(), delta, through);
                    double sideLength = Math.sqrt(distanceFromCorner * distanceFromCorner - this.m_distance * this.m_distance);
                    double halfWidth = (distanceFromCorner - bevelDistance) * Math.abs(this.m_distance) / sideLength;
                    if (this.m_distance > 0.0) {
                        delta.leftPerpendicular();
                    } else {
                        delta.rightPerpendicular();
                    }
                    delta.scale(halfWidth / delta.length());
                    Point2D from = new Point2D();
                    from.add(midPoint, delta);
                    Point2D to = new Point2D();
                    to.sub(midPoint, delta);
                    p = new GraphicPoint(from);
                    this.addPoint(p, i);
                    p = new GraphicPoint(to);
                    this.addPoint(p);
                    continue;
                }
                r = (a2 - a1) * 0.5;
                d = this.m_distance / Math.abs(Math.sin(r));
                p = new GraphicPoint(pt, d, (a1 + a2) * 0.5);
                this.addPoint(p, i);
                continue;
            }
            a2 = saved_a2;
            if (this.m_distance > 0.0) {
                if (a2 > a1) {
                    a2 -= Math.PI * 2;
                }
                bAddSegment = a1 - a2 < 1.5707963267948966;
            } else {
                if (a2 < a1) {
                    a2 += Math.PI * 2;
                }
                boolean bl = bAddSegment = a2 - a1 < 1.5707963267948966;
            }
            if (bAddSegment) {
                double d = this.m_distance * 1.4142135623730951;
                double a4 = d < 0.0 ? a1 + 0.7853981633974483 : a1 + 2.356194490192345;
                p = new GraphicPoint(pt, d, a4);
                this.addPoint(p, i);
                a4 = d < 0.0 ? a2 - 0.7853981633974483 : a2 - 2.356194490192345;
                p = new GraphicPoint(pt, d, a4);
                this.addPoint(p);
                continue;
            }
            double r = (a2 - a1) * 0.5;
            double d = this.m_distance / Math.abs(Math.sin(r));
            if (a2 < a1) {
                a2 += Math.PI * 2;
            }
            p = new GraphicPoint(pt, d, (a1 + a2) / 2.0);
            this.addPoint(p, i);
        }
        this.m_a1 = a1_0;
        this.m_a2 = a2_0;
        this.addPoint(this.m_offsetPts.get(0), 0);
        pt = new GraphicPoint(this.m_offsetPts.get(this.m_offsetPtCount - 1));
        this.m_offsetPts.set(0, pt);
        return this.removeBadSegsFast();
    }

    void addPart(int iStart, int cPts) {
        if (cPts < 2) {
            return;
        }
        for (int i = 0; i < cPts; ++i) {
            GraphicPoint pt = this.m_offsetPts.get(iStart + i);
            if (i != 0) {
                this.m_resultPath.lineTo(new Point2D(pt.x, pt.y));
                continue;
            }
            this.m_resultPath.startPath(new Point2D(pt.x, pt.y));
        }
    }

    void _OffsetPath(MultiPath multiPath, int pathIndex, MultiPath resultingPath) {
        int startVertex;
        int endVertex = multiPath.getPathEnd(pathIndex);
        this.m_offsetPts = new ArrayList();
        this.m_resultPath = resultingPath;
        this.m_resultPoints = 0;
        if (multiPath.isClosedPath(pathIndex)) {
            Point2D ptStart = multiPath.getXY(startVertex);
            while (multiPath.getXY(endVertex - 1).equals(ptStart)) {
                --endVertex;
            }
            if (endVertex - startVertex >= 2) {
                this.m_srcPtCount = endVertex - startVertex;
                this.m_srcPts = new ArrayList(this.m_srcPtCount);
                for (int i = startVertex; i < endVertex; ++i) {
                    this.m_srcPts.add(new GraphicPoint(multiPath.getXY(i)));
                }
                if (this.buildOffset()) {
                    this.addPart(0, this.m_offsetPtCount - 1);
                }
            }
        } else {
            Point2D ptStart = multiPath.getXY(startVertex);
            for (startVertex = multiPath.getPathStart(pathIndex); startVertex < endVertex && multiPath.getXY(startVertex + 1).equals(ptStart); ++startVertex) {
            }
            Point2D ptEnd = multiPath.getXY(endVertex - 1);
            while (startVertex < endVertex && multiPath.getXY(endVertex - 2).equals(ptEnd)) {
                --endVertex;
            }
            if (endVertex - startVertex >= 2) {
                int i;
                this.m_srcPtCount = (endVertex - startVertex) * 2 - 2;
                this.m_srcPts = new ArrayList(this.m_srcPtCount);
                GraphicPoint pt = new GraphicPoint(multiPath.getXY(startVertex));
                pt.type |= 0x600;
                this.m_srcPts.add(pt);
                for (i = startVertex + 1; i < endVertex - 1; ++i) {
                    pt = new GraphicPoint(multiPath.getXY(i));
                    this.m_srcPts.add(pt);
                }
                pt = new GraphicPoint(multiPath.getXY(endVertex - 1));
                pt.type |= 0x200;
                this.m_srcPts.add(pt);
                for (i = endVertex - 2; i >= startVertex + 1; --i) {
                    pt = new GraphicPoint(multiPath.getXY(i));
                    pt.type |= 0x400;
                    this.m_srcPts.add(pt);
                }
                if (this.buildOffset()) {
                    int iStart;
                    if (this.m_offsetPts.size() >= 2) {
                        boolean prevClosed;
                        iStart = -1;
                        int iEnd = -1;
                        boolean bl = prevClosed = (this.m_offsetPts.get((int)(this.m_offsetPtCount - 1)).type & 0x400) != 0;
                        if (!prevClosed) {
                            iStart = 0;
                        }
                        for (int i2 = 1; i2 < this.m_offsetPtCount; ++i2) {
                            boolean closed;
                            boolean bl2 = closed = (this.m_offsetPts.get((int)i2).type & 0x400) != 0;
                            if (!closed) {
                                if (prevClosed) {
                                    iStart = i2 - 1;
                                }
                            } else if (!prevClosed && (iEnd = i2 - 1) - iStart + 1 > 1) {
                                this.addPart(iStart, iEnd - iStart + 1);
                            }
                            prevClosed = closed;
                        }
                        if (!prevClosed && (iEnd = this.m_offsetPtCount - 1) - iStart + 1 > 1) {
                            this.addPart(iStart, iEnd - iStart + 1);
                        }
                    } else {
                        iStart = 0;
                        int iEnd = this.m_offsetPtCount - 1;
                        if (iStart >= 0 && iEnd - iStart >= 1) {
                            this.addPart(iStart, iEnd - iStart + 1);
                        }
                    }
                }
            }
        }
        this.m_srcPts = null;
        this.m_srcPtCount = 0;
        this.m_offsetPts = null;
        this.m_offsetPtCount = 0;
    }

    boolean removeBadSegsFast() {
        boolean bWrong = false;
        for (int i = 0; i < this.m_offsetPtCount; ++i) {
            GraphicPoint pt = this.m_offsetPts.get(i);
            pt.m_next = i + 1;
            pt.m_prev = i - 1;
            this.m_offsetPts.set(i, pt);
        }
        GraphicPoint pt = this.m_offsetPts.get(0);
        pt.m_prev = this.m_offsetPtCount - 2;
        this.m_offsetPts.set(0, pt);
        pt = this.m_offsetPts.get(this.m_offsetPtCount - 2);
        pt.m_next = 0;
        this.m_offsetPts.set(this.m_offsetPtCount - 2, pt);
        int w = 0;
        for (int i = 0; i < this.m_offsetPtCount; ++i) {
            if ((this.m_offsetPts.get((int)w).type & 0x100) != 0) {
                int wNext = this.deleteClosedSeg(w);
                if (wNext != -1) {
                    w = wNext;
                    continue;
                }
                bWrong = true;
                break;
            }
            w = this.m_offsetPts.get((int)w).m_next;
        }
        if (bWrong) {
            return false;
        }
        this.compressOffsetArray(w);
        return true;
    }

    int deleteClosedSeg(int seg) {
        int n = this.m_offsetPtCount - 1;
        int ip0 = seg;
        for (int i = 1; i <= n - 2; ++i) {
            int ip = ip0 = this.m_offsetPts.get((int)ip0).m_next;
            int im = seg;
            for (int j = 1; j <= i; ++j) {
                int rSegNext;
                im = this.m_offsetPts.get((int)im).m_prev;
                if ((this.m_offsetPts.get((int)im).type & 0x100) == 0 && (this.m_offsetPts.get((int)ip).type & 0x100) == 0 && (rSegNext = this.handleClosedIntersection(im, ip)) != -1) {
                    return rSegNext;
                }
                ip = this.m_offsetPts.get((int)ip).m_prev;
            }
        }
        return -1;
    }

    int handleClosedIntersection(int im, int ip) {
        GraphicPoint pt4;
        GraphicPoint pt3;
        GraphicPoint pt2;
        GraphicPoint pt1 = this.m_offsetPts.get(this.m_offsetPts.get((int)im).m_prev);
        if (!this.sectGraphicRect(pt1, pt2 = this.m_offsetPts.get(im), pt3 = this.m_offsetPts.get(this.m_offsetPts.get((int)ip).m_prev), pt4 = this.m_offsetPts.get(ip))) {
            return -1;
        }
        IntersectionInfo ii = new IntersectionInfo();
        if (this.findIntersection(pt1, pt2, pt3, pt4, ii) && !ii.atExistingPt && Math.signum((pt2.x - pt1.x) * (pt4.y - pt3.y) - (pt2.y - pt1.y) * (pt4.x - pt3.x)) != Math.signum(this.m_distance)) {
            int prev0 = this.m_offsetPts.get((int)im).m_prev;
            ii.pt.type = pt2.type;
            ii.pt.m_next = ip;
            ii.pt.m_prev = prev0;
            this.m_offsetPts.set(im, ii.pt);
            ii.pt = this.m_offsetPts.get(ip);
            ii.pt.m_prev = im;
            this.m_offsetPts.set(ip, ii.pt);
            return ip;
        }
        return -1;
    }

    boolean sectGraphicRect(GraphicPoint pt1, GraphicPoint pt2, GraphicPoint pt3, GraphicPoint pt4) {
        return Math.max(pt1.x, pt2.x) >= Math.min(pt3.x, pt4.x) && Math.max(pt3.x, pt4.x) >= Math.min(pt1.x, pt2.x) && Math.max(pt1.y, pt2.y) >= Math.min(pt3.y, pt4.y) && Math.max(pt3.y, pt4.y) >= Math.min(pt1.y, pt2.y);
    }

    boolean findIntersection(GraphicPoint bp1, GraphicPoint bp2, GraphicPoint bp3, GraphicPoint bp4, IntersectionInfo intersectionInfo) {
        intersectionInfo.atExistingPt = false;
        double i = (bp2.y - bp1.y) * (bp4.x - bp3.x) - (bp2.x - bp1.x) * (bp4.y - bp3.y);
        double j = (bp3.y - bp1.y) * (bp2.x - bp1.x) - (bp3.x - bp1.x) * (bp2.y - bp1.y);
        double r = i == 0.0 ? 2.0 : j / i;
        if (r >= 0.0 && r <= 1.0) {
            double r1 = r;
            i = (bp4.y - bp3.y) * (bp2.x - bp1.x) - (bp4.x - bp3.x) * (bp2.y - bp1.y);
            j = (bp1.y - bp3.y) * (bp4.x - bp3.x) - (bp1.x - bp3.x) * (bp4.y - bp3.y);
            r = i == 0.0 ? 2.0 : j / i;
            if (r >= 0.0 && r <= 1.0) {
                intersectionInfo.pt = new GraphicPoint(bp1.x + r * (bp2.x - bp1.x), bp1.y + r * (bp2.y - bp1.y));
                intersectionInfo.pt.m = bp3.m + r1 * (bp4.m - bp3.m);
                if (!(r1 != 0.0 && r1 != 1.0 || r != 0.0 && r != 1.0)) {
                    intersectionInfo.atExistingPt = true;
                }
                intersectionInfo.rFirst = r;
                intersectionInfo.rSecond = r1;
                return (r1 != 0.0 && r1 != 1.0 || !(r > 0.0) || !(r < 1.0)) && (r != 0.0 && r != 1.0 || !(r1 > 0.0) || !(r1 < 1.0));
            }
        }
        return false;
    }

    void compressOffsetArray(int i0) {
        int i_ = i0;
        while (this.m_offsetPts.get((int)i_).m_prev < i_) {
            i_ = this.m_offsetPts.get((int)i_).m_prev;
        }
        int j = 0;
        int i = i_;
        do {
            GraphicPoint pt = this.m_offsetPts.get(i);
            this.m_offsetPts.set(j, pt);
            i = pt.m_next;
            ++j;
        } while (i != i_);
        this.m_offsetPts.set(j, this.m_offsetPts.get(0));
        this.m_offsetPtCount = j + 1;
    }

    void _OffsetMultiPath(MultiPath resultingPath) {
        MultiPath multiPath = (MultiPath)this.m_inputGeometry;
        SegmentIterator segmentIterator = multiPath.querySegmentIterator();
        if (segmentIterator == null) {
            return;
        }
        segmentIterator.resetToFirstPath();
        int pathIndex = -1;
        while (segmentIterator.nextPath()) {
            this._OffsetPath(multiPath, ++pathIndex, resultingPath);
        }
    }

    Geometry _ConstructOffset() {
        int gt = this.m_inputGeometry.getType().value();
        if (gt == 322) {
            return this._OffsetLine();
        }
        if (gt == 197) {
            return this._OffsetEnvelope();
        }
        if (Geometry.isSegment(gt)) {
            Polyline poly = new Polyline();
            poly.addSegment((Segment)this.m_inputGeometry, true);
            this.m_inputGeometry = poly;
            return this._ConstructOffset();
        }
        if (gt == 1607) {
            Polyline polyline = new Polyline();
            this._OffsetMultiPath(polyline);
            return polyline;
        }
        if (gt == 1736) {
            Polygon polygon = new Polygon();
            this._OffsetMultiPath(polygon);
            return polygon;
        }
        return null;
    }

    static class IntersectionInfo {
        GraphicPoint pt;
        double rFirst;
        double rSecond;
        boolean atExistingPt;

        IntersectionInfo() {
        }
    }

    static class GraphicRect {
        double x1;
        double x2;
        double y1;
        double y2;

        GraphicRect() {
        }
    }

    static class GraphicPoint {
        double x;
        double y;
        int m_next;
        int m_prev;
        double m;
        int type;

        GraphicPoint(double x_, double y_) {
            this.x = x_;
            this.y = y_;
            this.type = 0;
            this.m = 0.0;
        }

        GraphicPoint(Point2D r) {
            this.x = r.x;
            this.y = r.y;
            this.type = 0;
            this.m = 0.0;
        }

        GraphicPoint(GraphicPoint pt) {
            this.x = pt.x;
            this.y = pt.y;
            this.type = pt.type;
            this.m = pt.m;
        }

        GraphicPoint(GraphicPoint srcPt, double d, double angle) {
            this.x = srcPt.x + d * Math.cos(angle);
            this.y = srcPt.y + d * Math.sin(angle);
            this.type = srcPt.type;
            this.m = srcPt.m;
        }

        GraphicPoint(GraphicPoint pt1, GraphicPoint pt2) {
            this.x = (pt1.x + pt2.x) * 0.5;
            this.y = (pt1.y + pt2.y) * 0.5;
            this.type = pt1.type;
            this.m = pt1.m;
        }

        GraphicPoint(GraphicPoint pt1, GraphicPoint pt2, double ratio) {
            this.x = pt1.x + (pt2.x - pt1.x) * ratio;
            this.y = pt1.y + (pt2.y - pt1.y) * ratio;
            this.type = pt1.type;
            this.m = pt1.m;
        }
    }
}

