/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.model.launch;

import com.epam.ta.reportportal.ws.annotations.NotBlankWithSize;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributeResource;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MergeLaunchesRQ {
    @NotBlankWithSize(min=1, max=256)
    @JsonProperty(value="name", required=true)
    @ApiModelProperty(required=true)
    private String name;
    @JsonProperty(value="description")
    private String description;
    @Size(max=256)
    @Valid
    @JsonProperty(value="attributes")
    private @Size(max=256) @Valid Set<ItemAttributeResource> attributes;
    @JsonProperty(value="startTime")
    @ApiModelProperty
    private Date startTime;
    @JsonProperty(value="mode")
    private Mode mode;
    @NotEmpty
    @JsonProperty(value="launches", required=true)
    @ApiModelProperty(required=true)
    private Set<Long> launches;
    @JsonProperty(value="endTime")
    @ApiModelProperty
    private Date endTime;
    @NotNull
    @JsonProperty(value="mergeType")
    @ApiModelProperty(allowableValues="BASIC, DEEP")
    private String mergeStrategyType;
    @JsonProperty(value="extendSuitesDescription", required=true)
    private boolean extendSuitesDescription;

    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<ItemAttributeResource> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Set<ItemAttributeResource> attributes) {
        this.attributes = attributes;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    @NotNull
    public Set<Long> getLaunches() {
        return this.launches;
    }

    public void setLaunches(@NotNull Set<Long> launches) {
        this.launches = launches;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @NotNull
    public String getMergeStrategyType() {
        return this.mergeStrategyType;
    }

    public void setMergeStrategyType(@NotNull String mergeStrategyType) {
        this.mergeStrategyType = mergeStrategyType;
    }

    public boolean isExtendSuitesDescription() {
        return this.extendSuitesDescription;
    }

    public void setExtendSuitesDescription(boolean extendSuitesDescription) {
        this.extendSuitesDescription = extendSuitesDescription;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MergeLaunchesRQ that = (MergeLaunchesRQ)o;
        if (this.extendSuitesDescription != that.extendSuitesDescription) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.attributes != null ? !this.attributes.equals(that.attributes) : that.attributes != null) {
            return false;
        }
        if (this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null) {
            return false;
        }
        if (this.mode != that.mode) {
            return false;
        }
        if (!this.launches.equals(that.launches)) {
            return false;
        }
        if (this.endTime != null ? !this.endTime.equals(that.endTime) : that.endTime != null) {
            return false;
        }
        return this.mergeStrategyType.equals(that.mergeStrategyType);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
        result = 31 * result + (this.startTime != null ? this.startTime.hashCode() : 0);
        result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
        result = 31 * result + this.launches.hashCode();
        result = 31 * result + (this.endTime != null ? this.endTime.hashCode() : 0);
        result = 31 * result + this.mergeStrategyType.hashCode();
        result = 31 * result + (this.extendSuitesDescription ? 1 : 0);
        return result;
    }

    public String toString() {
        return "MergeLaunchesRQ{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", attributes=" + this.attributes + ", startTime=" + this.startTime + ", mode=" + (Object)((Object)this.mode) + ", launches=" + this.launches + ", endTime=" + this.endTime + ", mergeStrategyType='" + this.mergeStrategyType + '\'' + ", extendSuitesDescription=" + this.extendSuitesDescription + '}';
    }
}

