/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.model;

import com.epam.ta.reportportal.ws.model.ErrorType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.io.Serializable;

@JsonPropertyOrder(value={"errorCode", "message", "stackTrace"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ErrorRS
implements Serializable {
    private static final long serialVersionUID = -3717290684860161862L;
    @JsonSerialize(using=ErrorTypeSerializer.class)
    @JsonDeserialize(using=ErrorTypeDeserializer.class)
    @JsonProperty(value="errorCode")
    private ErrorType errorType;
    @JsonProperty(value="stackTrace")
    private String stackTrace;
    @JsonProperty(value="message")
    private String message;

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public void setErrorType(ErrorType errorType) {
        this.errorType = errorType;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.errorType == null ? 0 : this.errorType.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.stackTrace == null ? 0 : this.stackTrace.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ErrorRS other = (ErrorRS)obj;
        if (this.errorType != other.errorType) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        return !(this.stackTrace == null ? other.stackTrace != null : !this.stackTrace.equals(other.stackTrace));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ErrorRS{");
        sb.append("errorType=").append((Object)this.errorType);
        sb.append(", stackTrace='").append(this.stackTrace).append('\'');
        sb.append(", message='").append(this.message).append('\'');
        sb.append('}');
        return sb.toString();
    }

    private static class ErrorTypeSerializer
    extends JsonSerializer<ErrorType> {
        private ErrorTypeSerializer() {
        }

        public void serialize(ErrorType error, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeNumber(error.getCode());
        }
    }

    private static class ErrorTypeDeserializer
    extends JsonDeserializer<ErrorType> {
        private ErrorTypeDeserializer() {
        }

        public ErrorType deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            ObjectCodec oc = parser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(parser);
            return ErrorType.getByCode(node.asInt());
        }
    }
}

