/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.spock;

import com.epam.reportportal.listeners.ItemStatus;
import com.google.common.base.Preconditions;
import io.reactivex.Maybe;
import java.util.Optional;
import java.util.function.Predicate;
import org.spockframework.runtime.model.NodeInfo;

abstract class ReportableItemFootprint<T extends NodeInfo> {
    static final Predicate<ReportableItemFootprint> IS_NOT_PUBLISHED = input -> input != null && !input.isPublished();
    private final Maybe<String> id;
    private final T item;
    private ItemStatus status;
    private boolean published = false;

    ReportableItemFootprint(T item, Maybe<String> id) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"Node info shouldn't be null");
        this.id = id;
        this.item = item;
    }

    T getItem() {
        return this.item;
    }

    Maybe<String> getId() {
        return this.id;
    }

    Optional<ItemStatus> getStatus() {
        return Optional.ofNullable(this.status);
    }

    void setStatus(ItemStatus status) {
        this.status = status;
    }

    void markAsPublished() {
        this.published = true;
    }

    boolean isPublished() {
        return this.published;
    }

    String getItemName() {
        return this.getItem().getName();
    }

    abstract boolean hasDescendants();
}

