/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.spock;

import com.epam.reportportal.annotations.TestCaseId;
import com.epam.reportportal.annotations.attribute.Attributes;
import com.epam.reportportal.exception.ReportPortalException;
import com.epam.reportportal.listeners.ItemStatus;
import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.ReportPortal;
import com.epam.reportportal.service.item.TestCaseIdEntry;
import com.epam.reportportal.spock.AbstractLaunchContext;
import com.epam.reportportal.spock.FixtureFootprint;
import com.epam.reportportal.spock.FixtureInterceptor;
import com.epam.reportportal.spock.LaunchContextImpl;
import com.epam.reportportal.spock.NodeFootprint;
import com.epam.reportportal.spock.NodeInfoUtils;
import com.epam.reportportal.spock.ReportableItemFootprint;
import com.epam.reportportal.spock.utils.SystemAttributesFetcher;
import com.epam.reportportal.utils.AttributeParser;
import com.epam.reportportal.utils.MemoizingSupplier;
import com.epam.reportportal.utils.ParameterUtils;
import com.epam.reportportal.utils.StatusEvaluation;
import com.epam.reportportal.utils.TestCaseIdUtils;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributesRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import io.reactivex.Maybe;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.codehaus.groovy.runtime.StackTraceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spockframework.runtime.AbstractRunListener;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.model.ErrorInfo;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.MethodKind;
import org.spockframework.runtime.model.NodeInfo;
import org.spockframework.runtime.model.SpecInfo;

public class ReportPortalSpockListener
extends AbstractRunListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportPortalSpockListener.class);
    private static final Method[] ITERATION_METHODS = IterationInfo.class.getMethods();
    private static final Method DISPLAY_NAME_METHOD = Arrays.stream(ITERATION_METHODS).filter(m -> "getDisplayName".equals(m.getName())).findAny().orElseGet(() -> Arrays.stream(ITERATION_METHODS).filter(m -> "getName".equals(m.getName())).findAny().orElseThrow(() -> new IllegalStateException("Unknown Spock version.")));
    private final MemoizingSupplier<Launch> launch;
    private static final Map<MethodKind, String> ITEM_TYPES_REGISTRY = ImmutableMap.builder().put((Object)MethodKind.SPEC_EXECUTION, (Object)"TEST").put((Object)MethodKind.SETUP_SPEC, (Object)"BEFORE_CLASS").put((Object)MethodKind.SETUP, (Object)"BEFORE_METHOD").put((Object)MethodKind.FEATURE, (Object)"STEP").put((Object)MethodKind.CLEANUP, (Object)"AFTER_METHOD").put((Object)MethodKind.CLEANUP_SPEC, (Object)"AFTER_CLASS").build();
    private ListenerParameters launchParameters;
    private final AbstractLaunchContext launchContext;

    @Nonnull
    protected StartLaunchRQ buildStartLaunchRq(ListenerParameters parameters) {
        StartLaunchRQ startLaunchRQ = new StartLaunchRQ();
        startLaunchRQ.setName(parameters.getLaunchName());
        if (!Strings.isNullOrEmpty((String)parameters.getDescription())) {
            startLaunchRQ.setDescription(parameters.getDescription());
        }
        startLaunchRQ.setStartTime(Calendar.getInstance().getTime());
        HashSet<ItemAttributesRQ> attributes = new HashSet<ItemAttributesRQ>();
        attributes.addAll(parameters.getAttributes());
        attributes.addAll(SystemAttributesFetcher.collectSystemAttributes(parameters.getSkippedAnIssue()));
        startLaunchRQ.setAttributes(attributes);
        startLaunchRQ.setMode(parameters.getLaunchRunningMode());
        return startLaunchRQ;
    }

    public ReportPortalSpockListener(ReportPortal reportPortal) {
        this.launchContext = new LaunchContextImpl();
        this.launchParameters = reportPortal.getParameters();
        this.launch = new MemoizingSupplier(() -> {
            StartLaunchRQ rq = this.buildStartLaunchRq(this.launchParameters);
            return reportPortal.newLaunch(rq);
        });
    }

    public ReportPortalSpockListener() {
        this(ReportPortal.builder().build());
    }

    public ReportPortalSpockListener(@Nonnull Supplier<Launch> launch, AbstractLaunchContext launchContext) {
        this.launchContext = launchContext;
        this.launch = new MemoizingSupplier(launch);
    }

    public ReportPortalSpockListener(@Nonnull Supplier<Launch> launch) {
        this(launch, new LaunchContextImpl());
    }

    public Maybe<String> startLaunch() {
        if (this.launchContext.tryStartLaunch()) {
            try {
                Maybe launchId = ((Launch)this.launch.get()).start();
                this.launchContext.setLaunchId((Maybe<String>)launchId);
                return launchId;
            }
            catch (ReportPortalException ex) {
                this.handleRpException(ex, "Unable start the launch: '" + Optional.ofNullable(this.launchParameters).map(ListenerParameters::getLaunchName).orElse("Unknown Launch") + "'");
            }
        }
        return this.launchContext.getLaunchId();
    }

    protected void setAttributes(@Nonnull StartTestItemRQ rq, @Nonnull AnnotatedElement methodOrClass) {
        Attributes attributes = methodOrClass.getAnnotation(Attributes.class);
        if (attributes != null) {
            Set itemAttributes = AttributeParser.retrieveAttributes((Attributes)attributes);
            rq.setAttributes(itemAttributes);
        }
    }

    @Nonnull
    protected StartTestItemRQ buildBaseStartTestItemRq(@Nonnull String name, @Nonnull String type) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(name);
        rq.setStartTime(Calendar.getInstance().getTime());
        rq.setType(type);
        rq.setLaunchUuid((String)this.launchContext.getLaunchId().blockingGet());
        return rq;
    }

    protected void setSpecAttributes(@Nonnull StartTestItemRQ rq, @Nonnull SpecInfo spec) {
        this.setAttributes(rq, spec.getReflection());
    }

    @Nonnull
    protected StartTestItemRQ buildSpecItemRq(@Nonnull SpecInfo spec) {
        StartTestItemRQ rq = this.buildBaseStartTestItemRq(spec.getName(), ITEM_TYPES_REGISTRY.get(MethodKind.SPEC_EXECUTION));
        rq.setDescription(spec.getNarrative());
        rq.setCodeRef(((Class)spec.getReflection()).getCanonicalName());
        this.setSpecAttributes(rq, spec);
        return rq;
    }

    @Nonnull
    protected Maybe<String> startSpec(@Nonnull StartTestItemRQ rq) {
        return ((Launch)this.launch.get()).startTestItem(rq);
    }

    public void registerSpec(@Nonnull SpecInfo spec) {
        if (this.launchContext.isSpecRegistered(spec)) {
            return;
        }
        Maybe<String> testItemId = this.startSpec(this.buildSpecItemRq(spec));
        this.launchContext.addRunningSpec(testItemId, spec);
    }

    @Nonnull
    protected StartTestItemRQ buildFixtureItemRq(@Nonnull FeatureInfo feature, @Nonnull MethodInfo fixture, boolean inherited) {
        MethodKind kind = fixture.getKind();
        String fixtureDisplayName = NodeInfoUtils.getFixtureDisplayName(fixture, inherited);
        StartTestItemRQ rq = this.buildBaseStartTestItemRq(fixtureDisplayName, ITEM_TYPES_REGISTRY.get(kind));
        if (kind.isFeatureScopedFixtureMethod() && !feature.isReportIterations() && feature.isParameterized()) {
            rq.setHasStats(false);
        }
        return rq;
    }

    @Nonnull
    protected Maybe<String> startFixture(@Nonnull Maybe<String> parentId, @Nonnull StartTestItemRQ rq) {
        return ((Launch)this.launch.get()).startTestItem(parentId, rq);
    }

    public void registerFixture(SpecInfo spec, @Nonnull FeatureInfo feature, IterationInfo iteration, @Nonnull MethodInfo fixture) {
        NodeFootprint<SpecInfo> specFootprint = this.launchContext.findSpecFootprint(spec);
        StartTestItemRQ rq = this.buildFixtureItemRq(feature, fixture, !((SpecInfo)fixture.getParent()).equals(specFootprint.getItem()));
        Maybe<String> testItemId = this.startFixture(rq.isHasStats() ? specFootprint.getId() : this.launchContext.findFeatureFootprint(feature).getId(), rq);
        NodeFootprint<? extends NodeInfo> fixtureOwnerFootprint = this.findFixtureOwner(spec, feature, iteration, fixture);
        fixtureOwnerFootprint.addFixtureFootprint(new FixtureFootprint(fixture, testItemId));
    }

    @Nonnull
    protected StartTestItemRQ buildNestedIterationItemRq(@Nonnull IterationInfo iteration) {
        List<Object> params = Arrays.asList(iteration.getDataValues());
        List names = iteration.getFeature().getParameterNames();
        String name = IntStream.range(0, params.size()).mapToObj(i -> {
            String n;
            Object p = params.get(i);
            try {
                n = (String)names.get(i);
                n = Optional.ofNullable(n).orElse("param" + i + 1);
            }
            catch (IndexOutOfBoundsException e) {
                n = "param" + i + 1;
            }
            return Pair.of((Object)n, p);
        }).map(p -> (String)p.getKey() + ": " + p.getValue()).collect(Collectors.joining("; ", "Parameters: ", ""));
        StartTestItemRQ rq = this.buildBaseStartTestItemRq(name, ITEM_TYPES_REGISTRY.get(MethodKind.FEATURE));
        rq.setHasStats(false);
        return rq;
    }

    @Nonnull
    protected StartTestItemRQ buildIterationItemRq(@Nonnull IterationInfo iteration) {
        String displayName;
        try {
            displayName = (String)DISPLAY_NAME_METHOD.invoke((Object)iteration, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        StartTestItemRQ rq = this.buildBaseStartTestItemRq(displayName, ITEM_TYPES_REGISTRY.get(MethodKind.FEATURE));
        rq.setDescription(NodeInfoUtils.buildIterationDescription(iteration));
        MethodInfo featureMethodInfo = iteration.getFeature().getFeatureMethod();
        String codeRef = this.extractCodeRef(featureMethodInfo);
        rq.setCodeRef(codeRef);
        Method method = (Method)featureMethodInfo.getReflection();
        TestCaseId testCaseId = method.getAnnotation(TestCaseId.class);
        List params = Optional.ofNullable(iteration.getDataValues()).map(Arrays::asList).orElse(null);
        rq.setTestCaseId((String)Optional.ofNullable(TestCaseIdUtils.getTestCaseId((TestCaseId)testCaseId, (Executable)method, (String)codeRef, (List)params)).map(TestCaseIdEntry::getId).orElse(null));
        List paramList = Optional.ofNullable(params).orElse(Collections.emptyList());
        List names = iteration.getFeature().getParameterNames();
        rq.setParameters(ParameterUtils.getParameters((String)codeRef, IntStream.range(0, paramList.size()).mapToObj(i -> Pair.of(names.get(i), paramList.get(i))).collect(Collectors.toList())));
        this.setFeatureAttributes(rq, iteration.getFeature());
        return rq;
    }

    @Nonnull
    protected Maybe<String> startIteration(@Nonnull Maybe<String> parentId, @Nonnull StartTestItemRQ rq) {
        return ((Launch)this.launch.get()).startTestItem(parentId, rq);
    }

    protected void reportIterationStart(@Nonnull Maybe<String> parentId, @Nonnull StartTestItemRQ rq, @Nonnull IterationInfo iteration) {
        Maybe<String> testItemId = this.startIteration(parentId, rq);
        this.launchContext.addRunningIteration(testItemId, iteration);
    }

    public void registerIteration(@Nonnull IterationInfo iteration) {
        if (iteration.getFeature().isReportIterations()) {
            this.reportIterationStart(this.launchContext.findSpecFootprint(iteration.getFeature().getSpec()).getId(), this.buildIterationItemRq(iteration), iteration);
        } else if (iteration.getFeature().isParameterized()) {
            this.reportIterationStart(this.launchContext.findFeatureFootprint(iteration.getFeature()).getId(), this.buildNestedIterationItemRq(iteration), iteration);
        }
    }

    @Nonnull
    protected FinishTestItemRQ buildFinishTestItemRq(@Nonnull Maybe<String> itemId, @Nullable ItemStatus status) {
        FinishTestItemRQ rq = new FinishTestItemRQ();
        Optional.ofNullable(status).ifPresent(s -> rq.setStatus(s.name()));
        rq.setEndTime(Calendar.getInstance().getTime());
        return rq;
    }

    protected void reportIterationFinish(@Nonnull ReportableItemFootprint<IterationInfo> footprint) {
        ItemStatus status = footprint.getStatus().orElseGet(() -> {
            footprint.setStatus(ItemStatus.PASSED);
            return ItemStatus.PASSED;
        });
        FinishTestItemRQ rq = this.buildFinishTestItemRq(footprint.getId(), status);
        if (ItemStatus.SKIPPED == status) {
            rq.setIssue(Launch.NOT_ISSUE);
        }
        ((Launch)this.launch.get()).finishTestItem(footprint.getId(), rq);
        footprint.markAsPublished();
    }

    protected void reportFeatureFinish(@Nonnull ReportableItemFootprint<FeatureInfo> footprint) {
        ItemStatus status = footprint.getStatus().orElseGet(() -> {
            FeatureInfo feature = (FeatureInfo)footprint.getItem();
            ItemStatus s = ItemStatus.PASSED;
            for (NodeFootprint<IterationInfo> nodeFootprint : this.launchContext.findIterationFootprints(feature)) {
                for (ReportableItemFootprint<MethodInfo> fixtureFootprint : nodeFootprint.getFixtures()) {
                    if (!fixtureFootprint.getItem().getKind().isSetupMethod()) continue;
                    s = StatusEvaluation.evaluateStatus((ItemStatus)s, (ItemStatus)fixtureFootprint.getStatus().orElse(null));
                }
                s = StatusEvaluation.evaluateStatus((ItemStatus)s, (ItemStatus)nodeFootprint.getStatus().orElse(null));
            }
            return Optional.ofNullable(s).orElseGet(() -> {
                LOGGER.error("Unable to calculate status for feature", (Throwable)new IllegalStateException());
                return ItemStatus.FAILED;
            });
        });
        Maybe<String> itemId = footprint.getId();
        FinishTestItemRQ rq = this.buildFinishTestItemRq(itemId, status);
        if (ItemStatus.SKIPPED == status) {
            rq.setIssue(Launch.NOT_ISSUE);
        }
        ((Launch)this.launch.get()).finishTestItem(itemId, rq);
        footprint.markAsPublished();
    }

    protected void reportTestItemFinish(@Nonnull ReportableItemFootprint<?> footprint) {
        Maybe<String> itemId = footprint.getId();
        FinishTestItemRQ rq = this.buildFinishTestItemRq(itemId, footprint.getStatus().orElse(ItemStatus.PASSED));
        ((Launch)this.launch.get()).finishTestItem(itemId, rq);
        footprint.markAsPublished();
    }

    public void publishFeatureResult(@Nonnull FeatureInfo feature) {
        if (feature.isReportIterations()) {
            Iterable<? extends NodeFootprint<IterationInfo>> iterations = this.launchContext.findIterationFootprints(feature);
            StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterations.iterator(), 64), false).filter(ReportableItemFootprint.IS_NOT_PUBLISHED).forEach(this::reportTestItemFinish);
        } else {
            NodeFootprint<FeatureInfo> footprint = this.launchContext.findFeatureFootprint(feature);
            this.reportFeatureFinish(footprint);
        }
    }

    @Nonnull
    protected StartTestItemRQ buildFeatureItemRq(@Nonnull FeatureInfo featureInfo) {
        StartTestItemRQ rq = this.buildBaseStartTestItemRq(featureInfo.getName(), ITEM_TYPES_REGISTRY.get(MethodKind.FEATURE));
        rq.setDescription(NodeInfoUtils.buildFeatureDescription(featureInfo));
        MethodInfo featureMethodInfo = featureInfo.getFeatureMethod();
        String codeRef = this.extractCodeRef(featureMethodInfo);
        rq.setCodeRef(codeRef);
        Method method = (Method)featureMethodInfo.getReflection();
        TestCaseId testCaseId = method.getAnnotation(TestCaseId.class);
        rq.setTestCaseId((String)Optional.ofNullable(TestCaseIdUtils.getTestCaseId((TestCaseId)testCaseId, (Executable)method, (String)codeRef, null)).map(TestCaseIdEntry::getId).orElse(null));
        this.setFeatureAttributes(rq, featureInfo);
        return rq;
    }

    @Nonnull
    protected Maybe<String> startFeature(@Nonnull Maybe<String> parentId, @Nonnull StartTestItemRQ rq) {
        return ((Launch)this.launch.get()).startTestItem(parentId, rq);
    }

    protected void reportFeatureStart(@Nonnull Maybe<String> parentId, @Nonnull FeatureInfo featureInfo) {
        StartTestItemRQ rq = this.buildFeatureItemRq(featureInfo);
        this.launchContext.addRunningFeature(this.startFeature(parentId, rq), featureInfo);
    }

    public void reportFixtureError(@Nonnull SpecInfo spec, @Nullable FeatureInfo feature, @Nullable IterationInfo iteration, @Nonnull ErrorInfo error) {
        MethodInfo method = error.getMethod();
        NodeFootprint<? extends NodeInfo> ownerFootprint = this.findFixtureOwner(spec, feature, iteration, error.getMethod());
        MethodKind kind = method.getKind();
        NodeFootprint<SpecInfo> specFootprint = this.launchContext.findSpecFootprint(spec);
        specFootprint.setStatus(ItemStatus.FAILED);
        if (!kind.isCleanupMethod()) {
            if (feature != null) {
                NodeFootprint<Object> footprint = feature.isParameterized() || feature.isReportIterations() ? this.launchContext.findIterationFootprint(iteration) : this.launchContext.findFeatureFootprint(feature);
                footprint.setStatus(ItemStatus.SKIPPED);
            } else {
                spec.getFeatures().forEach(f -> {
                    this.reportFeatureStart(specFootprint.getId(), (FeatureInfo)f);
                    NodeFootprint<FeatureInfo> ff = this.launchContext.findFeatureFootprint((FeatureInfo)f);
                    ff.setStatus(ItemStatus.SKIPPED);
                    this.reportFeatureFinish(ff);
                });
            }
        }
        ReportableItemFootprint<MethodInfo> fixtureFootprint = ownerFootprint.findUnpublishedFixtureFootprint(method);
        fixtureFootprint.setStatus(ItemStatus.FAILED);
        Throwable exception = error.getException();
        LoggerFactory.getLogger(((Method)error.getMethod().getReflection()).getDeclaringClass()).error(exception.getLocalizedMessage(), StackTraceUtils.deepSanitize((Throwable)exception));
    }

    protected void logError(@Nonnull ErrorInfo error) {
        Throwable exception = error.getException();
        LoggerFactory.getLogger(((Method)error.getMethod().getReflection()).getDeclaringClass()).error(exception.getLocalizedMessage(), exception);
    }

    public void reportError(@Nonnull ErrorInfo error) {
        MethodInfo method = error.getMethod();
        MethodKind kind = error.getMethod().getKind();
        if (MethodKind.FEATURE == kind || MethodKind.FEATURE_EXECUTION == kind) {
            Optional.ofNullable(this.launchContext.findFeatureFootprint(method.getFeature())).ifPresent(f -> f.setStatus(ItemStatus.FAILED));
            Optional.ofNullable(this.launchContext.getRuntimePointerForSpec((SpecInfo)method.getParent()).getCurrentIteration()).map(this.launchContext::findIterationFootprint).ifPresent(i -> i.setStatus(ItemStatus.FAILED));
            this.logError(error);
        } else if (MethodKind.ITERATION_EXECUTION == kind) {
            Optional.ofNullable(this.launchContext.findIterationFootprint(method.getIteration())).ifPresent(i -> i.setStatus(ItemStatus.FAILED));
            this.logError(error);
        } else if (MethodKind.SPEC_EXECUTION == kind) {
            Optional.ofNullable(this.launchContext.findSpecFootprint(error.getMethod().getFeature().getSpec())).ifPresent(s -> s.setStatus(ItemStatus.FAILED));
            this.logError(error);
        }
    }

    protected void trackSkippedSpec(SpecInfo spec) {
        this.registerSpec(spec);
        NodeFootprint<SpecInfo> specFootprint = this.launchContext.findSpecFootprint(spec);
        specFootprint.setStatus(ItemStatus.SKIPPED);
    }

    protected void trackSkippedFeature(FeatureInfo feature) {
        this.reportFeatureStart(this.launchContext.findSpecFootprint(feature.getSpec()).getId(), feature);
        NodeFootprint<FeatureInfo> footprint = this.launchContext.findFeatureFootprint(feature);
        footprint.setStatus(ItemStatus.SKIPPED);
    }

    @Nonnull
    private FinishExecutionRQ buildFinishExecutionRq() {
        FinishExecutionRQ rq = new FinishExecutionRQ();
        rq.setEndTime(Calendar.getInstance().getTime());
        return rq;
    }

    public void finishLaunch() {
        if (this.launchContext.tryFinishLaunch()) {
            Iterable<? extends NodeFootprint<SpecInfo>> unpublishedSpecFootprints = this.launchContext.findAllUnpublishedSpecFootprints();
            for (NodeFootprint<SpecInfo> nodeFootprint : unpublishedSpecFootprints) {
                this.reportTestItemFinish(nodeFootprint);
            }
            FinishExecutionRQ rq = this.buildFinishExecutionRq();
            ((Launch)this.launch.get()).finish(rq);
            this.launch.reset();
        }
    }

    void handleRpException(ReportPortalException rpException, String message) {
        this.handleException((Exception)((Object)rpException), message);
    }

    private void handleException(Exception exception, String message) {
        if (exception instanceof ReportPortalException) {
            if (LOGGER != null) {
                LOGGER.error(message, (Throwable)exception);
            } else {
                System.out.println(exception.getMessage());
            }
        } else {
            Throwables.throwIfUnchecked((Throwable)exception);
        }
    }

    protected NodeFootprint<? extends NodeInfo> findFixtureOwner(SpecInfo spec, FeatureInfo feature, IterationInfo iteration, MethodInfo fixture) {
        MethodKind kind = fixture.getKind();
        if (kind.isSpecScopedFixtureMethod()) {
            return this.launchContext.findSpecFootprint(spec);
        }
        if (!feature.isParameterized() && !feature.isReportIterations()) {
            return this.launchContext.findFeatureFootprint(feature);
        }
        return this.launchContext.findIterationFootprint(iteration);
    }

    protected void setFeatureAttributes(@Nonnull StartTestItemRQ rq, @Nonnull FeatureInfo featureInfo) {
        this.setAttributes(rq, featureInfo.getFeatureMethod().getReflection());
    }

    public void registerFeature(@Nonnull FeatureInfo feature) {
        if (!feature.isReportIterations()) {
            this.reportFeatureStart(this.launchContext.findSpecFootprint(feature.getSpec()).getId(), feature);
        } else if (!feature.isSkipped()) {
            this.launchContext.addRunningFeature(null, feature);
        }
    }

    public void publishSpecResult(@Nonnull SpecInfo spec) {
        NodeFootprint<SpecInfo> specFootprint = this.launchContext.findSpecFootprint(spec);
        this.reportTestItemFinish(specFootprint);
    }

    public void publishIterationResult(@Nonnull IterationInfo iteration) {
        FeatureInfo feature = iteration.getFeature();
        if (!feature.isReportIterations() && !feature.isParameterized()) {
            return;
        }
        NodeFootprint<IterationInfo> footprint = this.launchContext.findIterationFootprint(iteration);
        this.reportIterationFinish(footprint);
    }

    public void publishFixtureResult(SpecInfo spec, FeatureInfo feature, IterationInfo iteration, MethodInfo fixture) {
        NodeFootprint<? extends NodeInfo> ownerFootprint = this.findFixtureOwner(spec, feature, iteration, fixture);
        ReportableItemFootprint<MethodInfo> fixtureFootprint = ownerFootprint.findUnpublishedFixtureFootprint(fixture);
        this.reportTestItemFinish(fixtureFootprint);
    }

    public void beforeSpec(@Nonnull SpecInfo spec) {
        this.registerSpec(spec);
        for (MethodInfo fixture : spec.getAllFixtureMethods()) {
            fixture.addInterceptor((IMethodInterceptor)new FixtureInterceptor(this));
        }
    }

    public void beforeFeature(FeatureInfo feature) {
        this.registerFeature(feature);
    }

    public void beforeIteration(IterationInfo iteration) {
        this.registerIteration(iteration);
    }

    public void afterIteration(IterationInfo iteration) {
        this.publishIterationResult(iteration);
    }

    public void afterFeature(FeatureInfo feature) {
        this.publishFeatureResult(feature);
    }

    public void afterSpec(SpecInfo spec) {
        this.publishSpecResult(spec);
    }

    public void error(ErrorInfo error) {
        this.reportError(error);
    }

    public void featureSkipped(FeatureInfo feature) {
        this.trackSkippedFeature(feature);
        this.reportTestItemFinish(this.launchContext.findFeatureFootprint(feature));
    }

    public void specSkipped(SpecInfo spec) {
        this.trackSkippedSpec(spec);
        this.publishSpecResult(spec);
    }

    private String extractCodeRef(MethodInfo featureMethodInfo) {
        String iterationClassName = ((Method)featureMethodInfo.getReflection()).getDeclaringClass().getCanonicalName();
        String iterationMethodName = featureMethodInfo.getName();
        return iterationClassName + "." + iterationMethodName;
    }
}

