/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.spock;

import com.epam.reportportal.spock.ReportPortalSpockListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spockframework.runtime.IRunListener;
import org.spockframework.runtime.extension.IGlobalExtension;
import org.spockframework.runtime.model.SpecInfo;

public class ReportPortalSpockExtension
implements IGlobalExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportPortalSpockExtension.class);
    private final ReportPortalSpockListener reportingRunListener;

    public ReportPortalSpockExtension(ReportPortalSpockListener listener) {
        this.reportingRunListener = listener;
    }

    public ReportPortalSpockExtension() {
        this(new ReportPortalSpockListener());
    }

    public void start() {
        LOGGER.info("\"LAUNCHING\" the test run");
        this.reportingRunListener.startLaunch();
    }

    public void visitSpec(SpecInfo spec) {
        LOGGER.info("Visiting spec: " + spec.getName());
        spec.addListener((IRunListener)this.reportingRunListener);
    }

    public void stop() {
        LOGGER.info("\"LAUNCH\" completed");
        this.reportingRunListener.finishLaunch();
    }
}

