/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.spock;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.spockframework.runtime.model.BlockInfo;
import org.spockframework.runtime.model.BlockKind;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.SpecInfo;

final class NodeInfoUtils {
    static final String INHERITED_FIXTURE_NAME_TEMPLATE = "%s:%s";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String BLOCK_SPLITTER = ": ";
    private static final String CONJUNCTION_KEYWORD = "And";
    private static final Map<BlockKind, String> BLOCK_NAMES = new ConcurrentHashMap<BlockKind, String>();
    private static final Predicate<BlockInfo> SKIP_BLOCK_CONDITION = info -> Optional.ofNullable(info).filter(i -> BlockKind.WHERE.equals((Object)i.getKind())).map(i -> i.getTexts().stream().allMatch(StringUtils::isBlank)).orElse(Boolean.FALSE);

    private NodeInfoUtils() {
    }

    static String buildFeatureDescription(FeatureInfo featureInfo) {
        StringBuilder description = new StringBuilder();
        Iterator blocksIterator = featureInfo.getBlocks().iterator();
        while (blocksIterator.hasNext()) {
            boolean isLast;
            BlockInfo block = (BlockInfo)blocksIterator.next();
            boolean bl = isLast = !blocksIterator.hasNext();
            if (!SKIP_BLOCK_CONDITION.test(block)) {
                NodeInfoUtils.appendBlockInfo(description, block);
                if (isLast) continue;
                description.append(LINE_SEPARATOR);
                continue;
            }
            if (!isLast || description.length() <= 0) continue;
            int lastLineSeparatorIndex = description.lastIndexOf(LINE_SEPARATOR);
            description.delete(lastLineSeparatorIndex, description.length());
        }
        return description.toString();
    }

    static String buildIterationDescription(IterationInfo iterationInfo) {
        String featureDescription = NodeInfoUtils.buildFeatureDescription(iterationInfo.getFeature());
        return NodeInfoUtils.unrollIterationDescription(iterationInfo, featureDescription);
    }

    static String getFixtureDisplayName(MethodInfo methodInfo, boolean inherited) {
        if (methodInfo != null) {
            String fixtureName = methodInfo.getName();
            if (inherited) {
                String sourceSpecName = ((Class)((SpecInfo)methodInfo.getParent()).getReflection()).getSimpleName();
                return String.format(INHERITED_FIXTURE_NAME_TEMPLATE, sourceSpecName, fixtureName);
            }
            return fixtureName;
        }
        return "";
    }

    static String getSpecIdentifier(SpecInfo specInfo) {
        return specInfo != null && specInfo.getReflection() != null ? ((Class)specInfo.getReflection()).getName() : "";
    }

    private static String unrollIterationDescription(IterationInfo iterationInfo, String iterationDescription) {
        List parameterNames = iterationInfo.getFeature().getParameterNames();
        Object[] dataValues = iterationInfo.getDataValues();
        if (!parameterNames.isEmpty() && dataValues != null) {
            iterationDescription = iterationDescription + "\n" + IntStream.range(0, parameterNames.size()).mapToObj(i -> (String)parameterNames.get(i) + BLOCK_SPLITTER + dataValues[i]).collect(Collectors.joining("; "));
        }
        return iterationDescription;
    }

    private static void appendBlockInfo(StringBuilder featureDescription, BlockInfo block) {
        featureDescription.append(NodeInfoUtils.formatBlockKind(block.getKind())).append(BLOCK_SPLITTER);
        Iterator textsIterator = block.getTexts().iterator();
        if (textsIterator.hasNext()) {
            featureDescription.append((String)textsIterator.next());
        }
        while (textsIterator.hasNext()) {
            featureDescription.append(LINE_SEPARATOR).append(CONJUNCTION_KEYWORD).append(BLOCK_SPLITTER).append((String)textsIterator.next());
        }
    }

    private static String formatBlockKind(BlockKind blockKind) {
        return BLOCK_NAMES.computeIfAbsent(blockKind, b -> {
            String blockName = b.name();
            return blockName.charAt(0) + blockName.substring(1).toLowerCase(Locale.US);
        });
    }
}

