/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.spock;

import com.epam.reportportal.spock.FixtureFootprint;
import com.epam.reportportal.spock.ReportableItemFootprint;
import com.google.common.collect.Lists;
import io.reactivex.Maybe;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.NodeInfo;

abstract class NodeFootprint<T extends NodeInfo>
extends ReportableItemFootprint<T> {
    private static final int APPROXIMATE_CAPACITY = 4;
    private final List<ReportableItemFootprint<MethodInfo>> fixtures = Lists.newArrayListWithCapacity((int)4);

    NodeFootprint(T nodeInfo, Maybe<String> id) {
        super(nodeInfo, id);
    }

    ReportableItemFootprint<MethodInfo> findFixtureFootprint(MethodInfo fixture) {
        Predicate<ReportableItemFootprint<MethodInfo>> criteria = NodeFootprint.createFixtureMatchPredicate(fixture);
        return this.getFixtures().stream().filter(criteria).findAny().orElseThrow(NoSuchElementException::new);
    }

    ReportableItemFootprint<MethodInfo> findUnpublishedFixtureFootprint(MethodInfo fixture) {
        Predicate<ReportableItemFootprint<MethodInfo>> criteria = NodeFootprint.createFixtureMatchPredicate(fixture).and(IS_NOT_PUBLISHED);
        return this.getFixtures().stream().filter(criteria).findAny().orElseThrow(NoSuchElementException::new);
    }

    void addFixtureFootprint(FixtureFootprint footprint) {
        this.fixtures.add(footprint);
    }

    List<ReportableItemFootprint<MethodInfo>> getFixtures() {
        return Lists.newArrayList(this.fixtures);
    }

    private static Predicate<ReportableItemFootprint<MethodInfo>> createFixtureMatchPredicate(MethodInfo fixture) {
        return footprint -> footprint != null && fixture.equals(footprint.getItem());
    }
}

