/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.spock;

import com.epam.reportportal.spock.AbstractLaunchContext;
import com.epam.reportportal.spock.NodeFootprint;
import com.epam.reportportal.spock.NodeInfoUtils;
import com.epam.reportportal.spock.ReportableItemFootprint;
import com.google.common.collect.Lists;
import io.reactivex.Maybe;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.SpecInfo;

class LaunchContextImpl
extends AbstractLaunchContext {
    private final Map<String, Specification> specFootprintsRegistry = new ConcurrentHashMap<String, Specification>();
    private final Map<String, RuntimePointer> runtimePointersRegistry = new ConcurrentHashMap<String, RuntimePointer>();

    LaunchContextImpl() {
    }

    @Override
    public void addRunningSpec(Maybe<String> id, SpecInfo specInfo) {
        Specification specFootprint = new Specification(specInfo, id);
        String specIdentifier = NodeInfoUtils.getSpecIdentifier(specInfo);
        this.runtimePointersRegistry.put(specIdentifier, new RuntimePointer());
        this.specFootprintsRegistry.put(specIdentifier, specFootprint);
    }

    @Override
    public void addRunningFeature(@Nullable Maybe<String> id, @Nonnull FeatureInfo featureInfo) {
        SpecInfo specInfo = featureInfo.getSpec();
        Specification specFootprint = this.findSpecFootprint(featureInfo.getSpec());
        if (specFootprint != null) {
            this.getRuntimePointerForSpec(specInfo).setFeatureInfo(featureInfo);
            specFootprint.addRunningFeature(featureInfo, (Maybe<String>)id);
        }
    }

    @Override
    public void addRunningIteration(Maybe<String> id, IterationInfo iterationInfo) {
        Feature feature;
        SpecInfo specInfo = iterationInfo.getFeature().getSpec();
        Specification specification = this.findSpecFootprint(specInfo);
        if (specification != null && (feature = specification.getFeature(iterationInfo.getFeature())) != null) {
            this.getRuntimePointerForSpec(specInfo).setIterationInfo(iterationInfo);
            feature.addIteration(iterationInfo, (Maybe<String>)id);
        }
    }

    @Override
    @Nullable
    public NodeFootprint<FeatureInfo> findFeatureFootprint(FeatureInfo featureInfo) {
        return Optional.ofNullable(this.findSpecFootprint(featureInfo.getSpec())).map(s -> ((Specification)s).getFeature(featureInfo)).orElse(null);
    }

    @Override
    public NodeFootprint<IterationInfo> findIterationFootprint(IterationInfo iterationInfo) {
        Feature feature;
        Specification specFootprint = this.findSpecFootprint(iterationInfo.getFeature().getSpec());
        if (specFootprint != null && (feature = specFootprint.getFeature(iterationInfo.getFeature())) != null) {
            return feature.getIteration(iterationInfo);
        }
        return null;
    }

    public Iterable<Iteration> findIterationFootprints(FeatureInfo featureInfo) {
        return Optional.ofNullable(this.findSpecFootprint(featureInfo.getSpec())).map(s -> ((Specification)s).getFeature(featureInfo)).map(rec$ -> ((Feature)rec$).getAllTrackedIteration()).orElse(null);
    }

    public Specification findSpecFootprint(SpecInfo specInfo) {
        return this.findValueInRegistry(this.specFootprintsRegistry, specInfo);
    }

    public Iterable<Specification> findAllUnpublishedSpecFootprints() {
        return this.specFootprintsRegistry.values().stream().filter(ReportableItemFootprint.IS_NOT_PUBLISHED).collect(Collectors.toList());
    }

    @Override
    public RuntimePointer getRuntimePointerForSpec(SpecInfo specInfo) {
        return this.findValueInRegistry(this.runtimePointersRegistry, specInfo);
    }

    private <T> T findValueInRegistry(Map<String, T> registry, SpecInfo specInfo) {
        Object value = null;
        SpecInfo specToFind = specInfo;
        while (value == null && specToFind != null) {
            value = registry.get(NodeInfoUtils.getSpecIdentifier(specToFind));
            if ((specToFind = specToFind.getSubSpec()) == null) continue;
            value = null;
        }
        return value;
    }

    private static class RuntimePointer
    implements AbstractLaunchContext.IRuntimePointer {
        private FeatureInfo featureInfo;
        private IterationInfo iterationInfo;

        private RuntimePointer() {
        }

        private void setFeatureInfo(FeatureInfo featureInfo) {
            this.featureInfo = featureInfo;
        }

        private void setIterationInfo(IterationInfo iterationInfo) {
            this.iterationInfo = iterationInfo;
        }

        @Override
        public FeatureInfo getCurrentFeature() {
            return this.featureInfo;
        }

        @Override
        public IterationInfo getCurrentIteration() {
            return this.iterationInfo;
        }
    }

    private static class Iteration
    extends NodeFootprint<IterationInfo> {
        Iteration(IterationInfo nodeInfo, Maybe<String> id) {
            super(nodeInfo, id);
        }

        @Override
        public boolean hasDescendants() {
            return false;
        }
    }

    private static class Feature
    extends NodeFootprint<FeatureInfo> {
        private List<Iteration> iterations;

        Feature(FeatureInfo featureInfo, Maybe<String> id) {
            super(featureInfo, id);
        }

        @Override
        boolean hasDescendants() {
            return true;
        }

        private List<Iteration> getAllTrackedIteration() {
            if (this.iterations == null) {
                this.iterations = Lists.newArrayList();
            }
            return this.iterations;
        }

        private Iteration getIteration(IterationInfo iterationInfo) {
            return this.getAllTrackedIteration().stream().filter(Objects::nonNull).filter(input -> iterationInfo.equals(input.getItem())).findAny().orElse(null);
        }

        private void addIteration(IterationInfo iterationInfo, Maybe<String> id) {
            this.getAllTrackedIteration().add(new Iteration(iterationInfo, id));
        }
    }

    private static class Specification
    extends NodeFootprint<SpecInfo> {
        private List<Feature> features;

        Specification(SpecInfo nodeInfo, Maybe<String> id) {
            super(nodeInfo, id);
        }

        @Override
        public boolean hasDescendants() {
            return true;
        }

        private void addRunningFeature(FeatureInfo featureInfo, Maybe<String> id) {
            this.getAllTrackedFeatures().add(new Feature(featureInfo, id));
        }

        @Nullable
        private Feature getFeature(FeatureInfo featureInfo) {
            return this.getAllTrackedFeatures().stream().filter(input -> input != null && featureInfo.equals(input.getItem())).findAny().orElse(null);
        }

        private List<Feature> getAllTrackedFeatures() {
            if (this.features == null) {
                this.features = Lists.newArrayList();
            }
            return this.features;
        }
    }
}

