/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.spock;

import com.epam.reportportal.spock.ReportPortalSpockListener;
import javax.annotation.Nonnull;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.model.ErrorInfo;

class FixtureInterceptor
implements IMethodInterceptor {
    private final ReportPortalSpockListener spockService;

    FixtureInterceptor(@Nonnull ReportPortalSpockListener spockService) {
        this.spockService = spockService;
    }

    public void intercept(IMethodInvocation invocation) throws Throwable {
        this.spockService.registerFixture(invocation.getSpec(), invocation.getFeature(), invocation.getIteration(), invocation.getMethod());
        Throwable exception = null;
        try {
            invocation.proceed();
        }
        catch (Throwable ex) {
            exception = ex;
            this.spockService.reportFixtureError(invocation.getSpec(), invocation.getFeature(), invocation.getIteration(), new ErrorInfo(invocation.getMethod(), ex));
        }
        this.spockService.publishFixtureResult(invocation.getSpec(), invocation.getFeature(), invocation.getIteration(), invocation.getMethod());
        if (exception != null) {
            throw exception;
        }
    }
}

