/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.spock;

import com.epam.reportportal.spock.NodeFootprint;
import io.reactivex.Maybe;
import java.util.concurrent.atomic.AtomicReference;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.SpecInfo;

abstract class AbstractLaunchContext {
    private Maybe<String> launchId;
    private final AtomicReference<Boolean> launchInProgress = new AtomicReference();

    AbstractLaunchContext() {
    }

    Maybe<String> getLaunchId() {
        return this.launchId;
    }

    void setLaunchId(Maybe<String> launchId) {
        this.launchId = launchId;
    }

    boolean tryStartLaunch() {
        return this.launchInProgress.compareAndSet(null, Boolean.TRUE);
    }

    boolean tryFinishLaunch() {
        return this.launchInProgress.compareAndSet(Boolean.TRUE, Boolean.FALSE);
    }

    boolean isSpecRegistered(SpecInfo specInfo) {
        return this.findSpecFootprint(specInfo) != null;
    }

    abstract void addRunningSpec(Maybe<String> var1, SpecInfo var2);

    abstract void addRunningFeature(Maybe<String> var1, FeatureInfo var2);

    abstract void addRunningIteration(Maybe<String> var1, IterationInfo var2);

    public abstract NodeFootprint<FeatureInfo> findFeatureFootprint(FeatureInfo var1);

    abstract NodeFootprint<IterationInfo> findIterationFootprint(IterationInfo var1);

    abstract Iterable<? extends NodeFootprint<IterationInfo>> findIterationFootprints(FeatureInfo var1);

    abstract NodeFootprint<SpecInfo> findSpecFootprint(SpecInfo var1);

    abstract Iterable<? extends NodeFootprint<SpecInfo>> findAllUnpublishedSpecFootprints();

    abstract IRuntimePointer getRuntimePointerForSpec(SpecInfo var1);

    static interface IRuntimePointer {
        public FeatureInfo getCurrentFeature();

        public IterationInfo getCurrentIteration();
    }
}

