/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.treecomparing;

import com.epam.healenium.treecomparing.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NodeBuilder {
    private static final Set<String> MAIN_ATTRIBUTED = new HashSet<String>(Arrays.asList("id", "class"));
    private static final Set<String> MAIN_ATTRIBUTED2 = new HashSet<String>(Arrays.asList("resource-id", "content-desc", "class"));
    private String tag;
    private String id = "";
    private Set<String> classes = Collections.emptySet();
    private Integer index = 0;
    private Map<String, String> otherAttributes = Collections.emptyMap();
    private List<String> content = new ArrayList<String>();
    private List<Node> children = new ArrayList<Node>();

    public NodeBuilder setTag(String tag) {
        this.tag = tag;
        return this;
    }

    public NodeBuilder setIndex(int index) {
        this.index = index;
        return this;
    }

    public NodeBuilder setAttributes(Map<String, String> attributes) {
        this.id = attributes.getOrDefault("id", "");
        this.classes = Optional.ofNullable(attributes.get("class")).map(s -> s.split(" ")).map(Arrays::stream).orElse(Stream.empty()).map(String::trim).filter(next -> !next.isEmpty()).collect(Collectors.toSet());
        this.otherAttributes = attributes.entrySet().stream().filter(s -> !MAIN_ATTRIBUTED.contains(s.getKey()) && !((String)s.getKey()).trim().isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return this;
    }

    public NodeBuilder setMobileAttributes(Map<String, String> attributes) {
        this.id = attributes.getOrDefault("resource-id", "");
        this.classes = Optional.ofNullable(attributes.get("content-desc")).map(s -> s.split(" ")).map(Arrays::stream).orElse(Stream.empty()).map(String::trim).filter(next -> !next.isEmpty()).collect(Collectors.toSet());
        this.otherAttributes = attributes.entrySet().stream().filter(s -> !MAIN_ATTRIBUTED2.contains(s.getKey()) && !((String)s.getKey()).trim().isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return this;
    }

    public NodeBuilder setId(String id) {
        this.id = id;
        return this;
    }

    public NodeBuilder setClasses(Set<String> classes) {
        this.classes = classes;
        return this;
    }

    public NodeBuilder setOtherAttributes(Map<String, String> otherAttributes) {
        this.otherAttributes = otherAttributes;
        return this;
    }

    public NodeBuilder addChild(Node child) {
        this.children.add(child);
        return this;
    }

    public NodeBuilder addChildren(List<Node> children) {
        this.children.addAll(children);
        return this;
    }

    public NodeBuilder setChildren(List<Node> children) {
        this.children = children;
        return this;
    }

    public NodeBuilder addContent(String content) {
        this.content.add(content);
        return this;
    }

    public NodeBuilder setContent(List<String> content) {
        this.content = content;
        return this;
    }

    public NodeBuilder copy() {
        NodeBuilder copy = new NodeBuilder();
        copy.tag = this.tag;
        copy.id = this.id;
        copy.classes = new HashSet<String>(this.classes);
        copy.index = this.index;
        copy.otherAttributes = new HashMap<String, String>(this.otherAttributes);
        copy.content = new ArrayList<String>(this.content);
        copy.children = new ArrayList<Node>(this.children);
        return copy;
    }

    public Node build() {
        String fullContent = String.join((CharSequence)System.lineSeparator(), this.content);
        Node node = new Node(this.tag, this.id, this.classes, this.index, this.otherAttributes, this.children, fullContent);
        for (Node child : node.getChildren()) {
            child.setParent(node);
        }
        return node;
    }
}

