/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff;

import com.dyuproject.protostuff.B64Code;
import com.dyuproject.protostuff.IntSerializer;
import com.dyuproject.protostuff.LinkedBuffer;
import com.dyuproject.protostuff.StreamedStringSerializer;
import com.dyuproject.protostuff.StringSerializer;
import com.dyuproject.protostuff.WriteSession;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum WriteSink {
    BUFFERED{

        public LinkedBuffer drain(WriteSession session, LinkedBuffer lb) throws IOException {
            return new LinkedBuffer(session.nextBufferSize, lb);
        }

        public LinkedBuffer writeByteArrayB64(byte[] value, int offset, int valueLen, WriteSession session, LinkedBuffer lb) throws IOException {
            return B64Code.encode(value, offset, valueLen, session, lb);
        }

        public LinkedBuffer writeByteArray(byte[] value, int offset, int valueLen, WriteSession session, LinkedBuffer lb) throws IOException {
            if (valueLen == 0) {
                return lb;
            }
            session.size += valueLen;
            int available = lb.buffer.length - lb.offset;
            if (valueLen > available) {
                if (available + session.nextBufferSize < valueLen) {
                    if (available == 0) {
                        return new LinkedBuffer(session.nextBufferSize, new LinkedBuffer(value, offset, offset + valueLen, lb));
                    }
                    return new LinkedBuffer(lb, new LinkedBuffer(value, offset, offset + valueLen, lb));
                }
                System.arraycopy(value, offset, lb.buffer, lb.offset, available);
                lb.offset += available;
                lb = new LinkedBuffer(session.nextBufferSize, lb);
                int leftover = valueLen - available;
                System.arraycopy(value, offset + available, lb.buffer, 0, leftover);
                lb.offset += leftover;
                return lb;
            }
            System.arraycopy(value, offset, lb.buffer, lb.offset, valueLen);
            lb.offset += valueLen;
            return lb;
        }

        public LinkedBuffer writeByte(byte value, WriteSession session, LinkedBuffer lb) throws IOException {
            ++session.size;
            if (lb.offset == lb.buffer.length) {
                lb = new LinkedBuffer(session.nextBufferSize, lb);
            }
            lb.buffer[lb.offset++] = value;
            return lb;
        }

        public LinkedBuffer writeInt32(int value, WriteSession session, LinkedBuffer lb) throws IOException {
            session.size += 4;
            if (lb.offset + 4 > lb.buffer.length) {
                lb = new LinkedBuffer(session.nextBufferSize, lb);
            }
            IntSerializer.writeInt32(value, lb.buffer, lb.offset);
            lb.offset += 4;
            return lb;
        }

        public LinkedBuffer writeInt64(long value, WriteSession session, LinkedBuffer lb) throws IOException {
            session.size += 8;
            if (lb.offset + 8 > lb.buffer.length) {
                lb = new LinkedBuffer(session.nextBufferSize, lb);
            }
            IntSerializer.writeInt64(value, lb.buffer, lb.offset);
            lb.offset += 8;
            return lb;
        }

        public LinkedBuffer writeInt32LE(int value, WriteSession session, LinkedBuffer lb) throws IOException {
            session.size += 4;
            if (lb.offset + 4 > lb.buffer.length) {
                lb = new LinkedBuffer(session.nextBufferSize, lb);
            }
            IntSerializer.writeInt32LE(value, lb.buffer, lb.offset);
            lb.offset += 4;
            return lb;
        }

        public LinkedBuffer writeInt64LE(long value, WriteSession session, LinkedBuffer lb) throws IOException {
            session.size += 8;
            if (lb.offset + 8 > lb.buffer.length) {
                lb = new LinkedBuffer(session.nextBufferSize, lb);
            }
            IntSerializer.writeInt64LE(value, lb.buffer, lb.offset);
            lb.offset += 8;
            return lb;
        }

        public LinkedBuffer writeVarInt32(int value, WriteSession session, LinkedBuffer lb) throws IOException {
            while (true) {
                ++session.size;
                if (lb.offset == lb.buffer.length) {
                    lb = new LinkedBuffer(session.nextBufferSize, lb);
                }
                if ((value & 0xFFFFFF80) == 0) {
                    lb.buffer[lb.offset++] = (byte)value;
                    return lb;
                }
                lb.buffer[lb.offset++] = (byte)(value & 0x7F | 0x80);
                value >>>= 7;
            }
        }

        public LinkedBuffer writeVarInt64(long value, WriteSession session, LinkedBuffer lb) throws IOException {
            while (true) {
                ++session.size;
                if (lb.offset == lb.buffer.length) {
                    lb = new LinkedBuffer(session.nextBufferSize, lb);
                }
                if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    lb.buffer[lb.offset++] = (byte)value;
                    return lb;
                }
                lb.buffer[lb.offset++] = (byte)((int)value & 0x7F | 0x80);
                value >>>= 7;
            }
        }

        public LinkedBuffer writeStrFromInt(int value, WriteSession session, LinkedBuffer lb) throws IOException {
            return StringSerializer.writeInt(value, session, lb);
        }

        public LinkedBuffer writeStrFromLong(long value, WriteSession session, LinkedBuffer lb) throws IOException {
            return StringSerializer.writeLong(value, session, lb);
        }

        public LinkedBuffer writeStrFromFloat(float value, WriteSession session, LinkedBuffer lb) throws IOException {
            return StringSerializer.writeFloat(value, session, lb);
        }

        public LinkedBuffer writeStrFromDouble(double value, WriteSession session, LinkedBuffer lb) throws IOException {
            return StringSerializer.writeDouble(value, session, lb);
        }

        public LinkedBuffer writeStrAscii(String value, WriteSession session, LinkedBuffer lb) throws IOException {
            return StringSerializer.writeAscii(value, session, lb);
        }

        public LinkedBuffer writeStrUTF8(String value, WriteSession session, LinkedBuffer lb) throws IOException {
            return StringSerializer.writeUTF8(value, session, lb);
        }

        public LinkedBuffer writeStrUTF8VarDelimited(String value, WriteSession session, LinkedBuffer lb) throws IOException {
            return StringSerializer.writeUTF8VarDelimited(value, session, lb);
        }

        public LinkedBuffer writeStrUTF8FixedDelimited(String value, boolean littleEndian, WriteSession session, LinkedBuffer lb) throws IOException {
            return StringSerializer.writeUTF8FixedDelimited(value, littleEndian, session, lb);
        }
    }
    ,
    STREAMED{

        public LinkedBuffer drain(WriteSession session, LinkedBuffer lb) throws IOException {
            session.out.write(lb.buffer, lb.start, lb.offset - lb.start);
            lb.offset = lb.start;
            return lb;
        }

        public LinkedBuffer writeByteArrayB64(byte[] value, int offset, int valueLen, WriteSession session, LinkedBuffer lb) throws IOException {
            return B64Code.encode(value, offset, valueLen, session, session.out, lb);
        }

        public LinkedBuffer writeByteArray(byte[] value, int offset, int valueLen, WriteSession session, LinkedBuffer lb) throws IOException {
            if (valueLen == 0) {
                return lb;
            }
            session.size += valueLen;
            if (lb.offset + valueLen > lb.buffer.length) {
                session.out.write(lb.buffer, lb.start, lb.offset - lb.start);
                lb.offset = lb.start;
                session.out.write(value, offset, valueLen);
                return lb;
            }
            System.arraycopy(value, offset, lb.buffer, lb.offset, valueLen);
            lb.offset += valueLen;
            return lb;
        }

        public LinkedBuffer writeByte(byte value, WriteSession session, LinkedBuffer lb) throws IOException {
            ++session.size;
            if (lb.offset == lb.buffer.length) {
                session.out.write(lb.buffer, lb.start, lb.offset - lb.start);
                lb.offset = lb.start;
            }
            lb.buffer[lb.offset++] = value;
            return lb;
        }

        public LinkedBuffer writeInt32(int value, WriteSession session, LinkedBuffer lb) throws IOException {
            session.size += 4;
            if (lb.offset + 4 > lb.buffer.length) {
                session.out.write(lb.buffer, lb.start, lb.offset - lb.start);
                lb.offset = lb.start;
            }
            IntSerializer.writeInt32(value, lb.buffer, lb.offset);
            lb.offset += 4;
            return lb;
        }

        public LinkedBuffer writeInt64(long value, WriteSession session, LinkedBuffer lb) throws IOException {
            session.size += 8;
            if (lb.offset + 8 > lb.buffer.length) {
                session.out.write(lb.buffer, lb.start, lb.offset - lb.start);
                lb.offset = lb.start;
            }
            IntSerializer.writeInt64(value, lb.buffer, lb.offset);
            lb.offset += 8;
            return lb;
        }

        public LinkedBuffer writeInt32LE(int value, WriteSession session, LinkedBuffer lb) throws IOException {
            session.size += 4;
            if (lb.offset + 4 > lb.buffer.length) {
                session.out.write(lb.buffer, lb.start, lb.offset - lb.start);
                lb.offset = lb.start;
            }
            IntSerializer.writeInt32LE(value, lb.buffer, lb.offset);
            lb.offset += 4;
            return lb;
        }

        public LinkedBuffer writeInt64LE(long value, WriteSession session, LinkedBuffer lb) throws IOException {
            session.size += 8;
            if (lb.offset + 8 > lb.buffer.length) {
                session.out.write(lb.buffer, lb.start, lb.offset - lb.start);
                lb.offset = lb.start;
            }
            IntSerializer.writeInt64LE(value, lb.buffer, lb.offset);
            lb.offset += 8;
            return lb;
        }

        public LinkedBuffer writeVarInt32(int value, WriteSession session, LinkedBuffer lb) throws IOException {
            while (true) {
                ++session.size;
                if (lb.offset == lb.buffer.length) {
                    session.out.write(lb.buffer, lb.start, lb.offset - lb.start);
                    lb.offset = lb.start;
                }
                if ((value & 0xFFFFFF80) == 0) {
                    lb.buffer[lb.offset++] = (byte)value;
                    return lb;
                }
                lb.buffer[lb.offset++] = (byte)(value & 0x7F | 0x80);
                value >>>= 7;
            }
        }

        public LinkedBuffer writeVarInt64(long value, WriteSession session, LinkedBuffer lb) throws IOException {
            while (true) {
                ++session.size;
                if (lb.offset == lb.buffer.length) {
                    session.out.write(lb.buffer, lb.start, lb.offset - lb.start);
                    lb.offset = lb.start;
                }
                if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    lb.buffer[lb.offset++] = (byte)value;
                    return lb;
                }
                lb.buffer[lb.offset++] = (byte)((int)value & 0x7F | 0x80);
                value >>>= 7;
            }
        }

        public LinkedBuffer writeStrFromInt(int value, WriteSession session, LinkedBuffer lb) throws IOException {
            return StreamedStringSerializer.writeInt(value, session, session.out, lb);
        }

        public LinkedBuffer writeStrFromLong(long value, WriteSession session, LinkedBuffer lb) throws IOException {
            return StreamedStringSerializer.writeLong(value, session, session.out, lb);
        }

        public LinkedBuffer writeStrFromFloat(float value, WriteSession session, LinkedBuffer lb) throws IOException {
            return StreamedStringSerializer.writeFloat(value, session, session.out, lb);
        }

        public LinkedBuffer writeStrFromDouble(double value, WriteSession session, LinkedBuffer lb) throws IOException {
            return StreamedStringSerializer.writeDouble(value, session, session.out, lb);
        }

        public LinkedBuffer writeStrAscii(String value, WriteSession session, LinkedBuffer lb) throws IOException {
            return StreamedStringSerializer.writeAscii(value, session, session.out, lb);
        }

        public LinkedBuffer writeStrUTF8(String value, WriteSession session, LinkedBuffer lb) throws IOException {
            return StreamedStringSerializer.writeUTF8(value, session, session.out, lb);
        }

        public LinkedBuffer writeStrUTF8VarDelimited(String value, WriteSession session, LinkedBuffer lb) throws IOException {
            return StreamedStringSerializer.writeUTF8VarDelimited(value, session, session.out, lb);
        }

        public LinkedBuffer writeStrUTF8FixedDelimited(String value, boolean littleEndian, WriteSession session, LinkedBuffer lb) throws IOException {
            return StreamedStringSerializer.writeUTF8FixedDelimited(value, littleEndian, session, session.out, lb);
        }
    };


    public abstract LinkedBuffer drain(WriteSession var1, LinkedBuffer var2) throws IOException;

    public final LinkedBuffer writeByteArrayB64(byte[] value, WriteSession session, LinkedBuffer lb) throws IOException {
        return this.writeByteArrayB64(value, 0, value.length, session, lb);
    }

    public abstract LinkedBuffer writeByteArrayB64(byte[] var1, int var2, int var3, WriteSession var4, LinkedBuffer var5) throws IOException;

    public final LinkedBuffer writeByteArray(byte[] value, WriteSession session, LinkedBuffer lb) throws IOException {
        return this.writeByteArray(value, 0, value.length, session, lb);
    }

    public abstract LinkedBuffer writeByteArray(byte[] var1, int var2, int var3, WriteSession var4, LinkedBuffer var5) throws IOException;

    public abstract LinkedBuffer writeByte(byte var1, WriteSession var2, LinkedBuffer var3) throws IOException;

    public abstract LinkedBuffer writeInt32(int var1, WriteSession var2, LinkedBuffer var3) throws IOException;

    public abstract LinkedBuffer writeInt64(long var1, WriteSession var3, LinkedBuffer var4) throws IOException;

    public final LinkedBuffer writeFloat(float value, WriteSession session, LinkedBuffer lb) throws IOException {
        return this.writeInt32(Float.floatToIntBits(value), session, lb);
    }

    public final LinkedBuffer writeDouble(double value, WriteSession session, LinkedBuffer lb) throws IOException {
        return this.writeInt64(Double.doubleToLongBits(value), session, lb);
    }

    public abstract LinkedBuffer writeInt32LE(int var1, WriteSession var2, LinkedBuffer var3) throws IOException;

    public abstract LinkedBuffer writeInt64LE(long var1, WriteSession var3, LinkedBuffer var4) throws IOException;

    public final LinkedBuffer writeFloatLE(float value, WriteSession session, LinkedBuffer lb) throws IOException {
        return this.writeInt32LE(Float.floatToIntBits(value), session, lb);
    }

    public final LinkedBuffer writeDoubleLE(double value, WriteSession session, LinkedBuffer lb) throws IOException {
        return this.writeInt64LE(Double.doubleToLongBits(value), session, lb);
    }

    public abstract LinkedBuffer writeVarInt32(int var1, WriteSession var2, LinkedBuffer var3) throws IOException;

    public abstract LinkedBuffer writeVarInt64(long var1, WriteSession var3, LinkedBuffer var4) throws IOException;

    public abstract LinkedBuffer writeStrFromInt(int var1, WriteSession var2, LinkedBuffer var3) throws IOException;

    public abstract LinkedBuffer writeStrFromLong(long var1, WriteSession var3, LinkedBuffer var4) throws IOException;

    public abstract LinkedBuffer writeStrFromFloat(float var1, WriteSession var2, LinkedBuffer var3) throws IOException;

    public abstract LinkedBuffer writeStrFromDouble(double var1, WriteSession var3, LinkedBuffer var4) throws IOException;

    public abstract LinkedBuffer writeStrAscii(String var1, WriteSession var2, LinkedBuffer var3) throws IOException;

    public abstract LinkedBuffer writeStrUTF8(String var1, WriteSession var2, LinkedBuffer var3) throws IOException;

    public abstract LinkedBuffer writeStrUTF8VarDelimited(String var1, WriteSession var2, LinkedBuffer var3) throws IOException;

    public abstract LinkedBuffer writeStrUTF8FixedDelimited(String var1, boolean var2, WriteSession var3, LinkedBuffer var4) throws IOException;
}

