/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android;

import com.dynatrace.tools.android.DynatracePlugin;
import com.dynatrace.tools.android.InstrumentationPlugin;
import com.dynatrace.tools.android.LegacyAgpVersionVerifier;
import com.dynatrace.tools.android.util.Utils;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.internal.reflect.Instantiator;

public class DynatraceModulePlugin
implements Plugin<Project> {
    private final Instantiator instantiator;

    @Inject
    public DynatraceModulePlugin(Instantiator instantiator) {
        this.instantiator = instantiator;
    }

    public void apply(Project project) {
        Utils.verifyGradleVersion();
        LegacyAgpVersionVerifier.verifyLegacyAgpVersion();
        boolean isApplicationModule = project.getPlugins().hasPlugin("com.android.application");
        if (!isApplicationModule && !project.getPlugins().hasPlugin("com.android.dynamic-feature")) {
            throw new GradleException("The Dynatrace Android Gradle Plugin can only be applied to Android application or dynamic-feature modules");
        }
        if (Utils.isOldPluginApplied()) {
            throw new GradleException("Your build script classpath also contains an older version of the Dynatrace Android Gradle plugin. You must remove the old version from your build script classpath.");
        }
        if (project.getRootProject().getPlugins().hasPlugin("com.dynatrace.instrumentation")) {
            throw new GradleException("It is not possible to use both Dynatrace plugins ('com.dynatrace.instrumentation' and 'com.dynatrace.instrumentation.module') for the same module.");
        }
        DynatracePlugin.createExtension(project, this.instantiator);
        project.apply(objectConfigurationAction -> objectConfigurationAction.plugin(InstrumentationPlugin.class));
    }
}

