/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.compose.transformation;

import com.dynatrace.android.instrumentation.sensor.method.MethodTransformation;
import com.dynatrace.android.instrumentation.shared.TransformerUtils;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ComposeSliderTransformation
implements MethodTransformation {
    private static final int COMPOSER_INDEX = 9;
    private static final int ON_VALUE_FINISHED_CALLBACK_INDEX = 6;
    private final boolean isSemantics;

    public ComposeSliderTransformation(boolean isSemantics) {
        this.isSemantics = isSemantics;
    }

    @Override
    public void transformMethod(MethodNode methodNode, int startParameterIndex) {
        this.removeNullableInstructionForFinishedCallback(methodNode);
        TransformerUtils.insertAtMethodStart(methodNode, instructions -> {
            MethodInsnNode sliderValueFinishedCallback = new MethodInsnNode(184, "com/dynatrace/android/compose/slider/SliderRememberKt", "rememberSliderValueFinishedCallback", "(Lkotlin/jvm/functions/Function1;Landroidx/compose/ui/Modifier;Lkotlin/jvm/functions/Function0;ZLandroidx/compose/runtime/Composer;II)Lcom/dynatrace/android/compose/slider/SliderValueFinishedCallback;", false);
            MethodInsnNode sliderOnValueChangeCallback = new MethodInsnNode(184, "com/dynatrace/android/compose/slider/SliderRememberKt", "rememberSliderOnValueChangeCallback", "(Lkotlin/jvm/functions/Function1;Lcom/dynatrace/android/compose/slider/SliderValueFinishedCallback;Landroidx/compose/runtime/Composer;I)Lcom/dynatrace/android/compose/slider/SliderValueChangedCallback;", false);
            this.setInstructions(instructions, 9, sliderValueFinishedCallback, sliderOnValueChangeCallback);
        });
    }

    public void removeNullableInstructionForFinishedCallback(MethodNode methodNode) {
        InsnList instr = methodNode.instructions;
        for (AbstractInsnNode insnNode : instr) {
            AbstractInsnNode next;
            if (!(insnNode instanceof InsnNode) || insnNode.getOpcode() != 1 || !((next = insnNode.getNext()) instanceof VarInsnNode) || next.getOpcode() != 58 || ((VarInsnNode)next).var != 6) continue;
            instr.set(next, (AbstractInsnNode)new InsnNode(87));
        }
    }

    public InsnList setInstructions(InsnList instructions, int indexOfComposer, MethodInsnNode rememberValueFinishedCallback, MethodInsnNode rememberOnValueChangeCallback) {
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 6));
        if (this.isSemantics) {
            instructions.add((AbstractInsnNode)new InsnNode(4));
        } else {
            instructions.add((AbstractInsnNode)new InsnNode(3));
        }
        instructions.add((AbstractInsnNode)new VarInsnNode(25, indexOfComposer));
        instructions.add((AbstractInsnNode)new InsnNode(3));
        instructions.add((AbstractInsnNode)new InsnNode(3));
        instructions.add((AbstractInsnNode)rememberValueFinishedCallback);
        instructions.add((AbstractInsnNode)new VarInsnNode(58, 6));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 6));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, indexOfComposer));
        instructions.add((AbstractInsnNode)new InsnNode(3));
        instructions.add((AbstractInsnNode)rememberOnValueChangeCallback);
        instructions.add((AbstractInsnNode)new VarInsnNode(58, 1));
        return instructions;
    }
}

