/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.compose.sensor;

import com.dynatrace.android.instrumentation.ClassInfo;
import com.dynatrace.android.instrumentation.MethodInfo;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.MethodTransformation;
import com.dynatrace.android.instrumentation.shared.TransformerUtils;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class BasicTextSensor
implements SensorGroup<MethodSensor> {
    private static final String BASIC_TEXT_SOURCE = "androidx.compose.foundation.text.BasicTextKt";
    private static final String BASIC_TEXT_METHOD_NAME_1 = "BasicText-RWo7tUw";
    private static final String BASIC_TEXT_METHOD_DESCRIPTION_1 = "(Landroidx/compose/ui/text/AnnotatedString;Landroidx/compose/ui/Modifier;Landroidx/compose/ui/text/TextStyle;Lkotlin/jvm/functions/Function1;IZIILjava/util/Map;Landroidx/compose/ui/graphics/ColorProducer;Landroidx/compose/runtime/Composer;II)V";
    private static final String BASIC_TEXT_METHOD_NAME_2 = "BasicText-VhcvRP8";
    private static final String BASIC_TEXT_METHOD_DESCRIPTION_2 = "(Landroidx/compose/ui/text/AnnotatedString;Landroidx/compose/ui/Modifier;Landroidx/compose/ui/text/TextStyle;Lkotlin/jvm/functions/Function1;IZIILjava/util/Map;Landroidx/compose/runtime/Composer;II)V";
    private static final String BASIC_TEXT_METHOD_DESCRIPTION_3 = "(Ljava/lang/String;Landroidx/compose/ui/Modifier;Landroidx/compose/ui/text/TextStyle;Lkotlin/jvm/functions/Function1;IZIILandroidx/compose/ui/graphics/ColorProducer;Landroidx/compose/runtime/Composer;II)V";
    private static final String BASIC_TEXT_MODIFIER_NAME = "com/dynatrace/agent/userinteraction/model/DTBasicTextModifier";

    @Override
    public boolean matchClass(ClassInfo classInfo) {
        return BASIC_TEXT_SOURCE.equals(classInfo.getName());
    }

    @Override
    public List<MethodSensor> getSensors() {
        return List.of(this.generateBasicTextSensorWithAnnotation(BASIC_TEXT_METHOD_NAME_1, BASIC_TEXT_METHOD_DESCRIPTION_1), this.generateBasicTextSensorWithAnnotation(BASIC_TEXT_METHOD_NAME_2, BASIC_TEXT_METHOD_DESCRIPTION_2), this.generateBasicTextSensor(BASIC_TEXT_METHOD_NAME_2, BASIC_TEXT_METHOD_DESCRIPTION_3));
    }

    private MethodSensor generateBasicTextSensorWithAnnotation(String methodName, String methodDescription) {
        MethodInfo methodInfo = new MethodInfo(methodName, methodDescription, 17, null, new ArrayList<String>());
        MethodTransformation scrollableModifierTransformation = (methodNode, startParameterIndex) -> TransformerUtils.insertAtMethodStart(methodNode, list -> {
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)new TypeInsnNode(187, BASIC_TEXT_MODIFIER_NAME));
            list.add((AbstractInsnNode)new InsnNode(89));
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new MethodInsnNode(183, BASIC_TEXT_MODIFIER_NAME, "<init>", "(Landroidx/compose/ui/text/AnnotatedString;)V", false));
            list.add((AbstractInsnNode)new MethodInsnNode(185, "androidx/compose/ui/Modifier", "then", "(Landroidx/compose/ui/Modifier;)Landroidx/compose/ui/Modifier;", true));
            list.add((AbstractInsnNode)new VarInsnNode(58, 1));
        });
        return new MethodSensorImpl(methodInfo, scrollableModifierTransformation);
    }

    private MethodSensor generateBasicTextSensor(String methodName, String methodDescription) {
        MethodInfo methodInfo = new MethodInfo(methodName, methodDescription, 17, null, new ArrayList<String>());
        MethodTransformation scrollableModifierTransformation = (methodNode, startParameterIndex) -> TransformerUtils.insertAtMethodStart(methodNode, list -> {
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)new TypeInsnNode(187, BASIC_TEXT_MODIFIER_NAME));
            list.add((AbstractInsnNode)new InsnNode(89));
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new MethodInsnNode(183, BASIC_TEXT_MODIFIER_NAME, "<init>", "(Ljava/lang/String;)V", false));
            list.add((AbstractInsnNode)new MethodInsnNode(185, "androidx/compose/ui/Modifier", "then", "(Landroidx/compose/ui/Modifier;)Landroidx/compose/ui/Modifier;", true));
            list.add((AbstractInsnNode)new VarInsnNode(58, 1));
        });
        return new MethodSensorImpl(methodInfo, scrollableModifierTransformation);
    }
}

