/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android.dependencies;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComposeArtifactVerifier
implements Consumer<ResolvedComponentResult> {
    private static final Logger logger = LoggerFactory.getLogger((String)"ComposeArtifactVerifier");
    private static final String MAJOR_VERSION = "1";
    private static final int MINOR_LOWER_BORDER = 3;
    private static final int MINOR_UPPER_BORDER = 8;
    private final List<String> artifacts = new ArrayList<String>();

    public ComposeArtifactVerifier() {
        this.artifacts.add("androidx.compose.foundation:foundation");
        this.artifacts.add("androidx.compose.ui:ui");
        this.artifacts.add("androidx.compose.material:material");
    }

    @Override
    public void accept(ResolvedComponentResult resolvedComponentResult) {
        ModuleVersionIdentifier moduleVersion = resolvedComponentResult.getModuleVersion();
        if (moduleVersion == null) {
            return;
        }
        String combinedName = moduleVersion.getGroup() + ":" + moduleVersion.getName();
        if (this.artifacts.contains(combinedName)) {
            this.verify(combinedName, moduleVersion.getVersion());
        }
    }

    private void verify(String artifactName, String version) {
        Pattern versionPattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(?:-([a-zA-Z0-9]+))?");
        Matcher matcher = versionPattern.matcher(version);
        if (!matcher.matches()) {
            throw new GradleException("Dynatrace Android Gradle plugin detected an unknown version '" + version + "' of artifact '" + artifactName + "'. Please contact the Dynatrace support team and temporarily deactivate Jetpack Compose instrumentation via the DSL property `composeEnabled`.");
        }
        if (matcher.group(4) != null) {
            throw new GradleException("Version '" + version + "' of artifact '" + artifactName + "' is not supported. Dynatrace Android Gradle plugin only supports the instrumentation of stable versions. You can either switch to a stable version or deactivate Jetpack Compose instrumentation via the DSL property `composeEnabled`.");
        }
        try {
            int minor = Integer.parseInt(matcher.group(2));
            if (!MAJOR_VERSION.equals(matcher.group(1)) || minor < 3 || minor > 8) {
                throw new GradleException("Version '" + version + "' of artifact '" + artifactName + "' is not supported. Please use the latest version of the Dynatrace Android Gradle plugin.");
            }
            logger.debug(artifactName + " version " + version + " confirmed");
        }
        catch (NumberFormatException e) {
            throw new GradleException("Dynatrace Android Gradle plugin is unable to parse the version '" + version + "' of artifact '" + artifactName + "'. Please contact the Dynatrace support team and temporarily deactivate Jetpack Compose instrumentation via the DSL property `composeEnabled`.");
        }
    }
}

