/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.method;

import com.dynatrace.android.instrumentation.MethodInstruction;
import com.dynatrace.android.instrumentation.sensor.method.MethodTransformation;
import com.dynatrace.android.instrumentation.sensor.method.ParameterInstructionProvider;
import com.dynatrace.android.instrumentation.shared.TransformerUtils;
import com.dynatrace.android.instrumentation.util.Utils;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ExitConstructorTransformation
implements MethodTransformation {
    private final MethodInstruction signature;
    private final ParameterInstructionProvider exitParamInstrProvider;

    public ExitConstructorTransformation(MethodInstruction signature, ParameterInstructionProvider exitParamInstrProvider) {
        this.signature = signature;
        this.exitParamInstrProvider = exitParamInstrProvider;
    }

    @Override
    public void transformMethod(MethodNode methodNode, int startParameterIndex) {
        TransformerUtils.InstructionFactory factory = instructions -> {
            if (this.exitParamInstrProvider != null) {
                this.exitParamInstrProvider.addParameterInstructions(instructions, startParameterIndex);
            }
            instructions.add((AbstractInsnNode)Utils.generateMethodInstructionNode(this.signature));
        };
        TransformerUtils.insertAtMethodExitWithoutExceptionHandling(methodNode, factory);
    }
}

