/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.compose.replay.transformation.material;

import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.sensor.compose.version.ComposeUi;
import com.dynatrace.android.instrumentation.sensor.method.MethodTransformation;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ComposeReplayRadioButtonTransformation
implements MethodTransformation {
    private final String composePackage;

    public ComposeReplayRadioButtonTransformation(ClassResolver classResolver) {
        this.composePackage = ComposeUi.getVersionPackage(classResolver);
    }

    @Override
    public void transformMethod(MethodNode methodNode, int startParameterIndex) {
        InsnList instructions = methodNode.instructions;
        for (int insIndex = 0; insIndex < instructions.size() - 1; ++insIndex) {
            AbstractInsnNode insNode = instructions.get(insIndex);
            AbstractInsnNode nextInsNode = instructions.get(insIndex + 1);
            if (!this.isGetStaticModifierCompanionNode(insNode) || !this.isStoreNode(nextInsNode)) continue;
            InsnList list = new InsnList();
            this.addCustomModifier(list);
            instructions.insert(insNode, list);
        }
    }

    private boolean isGetStaticModifierCompanionNode(AbstractInsnNode insNode) {
        return insNode instanceof FieldInsnNode && insNode.getOpcode() == 178 && ((FieldInsnNode)insNode).owner.equals("androidx/compose/ui/Modifier") && ((FieldInsnNode)insNode).name.equals("Companion");
    }

    private boolean isStoreNode(AbstractInsnNode insNode) {
        return insNode instanceof VarInsnNode && insNode.getOpcode() == 58;
    }

    private void addCustomModifier(InsnList list) {
        String dtCompoundRadioModifier = this.composePackage + "/model/DTCompoundRadioModifier";
        list.add((AbstractInsnNode)new TypeInsnNode(187, dtCompoundRadioModifier));
        list.add((AbstractInsnNode)new InsnNode(89));
        list.add((AbstractInsnNode)new LdcInsnNode((Object)3));
        list.add((AbstractInsnNode)new FieldInsnNode(178, "androidx/compose/material/RadioButtonKt", "RadioAnimationDuration", "I"));
        list.add((AbstractInsnNode)new MethodInsnNode(183, dtCompoundRadioModifier, "<init>", "(II)V", false));
        list.add((AbstractInsnNode)new MethodInsnNode(185, "androidx/compose/ui/Modifier", "then", "(Landroidx/compose/ui/Modifier;)Landroidx/compose/ui/Modifier;", true));
    }
}

