/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.png;

import com.drew.imaging.png.PngChromaticities;
import com.drew.imaging.png.PngChunk;
import com.drew.imaging.png.PngChunkReader;
import com.drew.imaging.png.PngChunkType;
import com.drew.imaging.png.PngHeader;
import com.drew.imaging.png.PngProcessingException;
import com.drew.lang.KeyValuePair;
import com.drew.lang.RandomAccessStreamReader;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.SequentialReader;
import com.drew.lang.StreamReader;
import com.drew.lang.StringUtil;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.icc.IccReader;
import com.drew.metadata.png.PngChromaticitiesDirectory;
import com.drew.metadata.png.PngDirectory;
import com.drew.metadata.xmp.XmpReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.TimeZone;
import java.util.zip.InflaterInputStream;

public class PngMetadataReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Metadata readMetadata(@NotNull File file) throws PngProcessingException, IOException {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            Metadata metadata = PngMetadataReader.readMetadata(inputStream);
            return metadata;
        }
        finally {
            if (inputStream != null) {
                ((InputStream)inputStream).close();
            }
        }
    }

    @NotNull
    public static Metadata readMetadata(@NotNull InputStream inputStream) throws PngProcessingException, IOException {
        HashSet<PngChunkType> desiredChunkTypes = new HashSet<PngChunkType>();
        desiredChunkTypes.add(PngChunkType.IHDR);
        desiredChunkTypes.add(PngChunkType.PLTE);
        desiredChunkTypes.add(PngChunkType.tRNS);
        desiredChunkTypes.add(PngChunkType.cHRM);
        desiredChunkTypes.add(PngChunkType.sRGB);
        desiredChunkTypes.add(PngChunkType.gAMA);
        desiredChunkTypes.add(PngChunkType.iCCP);
        desiredChunkTypes.add(PngChunkType.bKGD);
        desiredChunkTypes.add(PngChunkType.tEXt);
        desiredChunkTypes.add(PngChunkType.iTXt);
        desiredChunkTypes.add(PngChunkType.tIME);
        Iterable<PngChunk> chunks = new PngChunkReader().extract(new StreamReader(inputStream), desiredChunkTypes);
        Metadata metadata = new Metadata();
        ArrayList<KeyValuePair> textPairs = new ArrayList<KeyValuePair>();
        for (PngChunk chunk : chunks) {
            byte compressionMethod;
            PngChunkType chunkType = chunk.getType();
            byte[] bytes = chunk.getBytes();
            if (chunkType.equals(PngChunkType.IHDR)) {
                PngHeader header = new PngHeader(bytes);
                PngDirectory directory = metadata.getOrCreateDirectory(PngDirectory.class);
                directory.setInt(1, header.getImageWidth());
                directory.setInt(2, header.getImageHeight());
                directory.setInt(3, header.getBitsPerSample());
                directory.setInt(4, header.getColorType().getNumericValue());
                directory.setInt(5, header.getCompressionType());
                directory.setInt(6, header.getFilterMethod());
                directory.setInt(7, header.getInterlaceMethod());
                continue;
            }
            if (chunkType.equals(PngChunkType.PLTE)) {
                PngDirectory directory = metadata.getOrCreateDirectory(PngDirectory.class);
                directory.setInt(8, bytes.length / 3);
                continue;
            }
            if (chunkType.equals(PngChunkType.tRNS)) {
                PngDirectory directory = metadata.getOrCreateDirectory(PngDirectory.class);
                directory.setInt(9, 1);
                continue;
            }
            if (chunkType.equals(PngChunkType.sRGB)) {
                byte srgbRenderingIntent = new SequentialByteArrayReader(bytes).getInt8();
                PngDirectory directory = metadata.getOrCreateDirectory(PngDirectory.class);
                directory.setInt(10, srgbRenderingIntent);
                continue;
            }
            if (chunkType.equals(PngChunkType.cHRM)) {
                PngChromaticities chromaticities = new PngChromaticities(bytes);
                PngChromaticitiesDirectory directory = metadata.getOrCreateDirectory(PngChromaticitiesDirectory.class);
                directory.setInt(1, chromaticities.getWhitePointX());
                directory.setInt(1, chromaticities.getWhitePointX());
                directory.setInt(3, chromaticities.getRedX());
                directory.setInt(4, chromaticities.getRedY());
                directory.setInt(5, chromaticities.getGreenX());
                directory.setInt(6, chromaticities.getGreenY());
                directory.setInt(7, chromaticities.getBlueX());
                directory.setInt(8, chromaticities.getBlueY());
                continue;
            }
            if (chunkType.equals(PngChunkType.gAMA)) {
                int gammaInt = new SequentialByteArrayReader(bytes).getInt32();
                PngDirectory directory = metadata.getOrCreateDirectory(PngDirectory.class);
                directory.setDouble(11, (double)gammaInt / 100000.0);
                continue;
            }
            if (chunkType.equals(PngChunkType.iCCP)) {
                SequentialByteArrayReader reader = new SequentialByteArrayReader(bytes);
                String profileName = reader.getNullTerminatedString(79);
                PngDirectory directory = metadata.getOrCreateDirectory(PngDirectory.class);
                directory.setString(12, profileName);
                compressionMethod = reader.getInt8();
                if (compressionMethod != 0) continue;
                int bytesLeft = bytes.length - profileName.length() - 2;
                byte[] compressedProfile = ((SequentialReader)reader).getBytes(bytesLeft);
                InflaterInputStream inflateStream = new InflaterInputStream(new ByteArrayInputStream(compressedProfile));
                new IccReader().extract(new RandomAccessStreamReader(inflateStream), metadata);
                inflateStream.close();
                continue;
            }
            if (chunkType.equals(PngChunkType.bKGD)) {
                PngDirectory directory = metadata.getOrCreateDirectory(PngDirectory.class);
                directory.setByteArray(15, bytes);
                continue;
            }
            if (chunkType.equals(PngChunkType.tEXt)) {
                SequentialByteArrayReader reader = new SequentialByteArrayReader(bytes);
                String keyword = reader.getNullTerminatedString(79);
                int bytesLeft = bytes.length - keyword.length() - 1;
                String value = reader.getNullTerminatedString(bytesLeft);
                textPairs.add(new KeyValuePair(keyword, value));
                continue;
            }
            if (chunkType.equals(PngChunkType.iTXt)) {
                SequentialByteArrayReader reader = new SequentialByteArrayReader(bytes);
                String keyword = reader.getNullTerminatedString(79);
                byte compressionFlag = reader.getInt8();
                compressionMethod = reader.getInt8();
                String languageTag = reader.getNullTerminatedString(bytes.length);
                String translatedKeyword = reader.getNullTerminatedString(bytes.length);
                int bytesLeft = bytes.length - keyword.length() - 1 - 1 - 1 - languageTag.length() - 1 - translatedKeyword.length() - 1;
                String text = null;
                if (compressionFlag == 0) {
                    text = reader.getNullTerminatedString(bytesLeft);
                } else if (compressionFlag == 1) {
                    if (compressionMethod == 0) {
                        text = StringUtil.fromStream(new InflaterInputStream(new ByteArrayInputStream(bytes, bytes.length - bytesLeft, bytesLeft)));
                    } else {
                        metadata.getOrCreateDirectory(PngDirectory.class).addError("Invalid compression method value");
                    }
                } else {
                    metadata.getOrCreateDirectory(PngDirectory.class).addError("Invalid compression flag value");
                }
                if (text == null) continue;
                if (keyword.equals("XML:com.adobe.xmp")) {
                    new XmpReader().extract(text, metadata);
                    continue;
                }
                textPairs.add(new KeyValuePair(keyword, text));
                continue;
            }
            if (!chunkType.equals(PngChunkType.tIME)) continue;
            SequentialByteArrayReader reader = new SequentialByteArrayReader(bytes);
            int year = reader.getUInt16();
            int month = reader.getUInt8() - 1;
            short day = reader.getUInt8();
            short hour = reader.getUInt8();
            short minute = reader.getUInt8();
            short second = reader.getUInt8();
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            calendar.set(year, month, day, hour, minute, second);
            PngDirectory directory = metadata.getOrCreateDirectory(PngDirectory.class);
            directory.setDate(14, calendar.getTime());
        }
        if (textPairs.size() != 0) {
            PngDirectory directory = metadata.getOrCreateDirectory(PngDirectory.class);
            directory.setObject(13, textPairs);
        }
        return metadata;
    }
}

