/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.admin.api;

import com.docusign.admin.client.ApiClient;
import com.docusign.admin.client.ApiException;
import com.docusign.admin.client.Configuration;
import com.docusign.admin.client.Pair;
import com.docusign.admin.model.ProductPermissionProfilesRequest;
import com.docusign.admin.model.ProductPermissionProfilesResponse;
import com.docusign.admin.model.RemoveUserProductsResponse;
import com.docusign.admin.model.UserProductPermissionProfilesRequest;
import com.docusign.admin.model.UserProductPermissionProfilesResponse;
import com.docusign.admin.model.UserProductProfileDeleteRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javax.ws.rs.core.GenericType;

public class ProductPermissionProfilesApi {
    private ApiClient apiClient;

    public ProductPermissionProfilesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProductPermissionProfilesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public UserProductPermissionProfilesResponse addUserProductPermissionProfiles(UUID organizationId, UUID accountId, UUID userId, ProductPermissionProfilesRequest productPermissionProfilesRequest) throws ApiException {
        ProductPermissionProfilesRequest localVarPostBody = productPermissionProfilesRequest;
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling addUserProductPermissionProfiles");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling addUserProductPermissionProfiles");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling addUserProductPermissionProfiles");
        }
        if (productPermissionProfilesRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'productPermissionProfilesRequest' when calling addUserProductPermissionProfiles");
        }
        String localVarPath = "/v2.1/organizations/{organizationId}/accounts/{accountId}/products/users/{userId}/permission_profiles".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserProductPermissionProfilesResponse> localVarReturnType = new GenericType<UserProductPermissionProfilesResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserProductPermissionProfilesResponse addUserProductPermissionProfilesByEmail(UUID organizationId, UUID accountId, UserProductPermissionProfilesRequest userProductPermissionProfilesRequest) throws ApiException {
        UserProductPermissionProfilesRequest localVarPostBody = userProductPermissionProfilesRequest;
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling addUserProductPermissionProfilesByEmail");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling addUserProductPermissionProfilesByEmail");
        }
        if (userProductPermissionProfilesRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'userProductPermissionProfilesRequest' when calling addUserProductPermissionProfilesByEmail");
        }
        String localVarPath = "/v2.1/organizations/{organizationId}/accounts/{accountId}/products/permission_profiles/users".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserProductPermissionProfilesResponse> localVarReturnType = new GenericType<UserProductPermissionProfilesResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ProductPermissionProfilesResponse getProductPermissionProfiles(UUID organizationId, UUID accountId) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling getProductPermissionProfiles");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getProductPermissionProfiles");
        }
        String localVarPath = "/v2.1/organizations/{organizationId}/accounts/{accountId}/products/permission_profiles".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ProductPermissionProfilesResponse> localVarReturnType = new GenericType<ProductPermissionProfilesResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ProductPermissionProfilesResponse getUserProductPermissionProfiles(UUID organizationId, UUID accountId, UUID userId) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling getUserProductPermissionProfiles");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getUserProductPermissionProfiles");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getUserProductPermissionProfiles");
        }
        String localVarPath = "/v2.1/organizations/{organizationId}/accounts/{accountId}/products/users/{userId}/permission_profiles".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ProductPermissionProfilesResponse> localVarReturnType = new GenericType<ProductPermissionProfilesResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserProductPermissionProfilesResponse getUserProductPermissionProfilesByEmail(UUID organizationId, UUID accountId) throws ApiException {
        return this.getUserProductPermissionProfilesByEmail(organizationId, accountId, null);
    }

    public UserProductPermissionProfilesResponse getUserProductPermissionProfilesByEmail(UUID organizationId, UUID accountId, GetUserProductPermissionProfilesByEmailOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling getUserProductPermissionProfilesByEmail");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getUserProductPermissionProfilesByEmail");
        }
        String localVarPath = "/v2.1/organizations/{organizationId}/accounts/{accountId}/products/permission_profiles/users".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("email", options.email));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserProductPermissionProfilesResponse> localVarReturnType = new GenericType<UserProductPermissionProfilesResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RemoveUserProductsResponse removeUserProductPermission(UUID organizationId, UUID accountId, UserProductProfileDeleteRequest userProductPermissionProfilesRequest) throws ApiException {
        UserProductProfileDeleteRequest localVarPostBody = userProductPermissionProfilesRequest;
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling removeUserProductPermission");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling removeUserProductPermission");
        }
        if (userProductPermissionProfilesRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'userProductPermissionProfilesRequest' when calling removeUserProductPermission");
        }
        String localVarPath = "/v2.1/organizations/{organizationId}/accounts/{accountId}/products/users".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<RemoveUserProductsResponse> localVarReturnType = new GenericType<RemoveUserProductsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public class GetUserProductPermissionProfilesByEmailOptions {
        private String email = null;

        public void setEmail(String email) {
            this.email = email;
        }

        public String getEmail() {
            return this.email;
        }
    }
}

