/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.admin.api;

import com.docusign.admin.client.ApiClient;
import com.docusign.admin.client.ApiException;
import com.docusign.admin.client.Configuration;
import com.docusign.admin.client.Pair;
import com.docusign.admin.model.AddDSGroupAndUsersResponse;
import com.docusign.admin.model.DSGroupAddRequest;
import com.docusign.admin.model.DSGroupAndUsersResponse;
import com.docusign.admin.model.DSGroupListResponse;
import com.docusign.admin.model.DSGroupResponse;
import com.docusign.admin.model.DSGroupUsersAddRequest;
import com.docusign.admin.model.DSGroupUsersRemoveRequest;
import com.docusign.admin.model.RemoveDSGroupUsersResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javax.ws.rs.core.GenericType;

public class DsGroupsApi {
    private ApiClient apiClient;

    public DsGroupsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DsGroupsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public DSGroupResponse addDSGroup(UUID organizationId, UUID accountId, DSGroupAddRequest addRequest) throws ApiException {
        DSGroupAddRequest localVarPostBody = addRequest;
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling addDSGroup");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling addDSGroup");
        }
        if (addRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'addRequest' when calling addDSGroup");
        }
        String localVarPath = "/v2.1/organizations/{organizationId}/accounts/{accountId}/dsgroups".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DSGroupResponse> localVarReturnType = new GenericType<DSGroupResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AddDSGroupAndUsersResponse addDSGroupUsers(UUID organizationId, UUID accountId, UUID dsGroupId, DSGroupUsersAddRequest dSGroupUsersAddRequest) throws ApiException {
        DSGroupUsersAddRequest localVarPostBody = dSGroupUsersAddRequest;
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling addDSGroupUsers");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling addDSGroupUsers");
        }
        if (dsGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'dsGroupId' when calling addDSGroupUsers");
        }
        if (dSGroupUsersAddRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'dSGroupUsersAddRequest' when calling addDSGroupUsers");
        }
        String localVarPath = "/v2.1/organizations/{organizationId}/accounts/{accountId}/dsgroups/{dsGroupId}/users".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{dsGroupId\\}", this.apiClient.escapeString(dsGroupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<AddDSGroupAndUsersResponse> localVarReturnType = new GenericType<AddDSGroupAndUsersResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteDSGroup(UUID organizationId, UUID accountId, UUID dsGroupId) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling deleteDSGroup");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteDSGroup");
        }
        if (dsGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'dsGroupId' when calling deleteDSGroup");
        }
        String localVarPath = "/v2.1/organizations/{organizationId}/accounts/{accountId}/dsgroups/{dsGroupId}".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{dsGroupId\\}", this.apiClient.escapeString(dsGroupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public DSGroupResponse getDSGroup(UUID organizationId, UUID accountId, UUID dsGroupId) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling getDSGroup");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getDSGroup");
        }
        if (dsGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'dsGroupId' when calling getDSGroup");
        }
        String localVarPath = "/v2.1/organizations/{organizationId}/accounts/{accountId}/dsgroups/{dsGroupId}".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{dsGroupId\\}", this.apiClient.escapeString(dsGroupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DSGroupResponse> localVarReturnType = new GenericType<DSGroupResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DSGroupAndUsersResponse getDSGroupUsers(UUID organizationId, UUID accountId, UUID dsGroupId) throws ApiException {
        return this.getDSGroupUsers(organizationId, accountId, dsGroupId, null);
    }

    public DSGroupAndUsersResponse getDSGroupUsers(UUID organizationId, UUID accountId, UUID dsGroupId, GetDSGroupUsersOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling getDSGroupUsers");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getDSGroupUsers");
        }
        if (dsGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'dsGroupId' when calling getDSGroupUsers");
        }
        String localVarPath = "/v2.1/organizations/{organizationId}/accounts/{accountId}/dsgroups/{dsGroupId}/users".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{dsGroupId\\}", this.apiClient.escapeString(dsGroupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", options.page));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_size", options.pageSize));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DSGroupAndUsersResponse> localVarReturnType = new GenericType<DSGroupAndUsersResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DSGroupListResponse getDSGroups(UUID organizationId, UUID accountId) throws ApiException {
        return this.getDSGroups(organizationId, accountId, null);
    }

    public DSGroupListResponse getDSGroups(UUID organizationId, UUID accountId, GetDSGroupsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling getDSGroups");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getDSGroups");
        }
        String localVarPath = "/v2.1/organizations/{organizationId}/accounts/{accountId}/dsgroups".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", options.page));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_size", options.pageSize));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DSGroupListResponse> localVarReturnType = new GenericType<DSGroupListResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RemoveDSGroupUsersResponse removeDSGroupUsers(UUID organizationId, UUID accountId, UUID dsGroupId, DSGroupUsersRemoveRequest dSGroupUsersRemoveRequest) throws ApiException {
        DSGroupUsersRemoveRequest localVarPostBody = dSGroupUsersRemoveRequest;
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling removeDSGroupUsers");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling removeDSGroupUsers");
        }
        if (dsGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'dsGroupId' when calling removeDSGroupUsers");
        }
        if (dSGroupUsersRemoveRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'dSGroupUsersRemoveRequest' when calling removeDSGroupUsers");
        }
        String localVarPath = "/v2.1/organizations/{organizationId}/accounts/{accountId}/dsgroups/{dsGroupId}/users".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{dsGroupId\\}", this.apiClient.escapeString(dsGroupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<RemoveDSGroupUsersResponse> localVarReturnType = new GenericType<RemoveDSGroupUsersResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public class GetDSGroupsOptions {
        private Integer page = null;
        private Integer pageSize = null;

        public void setPage(Integer page) {
            this.page = page;
        }

        public Integer getPage() {
            return this.page;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }
    }

    public class GetDSGroupUsersOptions {
        private Integer page = null;
        private Integer pageSize = null;

        public void setPage(Integer page) {
            this.page = page;
        }

        public Integer getPage() {
            return this.page;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }
    }
}

