/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils.json.resourcerecords;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.CharMatcher;
import java.io.IOException;
import org.xbill.DNS.Name;
import org.xbill.DNS.SPFRecord;
import org.xbill.DNS.utils.json.exception.JsonDeserializationException;
import org.xbill.DNS.utils.json.resourcerecords.AbstractRecordDeserializer;

public class SPFRecordDeserializer
extends AbstractRecordDeserializer<SPFRecord> {
    private static final long serialVersionUID = 988481497237099680L;
    private static final String STRINGS_FIELD_NAME = "strings";

    public SPFRecordDeserializer() {
        super(SPFRecord.class);
    }

    @Override
    protected SPFRecord createRecord(Name name, int dclass, long ttl, ObjectNode recordNode) {
        try {
            String strings = this.getNodeStringValue(recordNode, STRINGS_FIELD_NAME);
            if (!CharMatcher.ASCII.matchesAllOf((CharSequence)strings)) {
                throw new JsonDeserializationException(JsonDeserializationException.JsonDeserializationExceptionCode.invalidFieldValue, STRINGS_FIELD_NAME, this.getTextualBeanType(), "Non-ASCII character found");
            }
            return (SPFRecord)SPFRecord.fromString(name, 99, dclass, ttl, strings, Name.root);
        }
        catch (IOException e) {
            throw new JsonDeserializationException(JsonDeserializationException.JsonDeserializationExceptionCode.unexpectedMappingError, (Throwable)e, this.getTextualBeanType(), e.getMessage());
        }
    }

    @Override
    protected String getTextualRecordType() {
        return "SPF";
    }
}

