/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils.json.resourcerecords;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xbill.DNS.Record;
import org.xbill.DNS.utils.json.exception.JsonDeserializationException;

public class RecordTypeReferenceDeserializer
extends StdDeserializer<Record> {
    private static final long serialVersionUID = 3048754137709241877L;
    public static final String TYPE_FIELD_NAME = "type";
    private final Map<String, Class<? extends Record>> recordClassesRegistry = new HashMap<String, Class<? extends Record>>();

    public RecordTypeReferenceDeserializer() {
        super(Record.class);
    }

    public void registerRecordType(String typeValue, Class<? extends Record> recordClass) {
        this.recordClassesRegistry.put(typeValue, recordClass);
    }

    public Record deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws JsonProcessingException, IOException {
        ObjectMapper mapper = (ObjectMapper)jsonParser.getCodec();
        ObjectReader reader = mapper.reader().without(DeserializationFeature.UNWRAP_ROOT_VALUE);
        ObjectNode recordNode = (ObjectNode)reader.readTree(jsonParser);
        JsonNode recordTypeNode = recordNode.get(TYPE_FIELD_NAME);
        if (recordTypeNode == null) {
            throw new JsonDeserializationException(JsonDeserializationException.JsonDeserializationExceptionCode.missingField, TYPE_FIELD_NAME, "resource record");
        }
        String recordType = recordTypeNode.textValue();
        Class<? extends Record> recordClass = this.recordClassesRegistry.get(recordType);
        if (recordClass == null) {
            throw new JsonDeserializationException(JsonDeserializationException.JsonDeserializationExceptionCode.unknownResourceRecordType, recordType);
        }
        return (Record)reader.withType(recordClass).readValue(recordNode.toString());
    }
}

