/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils.json.resourcerecords;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.xbill.DNS.NAPTRRecord;
import org.xbill.DNS.utils.json.resourcerecords.AbstractRecordSerializer;

public class NAPTRRecordSerializer
extends AbstractRecordSerializer<NAPTRRecord> {
    public NAPTRRecordSerializer() {
        super(NAPTRRecord.class);
    }

    @Override
    protected void serializeRDataFields(NAPTRRecord naptrRecord, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        jsonGenerator.writeStringField("order", this.formatNumber(naptrRecord.getOrder()));
        jsonGenerator.writeStringField("preference", this.formatNumber(naptrRecord.getPreference()));
        jsonGenerator.writeStringField("flags", naptrRecord.getFlags());
        jsonGenerator.writeStringField("service", naptrRecord.getService());
        jsonGenerator.writeStringField("regexp", naptrRecord.getRegexp());
        if (naptrRecord.getReplacement() != null) {
            jsonGenerator.writeStringField("replacement", naptrRecord.getReplacement().toString());
        }
    }
}

